/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class InputOptions
implements Options {
    private String name;
    private String nameFormat;
    private String typeNameFormat;

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.name, "'name' option on Input Options is null", new Object[0]).assertNotNull(this.typeNameFormat, "'typeNameFormat' option on Input Options is null", new Object[0]);
    }

    public void override(InputOptions overrideOptions) {
        if (overrideOptions.name != null) {
            this.setName(overrideOptions.name);
        }
        if (overrideOptions.nameFormat != null) {
            this.setNameFormat(overrideOptions.nameFormat);
        }
        if (overrideOptions.typeNameFormat != null) {
            this.setTypeNameFormat(overrideOptions.typeNameFormat);
        }
    }

    @JsonIgnore
    public final String getNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.nameFormat != null ? String.format(this.nameFormat, StringUtils.toParameterCase(name)) : this.name;
    }

    @JsonIgnore
    public final String getNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getNameFor(type.getName());
    }

    @JsonIgnore
    public final String getTypeNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.typeNameFormat, name);
    }

    @JsonIgnore
    public final String getTypeNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getTypeNameFor(type.getName());
    }

    @JsonIgnore
    public final String getTypeNameForQuery(@NonNull String queryName) {
        if (queryName == null) {
            throw new NullPointerException("queryName is marked non-null but is null");
        }
        return String.format(this.typeNameFormat, StringUtils.toSentenceCase(queryName));
    }

    private String getName() {
        return this.name;
    }

    private String getNameFormat() {
        return this.nameFormat;
    }

    private String getTypeNameFormat() {
        return this.typeNameFormat;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public void setTypeNameFormat(String typeNameFormat) {
        this.typeNameFormat = typeNameFormat;
    }

    private InputOptions() {
    }

    private InputOptions(String name, String nameFormat, String typeNameFormat) {
        this.name = name;
        this.nameFormat = nameFormat;
        this.typeNameFormat = typeNameFormat;
    }
}

