/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.markdown;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.BrAPIClassCacheUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownGenerator {
    private static final Logger log = LoggerFactory.getLogger(MarkdownGenerator.class);
    private final BrAPISchemaReader schemaReader = new BrAPISchemaReader();
    private Path outputPath;
    private boolean overwrite;

    public Response<List<Path>> generate(Path schemaDirectory) {
        return this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator((List<BrAPIClass>)brAPISchemas).generate());
    }

    public MarkdownGenerator(Path outputPath, boolean overwrite) {
        this.outputPath = outputPath;
        this.overwrite = overwrite;
    }

    private class Generator {
        private final Map<String, BrAPIClass> brAPIClasses;
        private final Path descriptionsPath;
        private final Path fieldsPath;

        public Generator(List<BrAPIClass> brAPIClasses) {
            this.brAPIClasses = new BrAPIClassCacheUtil(this::isGenerating).createMap(brAPIClasses);
            this.descriptionsPath = MarkdownGenerator.this.outputPath.resolve("descriptions");
            this.fieldsPath = MarkdownGenerator.this.outputPath.resolve("fields");
        }

        public Response<List<Path>> generate() {
            try {
                Files.createDirectories(this.descriptionsPath, new FileAttribute[0]);
                Files.createDirectories(this.fieldsPath, new FileAttribute[0]);
                return this.generateMarkdownFiles(new ArrayList<BrAPIClass>(this.brAPIClasses.values()));
            }
            catch (Exception e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private boolean isGenerating(BrAPIClass brAPIClass) {
            return brAPIClass.getMetadata() == null || !brAPIClass.getMetadata().isRequest() && !brAPIClass.getMetadata().isParameters();
        }

        private Response<List<Path>> generateMarkdownFiles(List<BrAPIClass> brAPIClasses) {
            return brAPIClasses.stream().map(this::generateMarkdown).collect(Response.mergeLists());
        }

        private Response<List<Path>> generateMarkdown(BrAPIClass brAPIClass) {
            if (brAPIClass instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                return this.generateMarkdownForObjectType(brAPIObjectType);
            }
            if (brAPIClass instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIClass;
                return this.generateMarkdownForOneOfType(brAPIOneOfType);
            }
            if (brAPIClass instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)brAPIClass;
                return this.generateMarkdownForEnumType(brAPIEnumType);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown type '%s'", brAPIClass.getName()));
        }

        private Response<List<Path>> generateMarkdownForObjectType(BrAPIObjectType brAPIObjectType) {
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.descriptionsPath.resolve(String.format("%s.md", brAPIObjectType.getName()));
            Path fieldsPath = this.fieldsPath.resolve(brAPIObjectType.getName());
            try {
                Files.createDirectories(fieldsPath, new FileAttribute[0]);
                return this.writeToFile(descriptionPath, brAPIObjectType.getDescription()).onSuccessDoWithResult(paths::addAll).map(() -> this.generateMarkdownForProperties(fieldsPath, brAPIObjectType.getProperties())).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
            }
            catch (IOException e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private Response<List<Path>> generateMarkdownForProperties(Path fieldsPath, List<BrAPIObjectProperty> properties) {
            return properties.stream().map(property -> this.generateMarkdownForProperty(fieldsPath, (BrAPIObjectProperty)property)).collect(Response.mergeLists());
        }

        private Response<List<Path>> generateMarkdownForProperty(Path path, BrAPIObjectProperty property) {
            Path fieldPath = path.resolve(String.format("%s.md", property.getName()));
            return this.writeToFile(fieldPath, property.getDescription());
        }

        private Response<List<Path>> generateMarkdownForOneOfType(BrAPIOneOfType brAPIOneOfType) {
            return Response.success(Collections.emptyList());
        }

        private Response<List<Path>> generateMarkdownForEnumType(BrAPIEnumType brAPIEnumType) {
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.descriptionsPath.resolve(String.format("%s.md", brAPIEnumType.getName()));
            return this.writeToFile(descriptionPath, this.createDescription(brAPIEnumType)).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private String createDescription(BrAPIEnumType brAPIEnumType) {
            StringBuilder description = new StringBuilder(brAPIEnumType.getDescription() != null ? brAPIEnumType.getDescription() : "");
            description.append("\n\n Possible values are: \n");
            for (BrAPIEnumValue value : brAPIEnumType.getValues()) {
                description.append("* ").append(value.getName()).append("\n");
            }
            return description.toString();
        }

        private Response<List<Path>> writeToFile(Path path, String text) {
            try {
                if (MarkdownGenerator.this.overwrite && Files.exists(path, new LinkOption[0])) {
                    log.warn("Output file '{}' already exists and was not overwritten", (Object)path);
                    return Response.success(Collections.emptyList());
                }
                PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]));
                printWriter.println(text != null ? text : "TODO description");
                printWriter.close();
                return Response.success(Collections.singletonList(path));
            }
            catch (IOException exception) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not write to file due to %s", exception.getMessage()));
            }
        }
    }
}

