/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public final class BrAPIMetadata {
    private final boolean primaryModel;
    private final boolean request;
    private final boolean parameters;
    @JsonProperty(value="interface")
    private final boolean interfaceClass;

    BrAPIMetadata(boolean primaryModel, boolean request, boolean parameters, boolean interfaceClass) {
        this.primaryModel = primaryModel;
        this.request = request;
        this.parameters = parameters;
        this.interfaceClass = interfaceClass;
    }

    public static BrAPIMetadataBuilder builder() {
        return new BrAPIMetadataBuilder();
    }

    public BrAPIMetadataBuilder toBuilder() {
        return new BrAPIMetadataBuilder().primaryModel(this.primaryModel).request(this.request).parameters(this.parameters).interfaceClass(this.interfaceClass);
    }

    public boolean isPrimaryModel() {
        return this.primaryModel;
    }

    public boolean isRequest() {
        return this.request;
    }

    public boolean isParameters() {
        return this.parameters;
    }

    public boolean isInterfaceClass() {
        return this.interfaceClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrAPIMetadata)) {
            return false;
        }
        BrAPIMetadata other = (BrAPIMetadata)o;
        if (this.isPrimaryModel() != other.isPrimaryModel()) {
            return false;
        }
        if (this.isRequest() != other.isRequest()) {
            return false;
        }
        if (this.isParameters() != other.isParameters()) {
            return false;
        }
        return this.isInterfaceClass() == other.isInterfaceClass();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimaryModel() ? 79 : 97);
        result = result * 59 + (this.isRequest() ? 79 : 97);
        result = result * 59 + (this.isParameters() ? 79 : 97);
        result = result * 59 + (this.isInterfaceClass() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BrAPIMetadata(primaryModel=" + this.isPrimaryModel() + ", request=" + this.isRequest() + ", parameters=" + this.isParameters() + ", interfaceClass=" + this.isInterfaceClass() + ")";
    }

    public static class BrAPIMetadataBuilder {
        private boolean primaryModel;
        private boolean request;
        private boolean parameters;
        private boolean interfaceClass;

        BrAPIMetadataBuilder() {
        }

        public BrAPIMetadataBuilder primaryModel(boolean primaryModel) {
            this.primaryModel = primaryModel;
            return this;
        }

        public BrAPIMetadataBuilder request(boolean request) {
            this.request = request;
            return this;
        }

        public BrAPIMetadataBuilder parameters(boolean parameters) {
            this.parameters = parameters;
            return this;
        }

        @JsonProperty(value="interface")
        public BrAPIMetadataBuilder interfaceClass(boolean interfaceClass) {
            this.interfaceClass = interfaceClass;
            return this;
        }

        public BrAPIMetadata build() {
            return new BrAPIMetadata(this.primaryModel, this.request, this.parameters, this.interfaceClass);
        }

        public String toString() {
            return "BrAPIMetadata.BrAPIMetadataBuilder(primaryModel=" + this.primaryModel + ", request=" + this.request + ", parameters=" + this.parameters + ", interfaceClass=" + this.interfaceClass + ")";
        }
    }
}

