/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.brapi.schematools.core.response.Response;

public enum BrAPIRelationshipType {
    ONE_TO_ONE("one-to-one"),
    ONE_TO_MANY("one-to-many"),
    MANY_TO_ONE("many-to-one"),
    MANY_TO_MANY("many-to-many");

    final String label;

    public static Response<BrAPIRelationshipType> fromNameOrLabel(String nameOrLabel) {
        return BrAPIRelationshipType.findByNameOrLabel(nameOrLabel).map(Response::success).orElseGet(() -> Response.fail(Response.ErrorType.VALIDATION, String.format("No BrAPIRelationshipType found for name or label [%s]", nameOrLabel)));
    }

    public static Response<List<BrAPIRelationshipType>> fromNameOrLabels(List<String> nameOrLabels) {
        return nameOrLabels.stream().map(BrAPIRelationshipType::fromNameOrLabel).collect(Response.toList());
    }

    public static Optional<BrAPIRelationshipType> findByNameOrLabel(String nameOrLabel) {
        return Stream.of(BrAPIRelationshipType.values()).filter(type -> type.name().equalsIgnoreCase(nameOrLabel) || type.getLabel().equalsIgnoreCase(nameOrLabel)).findAny();
    }

    public String getLabel() {
        return this.label;
    }

    private BrAPIRelationshipType(String label) {
        this.label = label;
    }
}

