/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.ontmodel.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.brapi.schematools.core.metadata.Metadata;
import org.brapi.schematools.core.utils.ConfigurationUtils;

public class OntModelGeneratorMetadata
implements Metadata {
    private String namespace;
    private String language;

    public static OntModelGeneratorMetadata load() {
        try {
            return ConfigurationUtils.load("ont-model-metadata.yaml", OntModelGeneratorMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OntModelGeneratorMetadata load(Path metadataFile) throws IOException {
        return OntModelGeneratorMetadata.load().override(ConfigurationUtils.load(metadataFile, OntModelGeneratorMetadata.class));
    }

    public static OntModelGeneratorMetadata load(InputStream inputStream) throws IOException {
        return OntModelGeneratorMetadata.load().override(ConfigurationUtils.load(inputStream, OntModelGeneratorMetadata.class));
    }

    public OntModelGeneratorMetadata override(OntModelGeneratorMetadata overrideMetadata) {
        if (overrideMetadata.namespace != null) {
            this.setNamespace(overrideMetadata.namespace);
        }
        if (overrideMetadata.language != null) {
            this.setLanguage(overrideMetadata.language);
        }
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

