/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.ontmodel.options;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.validiation.Validation;

public class OntModelGeneratorOptions
implements Options {
    String name;

    public static OntModelGeneratorOptions load(Path optionsFile) throws IOException {
        return OntModelGeneratorOptions.load(Files.newInputStream(optionsFile, new OpenOption[0]));
    }

    public static OntModelGeneratorOptions load() {
        try {
            InputStream inputStream = OntModelGeneratorOptions.class.getClassLoader().getResourceAsStream("ont-model-options.yaml");
            return OntModelGeneratorOptions.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static OntModelGeneratorOptions load(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (OntModelGeneratorOptions)mapper.readValue(inputStream, OntModelGeneratorOptions.class);
    }

    @Override
    public Validation validate() {
        return Validation.valid();
    }

    public String getName() {
        return this.name;
    }

    private OntModelGeneratorOptions setName(String name) {
        this.name = name;
        return this;
    }

    private OntModelGeneratorOptions() {
    }
}

