/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.brapi.schematools.core.metadata.Metadata;
import org.brapi.schematools.core.openapi.generator.metadata.DeleteMetadata;
import org.brapi.schematools.core.openapi.generator.metadata.ListGetMetadata;
import org.brapi.schematools.core.openapi.generator.metadata.PostMetadata;
import org.brapi.schematools.core.openapi.generator.metadata.PutMetadata;
import org.brapi.schematools.core.openapi.generator.metadata.SearchMetadata;
import org.brapi.schematools.core.openapi.generator.metadata.SingleGetMetadata;
import org.brapi.schematools.core.utils.ConfigurationUtils;

public class OpenAPIGeneratorMetadata
implements Metadata {
    private String title;
    private String version;
    private Map<String, String> titleFor = new HashMap<String, String>();
    private SingleGetMetadata singleGet = new SingleGetMetadata();
    private ListGetMetadata listGet = new ListGetMetadata();
    private PostMetadata post = new PostMetadata();
    private PutMetadata put = new PutMetadata();
    private DeleteMetadata delete = new DeleteMetadata();
    private SearchMetadata search = new SearchMetadata();

    public static OpenAPIGeneratorMetadata load() {
        try {
            return ConfigurationUtils.load("openapi-metadata.yaml", OpenAPIGeneratorMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenAPIGeneratorMetadata load(Path metadataFile) throws IOException {
        return OpenAPIGeneratorMetadata.load().override(ConfigurationUtils.load(metadataFile, OpenAPIGeneratorMetadata.class));
    }

    public static OpenAPIGeneratorMetadata load(InputStream inputStream) throws IOException {
        return OpenAPIGeneratorMetadata.load().override(ConfigurationUtils.load(inputStream, OpenAPIGeneratorMetadata.class));
    }

    public OpenAPIGeneratorMetadata override(OpenAPIGeneratorMetadata overrideMetadata) {
        if (overrideMetadata.title != null) {
            this.setTitle(overrideMetadata.title);
        }
        if (overrideMetadata.version != null) {
            this.setVersion(overrideMetadata.version);
        }
        this.titleFor.putAll(overrideMetadata.titleFor);
        if (overrideMetadata.singleGet != null) {
            this.singleGet.override(overrideMetadata.getSingleGet());
        }
        if (overrideMetadata.listGet != null) {
            this.listGet.override(overrideMetadata.getListGet());
        }
        if (overrideMetadata.post != null) {
            this.post.override(overrideMetadata.getPost());
        }
        if (overrideMetadata.put != null) {
            this.put.override(overrideMetadata.getPut());
        }
        if (overrideMetadata.search != null) {
            this.search.override(overrideMetadata.getSearch());
        }
        return this;
    }

    public String getTitleFor(String name) {
        return this.titleFor.getOrDefault(name, name);
    }

    @JsonIgnore
    public OpenAPIGeneratorMetadata setTitleFor(String name, String title) {
        this.titleFor.put(name, title);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getTitleFor() {
        return this.titleFor;
    }

    public SingleGetMetadata getSingleGet() {
        return this.singleGet;
    }

    public ListGetMetadata getListGet() {
        return this.listGet;
    }

    public PostMetadata getPost() {
        return this.post;
    }

    public PutMetadata getPut() {
        return this.put;
    }

    public DeleteMetadata getDelete() {
        return this.delete;
    }

    public SearchMetadata getSearch() {
        return this.search;
    }

    public OpenAPIGeneratorMetadata setTitle(String title) {
        this.title = title;
        return this;
    }

    public OpenAPIGeneratorMetadata setVersion(String version) {
        this.version = version;
        return this;
    }

    public OpenAPIGeneratorMetadata setSingleGet(SingleGetMetadata singleGet) {
        this.singleGet = singleGet;
        return this;
    }

    public OpenAPIGeneratorMetadata setListGet(ListGetMetadata listGet) {
        this.listGet = listGet;
        return this;
    }

    public OpenAPIGeneratorMetadata setPost(PostMetadata post) {
        this.post = post;
        return this;
    }

    public OpenAPIGeneratorMetadata setPut(PutMetadata put) {
        this.put = put;
        return this;
    }

    public OpenAPIGeneratorMetadata setDelete(DeleteMetadata delete) {
        this.delete = delete;
        return this;
    }

    public OpenAPIGeneratorMetadata setSearch(SearchMetadata search) {
        this.search = search;
        return this;
    }

    private OpenAPIGeneratorMetadata setTitleFor(Map<String, String> titleFor) {
        this.titleFor = titleFor;
        return this;
    }
}

