/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.AbstractGeneratorSubOptions;
import org.brapi.schematools.core.validiation.Validation;

public abstract class AbstractOpenAPIOptions
extends AbstractGeneratorSubOptions {
    private String summaryFormat;

    @Override
    public Validation validate() {
        return super.validate().assertNotNull(this.summaryFormat, "'summaryFormat' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(AbstractOpenAPIOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.summaryFormat != null) {
            this.setSummaryFormat(overrideOptions.summaryFormat);
        }
    }

    @JsonIgnore
    public final String getSummaryFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.summaryFormat, name);
    }

    @JsonIgnore
    public final String getSummaryFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getSummaryFor(type.getName());
    }

    private String getSummaryFormat() {
        return this.summaryFormat;
    }

    public void setSummaryFormat(String summaryFormat) {
        this.summaryFormat = summaryFormat;
    }

    protected AbstractOpenAPIOptions() {
    }

    protected AbstractOpenAPIOptions(String summaryFormat) {
        this.summaryFormat = summaryFormat;
    }
}

