/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.options.AbstractOpenAPIOptions;
import org.brapi.schematools.core.validiation.Validation;

public class ListGetOptions
extends AbstractOpenAPIOptions {
    private Boolean pagedDefault;
    private Map<String, Boolean> paged = new HashMap<String, Boolean>();
    private Map<String, Boolean> inputFor = new HashMap<String, Boolean>();
    private Boolean propertiesFromRequest;
    private Map<String, Map<String, Boolean>> propertyFromRequestFor = new HashMap<String, Map<String, Boolean>>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.pagedDefault, "'pagedDefault' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.paged, "'paged' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.inputFor, "'inputFor' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.propertiesFromRequest, "'propertiesFromRequest' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.propertyFromRequestFor, "'propertyFromRequestFor' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(ListGetOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.pagedDefault != null) {
            this.setPagedDefault(overrideOptions.pagedDefault);
        }
        this.paged.putAll(overrideOptions.paged);
        this.inputFor.putAll(overrideOptions.inputFor);
        if (overrideOptions.propertiesFromRequest != null) {
            this.setPropertiesFromRequest(overrideOptions.propertiesFromRequest);
        }
        if (overrideOptions.propertyFromRequestFor != null) {
            overrideOptions.propertyFromRequestFor.forEach((key, value) -> {
                if (this.propertyFromRequestFor.containsKey(key)) {
                    this.propertyFromRequestFor.get(key).putAll((Map<String, Boolean>)value);
                } else {
                    this.propertyFromRequestFor.put((String)key, new HashMap(value));
                }
            });
        }
    }

    @JsonIgnore
    public boolean isPagedFor(String name) {
        return this.paged.getOrDefault(name, this.pagedDefault);
    }

    public boolean isPagedFor(BrAPIType type) {
        return this.isPagedFor(type.getName());
    }

    @JsonIgnore
    public ListGetOptions setPagingFor(String name, boolean generate) {
        this.paged.put(name, generate);
        return this;
    }

    @JsonIgnore
    public ListGetOptions setPagingFor(BrAPIType type, boolean generate) {
        return this.setPagingFor(type.getName(), generate);
    }

    @JsonIgnore
    public boolean hasInputFor(String name) {
        return this.inputFor.getOrDefault(name, this.pagedDefault);
    }

    public boolean hasInputFor(BrAPIType type) {
        return this.hasInputFor(type.getName());
    }

    @JsonIgnore
    public ListGetOptions setInputFor(String name, boolean generate) {
        this.inputFor.put(name, generate);
        return this;
    }

    @JsonIgnore
    public ListGetOptions setInputFor(BrAPIType type, boolean generate) {
        return this.setInputFor(type.getName(), generate);
    }

    public boolean isUsingPropertyFromRequestFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        Map<String, Boolean> map = this.propertyFromRequestFor.get(type.getName());
        if (map != null) {
            return map.getOrDefault(property.getName(), this.propertiesFromRequest);
        }
        return this.propertiesFromRequest;
    }

    private Boolean getPagedDefault() {
        return this.pagedDefault;
    }

    private Map<String, Boolean> getPaged() {
        return this.paged;
    }

    private Map<String, Boolean> getInputFor() {
        return this.inputFor;
    }

    private Boolean getPropertiesFromRequest() {
        return this.propertiesFromRequest;
    }

    private Map<String, Map<String, Boolean>> getPropertyFromRequestFor() {
        return this.propertyFromRequestFor;
    }

    public void setPagedDefault(Boolean pagedDefault) {
        this.pagedDefault = pagedDefault;
    }

    public void setPropertiesFromRequest(Boolean propertiesFromRequest) {
        this.propertiesFromRequest = propertiesFromRequest;
    }

    public void setPropertyFromRequestFor(Map<String, Map<String, Boolean>> propertyFromRequestFor) {
        this.propertyFromRequestFor = propertyFromRequestFor;
    }

    private void setPaged(Map<String, Boolean> paged) {
        this.paged = paged;
    }

    private void setInputFor(Map<String, Boolean> inputFor) {
        this.inputFor = inputFor;
    }
}

