/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.options.AbstractOpenAPIOptions;

public class PutOptions
extends AbstractOpenAPIOptions {
    private Boolean multiple;
    private Map<String, Boolean> multipleFor = new HashMap<String, Boolean>();

    public void override(PutOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.multiple != null) {
            this.setMultiple(overrideOptions.multiple);
        }
        if (overrideOptions.multipleFor != null) {
            this.multipleFor.putAll(overrideOptions.multipleFor);
        }
    }

    @JsonIgnore
    public final boolean isMultipleFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.multipleFor.getOrDefault(name, this.multiple);
    }

    @JsonIgnore
    public final boolean isMultipleFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isMultipleFor(type.getName());
    }

    @JsonIgnore
    public PutOptions setMultipleFor(String name, boolean multiple) {
        this.multipleFor.put(name, multiple);
        return this;
    }

    @JsonIgnore
    public PutOptions setMultipleFor(BrAPIType type, boolean multiple) {
        return this.setMultipleFor(type.getName(), multiple);
    }

    public boolean isGeneratingEndpointFor(String name) {
        return this.isGeneratingFor(name) && this.isMultipleFor(name);
    }

    public boolean isGeneratingEndpointFor(BrAPIObjectType type) {
        return this.isGeneratingEndpointFor(type.getName());
    }

    public boolean isGeneratingEndpointNameWithIdFor(String name) {
        return this.isGeneratingFor(name) && !this.isMultipleFor(name);
    }

    public boolean isGeneratingEndpointNameWithIdFor(BrAPIObjectType type) {
        return this.isGeneratingEndpointNameWithIdFor(type.getName());
    }

    private Boolean getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    private void setMultipleFor(Map<String, Boolean> multipleFor) {
        this.multipleFor = multipleFor;
    }
}

