/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.options.AbstractOpenAPIOptions;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class SearchOptions
extends AbstractOpenAPIOptions {
    private String searchIdFieldName;
    private String submitDescriptionFormat;
    private String retrieveDescriptionFormat;

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.searchIdFieldName, "'searchIdFieldName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.submitDescriptionFormat, "'submitDescriptionFormat' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.retrieveDescriptionFormat, "'retrieveDescriptionFormat' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(SearchOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.searchIdFieldName != null) {
            this.setSearchIdFieldName(overrideOptions.searchIdFieldName);
        }
        if (overrideOptions.submitDescriptionFormat != null) {
            this.setSubmitDescriptionFormat(overrideOptions.submitDescriptionFormat);
        }
        if (overrideOptions.retrieveDescriptionFormat != null) {
            this.setRetrieveDescriptionFormat(overrideOptions.retrieveDescriptionFormat);
        }
    }

    @JsonIgnore
    public final String getSubmitDescriptionFormat(BrAPIType type) {
        return String.format(this.submitDescriptionFormat, type.getName(), StringUtils.toParameterCase(type.getName()));
    }

    @JsonIgnore
    public final String getRetrieveDescriptionFormat(BrAPIType type) {
        return String.format(this.retrieveDescriptionFormat, type.getName(), StringUtils.toParameterCase(type.getName()));
    }

    private String getSubmitDescriptionFormat() {
        return this.submitDescriptionFormat;
    }

    private String getRetrieveDescriptionFormat() {
        return this.retrieveDescriptionFormat;
    }

    public void setSearchIdFieldName(String searchIdFieldName) {
        this.searchIdFieldName = searchIdFieldName;
    }

    public void setSubmitDescriptionFormat(String submitDescriptionFormat) {
        this.submitDescriptionFormat = submitDescriptionFormat;
    }

    public void setRetrieveDescriptionFormat(String retrieveDescriptionFormat) {
        this.retrieveDescriptionFormat = retrieveDescriptionFormat;
    }

    public String getSearchIdFieldName() {
        return this.searchIdFieldName;
    }
}

