/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.StringUtils;

public class AbstractGeneratorOptions
implements Options {
    private Map<String, String> pluralFor = new HashMap<String, String>();

    public void override(AbstractGeneratorOptions overrideOptions) {
        if (overrideOptions.pluralFor != null) {
            this.pluralFor.putAll(overrideOptions.pluralFor);
        }
    }

    @JsonIgnore
    public final String getPluralFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.pluralFor.getOrDefault(name, StringUtils.toPlural(name));
    }

    @JsonIgnore
    public final String getPluralFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getPluralFor(type.getName());
    }

    @JsonIgnore
    public AbstractGeneratorOptions setPluralFor(String name, String pluralisedName) {
        this.pluralFor.put(name, pluralisedName);
        return this;
    }

    private void setPluralFor(Map<String, String> pluralFor) {
        this.pluralFor = pluralFor;
    }
}

