/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.validiation.Validation;

public abstract class AbstractGeneratorSubOptions
implements Options {
    private Boolean generate;
    private String descriptionFormat;
    private Map<String, Boolean> generateFor = new HashMap<String, Boolean>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.generate, "'generate' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.generateFor, "'generateFor' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.descriptionFormat, "'descriptionFormat' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(AbstractGeneratorSubOptions overrideOptions) {
        if (overrideOptions.generate != null) {
            this.setGenerate(overrideOptions.generate);
        }
        if (overrideOptions.descriptionFormat != null) {
            this.setDescriptionFormat(overrideOptions.descriptionFormat);
        }
        this.generateFor.putAll(overrideOptions.generateFor);
    }

    @JsonIgnore
    public final boolean isGenerating() {
        return this.generate != null && this.generate != false || this.generateFor.values().stream().anyMatch(value -> value);
    }

    @JsonIgnore
    public final boolean isGeneratingFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.generateFor.getOrDefault(name, this.generate);
    }

    @JsonIgnore
    public final boolean isGeneratingFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isGeneratingFor(type.getName());
    }

    @JsonIgnore
    public AbstractGeneratorSubOptions setGenerateFor(String name, boolean generate) {
        this.generateFor.put(name, generate);
        return this;
    }

    @JsonIgnore
    public AbstractGeneratorSubOptions setGenerateFor(BrAPIType type, boolean generate) {
        return this.setGenerateFor(type.getName(), generate);
    }

    @JsonIgnore
    public final String getDescriptionFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.descriptionFormat, name);
    }

    @JsonIgnore
    public final String getDescriptionFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getDescriptionFor(type.getName());
    }

    private Boolean getGenerate() {
        return this.generate;
    }

    private String getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public void setGenerate(Boolean generate) {
        this.generate = generate;
    }

    public void setDescriptionFormat(String descriptionFormat) {
        this.descriptionFormat = descriptionFormat;
    }

    protected AbstractGeneratorSubOptions() {
    }

    protected AbstractGeneratorSubOptions(Boolean generate, String descriptionFormat, Map<String, Boolean> generateFor) {
        this.generate = generate;
        this.descriptionFormat = descriptionFormat;
        this.generateFor = generateFor;
    }

    private void setGenerateFor(Map<String, Boolean> generateFor) {
        this.generateFor = generateFor;
    }
}

