/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIRelationshipType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.LinkType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.options.PropertyOptions;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.BrAPITypeUtils;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class PropertiesOptions
implements Options {
    private PropertyOptions id;
    private PropertyOptions name;
    private PropertyOptions pui;
    private Map<String, Map<String, String>> linkTypeFor = new HashMap<String, Map<String, String>>();

    @Override
    public Validation validate() {
        return Validation.valid().merge(this.linkTypeFor.values().stream().flatMap(map -> map.values().stream()).map(LinkType::fromNameOrLabels).collect(Response.toList())).assertNotNull(this.id, "'id' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(PropertiesOptions overrideOptions) {
        if (overrideOptions.id != null) {
            this.id.override(overrideOptions.id);
        }
        if (overrideOptions.name != null) {
            this.name.override(overrideOptions.name);
        }
        if (overrideOptions.pui != null) {
            this.pui.override(overrideOptions.pui);
        }
        if (overrideOptions.linkTypeFor != null) {
            overrideOptions.linkTypeFor.forEach((key, value) -> {
                if (this.linkTypeFor.containsKey(key)) {
                    this.linkTypeFor.get(key).putAll((Map<String, String>)value);
                } else {
                    this.linkTypeFor.put((String)key, new HashMap(value));
                }
            });
        }
    }

    public List<BrAPIObjectProperty> getLinkPropertiesFor(BrAPIObjectType brAPIObjectType) {
        ArrayList<BrAPIObjectProperty> linkProperties = new ArrayList<BrAPIObjectProperty>();
        if (this.id.isLink()) {
            brAPIObjectType.getProperties().stream().filter(childProperty -> childProperty.getName().equals(this.id.getPropertyNameFor(brAPIObjectType))).findFirst().ifPresent(linkProperties::add);
        }
        if (this.name != null && this.name.isLink()) {
            brAPIObjectType.getProperties().stream().filter(childProperty -> childProperty.getName().equals(this.name.getPropertyNameFor(brAPIObjectType))).findFirst().ifPresent(linkProperties::add);
        }
        if (this.pui != null && this.pui.isLink()) {
            brAPIObjectType.getProperties().stream().filter(childProperty -> childProperty.getName().equals(this.pui.getPropertyNameFor(brAPIObjectType))).findFirst().ifPresent(linkProperties::add);
        }
        return linkProperties;
    }

    public String getIdPropertyNameFor(String type) {
        return this.id.getPropertyNameFor(type);
    }

    public String getIdPropertyNameFor(BrAPIType type) {
        return this.id.getPropertyNameFor(type);
    }

    public String getIdsPropertyNameFor(BrAPIObjectProperty property) {
        return String.format("%sDbIds", StringUtils.toSingular(property.getName()));
    }

    public Response<BrAPIObjectProperty> getIdPropertyFor(BrAPIType type) {
        if (type instanceof BrAPIObjectType) {
            BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
            String idPropertyName = this.getIdPropertyNameFor(type);
            return brAPIObjectType.getProperties().stream().filter(property -> property.getName().equals(idPropertyName)).findFirst().map(Response::success).orElseGet(() -> Response.fail(Response.ErrorType.VALIDATION, String.format("Type '%s' does not have a property '%s'", type.getName(), idPropertyName)));
        }
        return Response.fail(Response.ErrorType.VALIDATION, String.format("Type '%s' is not an object, is type '%s'", type.getName(), type.getClass().getSimpleName()));
    }

    public LinkType getLinkTypeFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        Map<String, String> map = this.linkTypeFor.get(type.getName());
        if (map != null) {
            return LinkType.findByNameOrLabel(map.get(property.getName())).orElseGet(() -> this.getDefaultLinkTypeFor(type, property));
        }
        return this.getDefaultLinkTypeFor(type, property);
    }

    private LinkType getDefaultLinkTypeFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        BrAPIRelationshipType relationshipType = property.getRelationshipType() != null ? property.getRelationshipType() : BrAPIRelationshipType.ONE_TO_ONE;
        return switch (relationshipType) {
            default -> throw new MatchException(null, null);
            case BrAPIRelationshipType.ONE_TO_ONE -> {
                if (BrAPITypeUtils.isPrimaryModel(type)) {
                    yield LinkType.ID;
                }
                yield LinkType.EMBEDDED;
            }
            case BrAPIRelationshipType.MANY_TO_ONE -> LinkType.ID;
            case BrAPIRelationshipType.ONE_TO_MANY -> LinkType.ID;
            case BrAPIRelationshipType.MANY_TO_MANY -> LinkType.ID;
        };
    }

    public PropertyOptions getId() {
        return this.id;
    }

    public PropertyOptions getName() {
        return this.name;
    }

    public PropertyOptions getPui() {
        return this.pui;
    }

    private void setId(PropertyOptions id) {
        this.id = id;
    }

    private void setName(PropertyOptions name) {
        this.name = name;
    }

    private void setPui(PropertyOptions pui) {
        this.pui = pui;
    }

    private PropertiesOptions() {
    }

    private PropertiesOptions(PropertyOptions id, PropertyOptions name, PropertyOptions pui, Map<String, Map<String, String>> linkTypeFor) {
        this.id = id;
        this.name = name;
        this.pui = pui;
        this.linkTypeFor = linkTypeFor;
    }

    private Map<String, Map<String, String>> getLinkTypeFor() {
        return this.linkTypeFor;
    }

    private void setLinkTypeFor(Map<String, Map<String, String>> linkTypeFor) {
        this.linkTypeFor = linkTypeFor;
    }
}

