/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.utils;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIType;

public class BrAPIClassCacheUtil {
    private Predicate<BrAPIClass> cachePredicate;

    public Map<String, BrAPIClass> createMap(List<BrAPIClass> brAPIClasses) {
        return (BrAPIClassCacheUtil)this.new Cache(brAPIClasses).brAPIClassMap;
    }

    public BrAPIClassCacheUtil(Predicate<BrAPIClass> cachePredicate) {
        this.cachePredicate = cachePredicate;
    }

    private class Cache {
        private final Map<String, BrAPIClass> brAPIClassMap = new TreeMap<String, BrAPIClass>();

        public Cache(List<BrAPIClass> brAPIClasses) {
            for (BrAPIClass brAPIClass : brAPIClasses) {
                this.cacheClass(brAPIClass);
            }
        }

        private void cacheClass(BrAPIType brAPIType) {
            BrAPIClass brAPIClass;
            if (brAPIType instanceof BrAPIClass && BrAPIClassCacheUtil.this.cachePredicate.test(brAPIClass = (BrAPIClass)brAPIType) && !this.brAPIClassMap.containsKey(brAPIClass.getName())) {
                if (brAPIClass instanceof BrAPIObjectType) {
                    BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                    this.brAPIClassMap.put(brAPIClass.getName(), brAPIObjectType);
                    brAPIObjectType.getProperties().forEach(property -> this.cacheClass(property.getType()));
                } else if (brAPIType instanceof BrAPIOneOfType) {
                    BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIType;
                    this.brAPIClassMap.put(brAPIClass.getName(), brAPIOneOfType);
                    brAPIOneOfType.getPossibleTypes().forEach(this::cacheClass);
                } else if (brAPIClass instanceof BrAPIEnumType) {
                    BrAPIEnumType brAPIEnumType = (BrAPIEnumType)brAPIClass;
                    this.brAPIClassMap.put(brAPIClass.getName(), brAPIEnumType);
                }
            } else if (brAPIType instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)brAPIType;
                this.cacheClass(brAPIArrayType.getItems());
            }
        }
    }
}

