/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.SpecVersion;

public class OpenAPIUtils {
    public static String prettyPrint(OpenAPI openAPI) throws JsonProcessingException {
        return OpenAPIUtils.prettyPrint(openAPI, 4);
    }

    public static String prettyPrint(OpenAPI openAPI, int indent) throws JsonProcessingException {
        ObjectMapper mapper = switch (openAPI.getSpecVersion()) {
            default -> throw new MatchException(null, null);
            case SpecVersion.V30 -> Json.mapper();
            case SpecVersion.V31 -> Json31.mapper();
        };
        DefaultIndenter indenter = new DefaultIndenter(" ".repeat(indent), DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        return mapper.writer((PrettyPrinter)printer).writeValueAsString((Object)openAPI);
    }
}

