/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dflib.DataFrame;
import org.dflib.excel.Excel;
import org.dflib.excel.ExcelSaver;

public class TabularReportWriter {
    private final ExcelSaver saver = Excel.saver().autoSizeColumns();
    private boolean autoFilterColumns = false;
    private boolean freezePane = false;

    private TabularReportWriter() {
    }

    public static TabularReportWriter writer() {
        return new TabularReportWriter();
    }

    public TabularReportWriter autoSizeColumns() {
        this.saver.autoSizeColumns();
        return this;
    }

    public TabularReportWriter autoFilterColumns() {
        this.autoFilterColumns = true;
        return this;
    }

    public TabularReportWriter freezePane() {
        this.freezePane = true;
        return this;
    }

    public void writeToExcel(List<DataFrame> reports, Path path) throws IOException {
        this.saver.save(reports.stream().collect(Collectors.toMap(DataFrame::getName, UnaryOperator.identity())), path);
        this.updateHeaders(path);
    }

    public void writeToExcel(DataFrame report, Path path) throws IOException {
        this.saver.save(Collections.singletonMap(report.getName(), report), path);
        this.updateHeaders(path);
    }

    private void updateHeaders(Path path) throws IOException {
        if (this.needsUpdateAfterSave()) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
                StreamSupport.stream(workbook.spliterator(), false).forEach(this::addHeaders);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    workbook.write(outputStream);
                }
            }
        }
    }

    private void addHeaders(Sheet sheet) {
        if (this.autoFilterColumns) {
            sheet.setAutoFilter(new CellRangeAddress(0, 0, 0, 8));
        }
        if (this.freezePane) {
            sheet.createFreezePane(0, 1);
        }
    }

    private boolean needsUpdateAfterSave() {
        return this.autoFilterColumns || this.freezePane;
    }
}

