/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse.authorization;

import java.util.Base64;
import org.brapi.schematools.analyse.authorization.AuthorizationProvider;
import org.brapi.schematools.core.response.Response;

public final class BasicAuthorizationProvider
implements AuthorizationProvider {
    private final String username;
    private final String password;

    @Override
    public Response<String> getAuthorization() {
        if (this.username == null) {
            return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)"Username was not provided!");
        }
        if (this.password == null) {
            return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)"Password was not provided!");
        }
        String valueToEncode = this.username + ":" + this.password;
        return Response.success((Object)("Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes())));
    }

    BasicAuthorizationProvider(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static BasicAuthorizationProviderBuilder builder() {
        return new BasicAuthorizationProviderBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthorizationProvider)) {
            return false;
        }
        BasicAuthorizationProvider other = (BasicAuthorizationProvider)o;
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "BasicAuthorizationProvider(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public static class BasicAuthorizationProviderBuilder {
        private String username;
        private String password;

        BasicAuthorizationProviderBuilder() {
        }

        public BasicAuthorizationProviderBuilder username(String username) {
            this.username = username;
            return this;
        }

        public BasicAuthorizationProviderBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BasicAuthorizationProvider build() {
            return new BasicAuthorizationProvider(this.username, this.password);
        }

        public String toString() {
            return "BasicAuthorizationProvider.BasicAuthorizationProviderBuilder(username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

