/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brapi.schematools.analyse.Parameter;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.validiation.Validation;

public class APIRequestOptions
implements Options {
    private Boolean analyse;
    private Map<String, Boolean> analyseFor = new HashMap<String, Boolean>();
    private Map<String, List<Parameter>> requiredParametersFor = new HashMap<String, List<Parameter>>();
    private Map<String, List<String>> prerequisitesFor = new HashMap<String, List<String>>();

    public Validation validate() {
        return Validation.valid().assertNotNull((Object)this.analyse, "'analyse' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull(this.analyseFor, "'analyseFor' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull(this.requiredParametersFor, "'requiredParametersFor' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull(this.prerequisitesFor, "'prerequisitesFor' option on %s is null", new Object[]{this.getClass().getSimpleName()});
    }

    public void override(APIRequestOptions overrideOptions) {
        if (overrideOptions.analyse != null) {
            this.setAnalyse(overrideOptions.analyse);
        }
        if (overrideOptions.analyseFor != null) {
            this.analyseFor.putAll(overrideOptions.analyseFor);
        }
        if (overrideOptions.requiredParametersFor != null) {
            this.requiredParametersFor.putAll(overrideOptions.requiredParametersFor);
        }
        if (overrideOptions.prerequisitesFor != null) {
            this.prerequisitesFor.putAll(overrideOptions.prerequisitesFor);
        }
    }

    @JsonIgnore
    public Boolean isAnalysingEntity(String name) {
        return this.analyseFor.getOrDefault(name, this.analyse);
    }

    @JsonIgnore
    public APIRequestOptions setAnalysingEntityFor(String name, Boolean analyse) {
        this.analyseFor.put(name, analyse);
        return this;
    }

    @JsonIgnore
    public List<Parameter> getRequiredParametersFor(String name) {
        return this.requiredParametersFor.getOrDefault(name, new LinkedList());
    }

    @JsonIgnore
    public APIRequestOptions setRequiredParametersFor(String name, List<Parameter> requiredParameters) {
        this.requiredParametersFor.put(name, requiredParameters);
        return this;
    }

    @JsonIgnore
    public List<String> getPrerequisitesFor(String name) {
        return this.prerequisitesFor.getOrDefault(name, new LinkedList());
    }

    @JsonIgnore
    public APIRequestOptions setPrerequisitesFor(String name, List<String> requiredParameters) {
        this.prerequisitesFor.put(name, requiredParameters);
        return this;
    }

    private Boolean getAnalyse() {
        return this.analyse;
    }

    public void setAnalyse(Boolean analyse) {
        this.analyse = analyse;
    }

    public void setAnalyseFor(Map<String, Boolean> analyseFor) {
        this.analyseFor = analyseFor;
    }

    public void setRequiredParametersFor(Map<String, List<Parameter>> requiredParametersFor) {
        this.requiredParametersFor = requiredParametersFor;
    }

    public void setPrerequisitesFor(Map<String, List<String>> prerequisitesFor) {
        this.prerequisitesFor = prerequisitesFor;
    }

    private APIRequestOptions() {
    }

    private APIRequestOptions(Boolean analyse, Map<String, Boolean> analyseFor, Map<String, List<Parameter>> requiredParametersFor, Map<String, List<String>> prerequisitesFor) {
        this.analyse = analyse;
        this.analyseFor = analyseFor;
        this.requiredParametersFor = requiredParametersFor;
        this.prerequisitesFor = prerequisitesFor;
    }

    private Map<String, Boolean> getAnalyseFor() {
        return this.analyseFor;
    }

    private Map<String, List<Parameter>> getRequiredParametersFor() {
        return this.requiredParametersFor;
    }

    private Map<String, List<String>> getPrerequisitesFor() {
        return this.prerequisitesFor;
    }
}

