/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brapi.schematools.analyse.APIRequest;
import org.brapi.schematools.analyse.APIRequestOptions;
import org.brapi.schematools.analyse.AnalysisOptions;
import org.brapi.schematools.analyse.AnalysisReport;
import org.brapi.schematools.analyse.Endpoint;
import org.brapi.schematools.analyse.Parameter;
import org.brapi.schematools.analyse.ParameterLink;
import org.brapi.schematools.analyse.PropertyLink;
import org.brapi.schematools.analyse.Variable;
import org.brapi.schematools.analyse.VariableValue;
import org.brapi.schematools.analyse.authorization.AuthorizationProvider;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrAPISpecificationAnalyserFactory {
    private static final Logger log = LoggerFactory.getLogger(BrAPISpecificationAnalyserFactory.class);
    private static final int SPECIAL_CASE_ENDPOINTS_INDEX = 0;
    private static final int LIST_ENTITY_INDEX = 10;
    private static final int GET_ENTITY_INDEX = 20;
    private static final int SEARCH_INDEX = 30;
    private static final int SEARCH_RESULTS_INDEX = 40;
    private static final int TABLE_INDEX = 50;
    private static final int CREATE_ENTITY_INDEX = 60;
    private static final int UPDATE_ENTITY_INDEX = 70;
    private static final int DELETE_ENTITY_INDEX = 80;
    private static final Pattern REF_PATTERN = Pattern.compile("#/components/schemas/(\\w+)");
    private final String baseURL;
    private final HttpClient client;
    private final AuthorizationProvider authorizationProvider;
    private final AnalysisOptions options;
    private final ObjectMapper objectMapper;
    private final String COMMON_CROP_NAMES = "commoncropnames";
    private final String COMMON_CROP_NAMES_ENDPOINT = "/commoncropnames";
    private final List<String> SPECIAL_CASE_ENDPOINTS = List.of("/commoncropnames");

    public BrAPISpecificationAnalyserFactory(String baseURL, HttpClient client, AuthorizationProvider authorizationProvider) {
        this(baseURL, client, authorizationProvider, AnalysisOptions.load());
    }

    public BrAPISpecificationAnalyserFactory(String baseURL, HttpClient client, AuthorizationProvider authorizationProvider, AnalysisOptions options) {
        this.baseURL = baseURL;
        this.client = client;
        this.authorizationProvider = authorizationProvider;
        this.options = options;
        this.objectMapper = new ObjectMapper();
    }

    public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyse(String specification, Path schema) {
        Analyser analyser = new Analyser(specification, schema);
        return analyser.getErrors().merge(this.options.validate().asResponse()).map(() -> (org.brapi.schematools.core.response.Response)Stream.of(analyser.analyseSpecial(), analyser.analyseAll()).collect(org.brapi.schematools.core.response.Response.mergeLists()));
    }

    public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyse(String specification, List<String> entityNames) {
        Analyser analyser = new Analyser(specification, null);
        return analyser.getErrors().merge(this.options.validate().asResponse()).map(() -> (org.brapi.schematools.core.response.Response)Stream.of(analyser.analyseSpecial(), analyser.analyseEntities(entityNames)).collect(org.brapi.schematools.core.response.Response.mergeLists()));
    }

    public org.brapi.schematools.core.response.Response<Validation> validate(String specification) {
        Analyser analyser = new Analyser(specification, null);
        return analyser.getErrors().merge(this.options.validate().asResponse());
    }

    public Analyser analyser(String specification) {
        return new Analyser(specification, null);
    }

    public class Analyser {
        private final OpenAPI openAPI;
        private final OpenApiInteractionValidator validator;
        private final Map<String, APIRequest> requests = new HashMap<String, APIRequest>();
        private final Set<APIRequest> specialRequests = new TreeSet<APIRequest>(Comparator.comparingInt(APIRequest::getIndex));
        private final Map<String, List<APIRequest>> requestsByEntity;
        private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
        private final List<Endpoint> unmatchedEndpoints = new ArrayList<Endpoint>();
        private final List<Endpoint> skippedEndpoints = new ArrayList<Endpoint>();
        private final List<Endpoint> deprecatedEndpoints = new ArrayList<Endpoint>();
        private final Map<String, VariableValue> variableValues = new HashMap<String, VariableValue>();
        private static final Pattern ENTITY_PATH_PATTERN = Pattern.compile("/(\\w+)/?(\\w+)?/\\{(\\w+)}");
        private static final Pattern ENTITIES_PATH_PATTERN = Pattern.compile("/(\\w+)/?(\\w+)?/?(\\w+)?");
        private static final Pattern SEARCH_PATH_PATTERN = Pattern.compile("/search/(\\w+)(/attributes|/attributevalues)?");
        private static final Pattern SEARCH_RESULTS_PATH_PATTERN = Pattern.compile("/search/(\\w+)(/attributes|/attributevalues)?/\\{(\\w+)}");
        private static final Pattern TABLE_PATH_PATTERN = Pattern.compile("(?:/search)?/(\\w+)/table");
        private static final Pattern ENTITY_SUB_PATH_PATTERN = Pattern.compile("/(\\w+)/?(\\w+)?/\\{(\\w+)}/(\\w+)");
        private final List<PathMatcher> PATH_PATTERN_MATCHERS = Arrays.asList(new PathMatcher(TABLE_PATH_PATTERN, this::cacheTablePath), new PathMatcher(SEARCH_PATH_PATTERN, this::cacheSearchPath), new PathMatcher(SEARCH_RESULTS_PATH_PATTERN, this::cacheSearchResultPath), new PathMatcher(ENTITIES_PATH_PATTERN, this::cacheEntitiesPath), new PathMatcher(ENTITY_PATH_PATTERN, this::cacheEntityPath), new PathMatcher(ENTITY_SUB_PATH_PATTERN, this::cacheSubPath));
        private final Pattern PARAMETER_PATTERN = Pattern.compile("\\{(\\w+)\\}");
        private final org.brapi.schematools.core.response.Response<List<APIRequest>> errors;
        private static final List<String> PRIMITIVES = Arrays.asList("string", "boolean");

        private Analyser(String specification, Path schemaPath) {
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setResolve(true);
            SwaggerParseResult result = new OpenAPIParser().readContents(specification, null, parseOptions);
            this.validator = OpenApiInteractionValidator.createForInlineApiSpecification((String)specification).build();
            this.openAPI = result.getOpenAPI();
            this.errors = ((org.brapi.schematools.core.response.Response)this.openAPI.getPaths().entrySet().stream().map(this::cacheRequest).collect(org.brapi.schematools.core.response.Response.toList())).onFailDoWithResponse(org.brapi.schematools.core.response.Response::getAllErrors);
            this.requestsByEntity = new TreeMap<String, List<APIRequest>>(this.requests.values().stream().collect(Collectors.groupingBy(APIRequest::getEntityName)));
        }

        public List<String> getEntityNames() {
            return new ArrayList<String>(this.requestsByEntity.keySet());
        }

        public List<Endpoint> getEndpoints() {
            return this.endpoints;
        }

        public List<Endpoint> getUnmatchedEndpoints() {
            return this.unmatchedEndpoints;
        }

        public List<Endpoint> getSkippedEndpoints() {
            return this.skippedEndpoints;
        }

        public List<Endpoint> getDeprecatedEndpoints() {
            return this.deprecatedEndpoints;
        }

        public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyseAll() {
            if (this.errors.hasErrors()) {
                return this.errors.merge(org.brapi.schematools.core.response.Response.empty());
            }
            return (org.brapi.schematools.core.response.Response)this.requestsByEntity.entrySet().stream().map(this::executeAPIRequests).collect(org.brapi.schematools.core.response.Response.mergeLists());
        }

        public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyseEntities(List<String> entityNames) {
            if (this.errors.hasErrors()) {
                return this.errors.merge(org.brapi.schematools.core.response.Response.empty());
            }
            return (org.brapi.schematools.core.response.Response)this.requestsByEntity.entrySet().stream().filter(entry -> entityNames.contains(entry.getKey())).map(this::executeAPIRequests).collect(org.brapi.schematools.core.response.Response.mergeLists());
        }

        public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyseEntity(String entityName) {
            if (this.errors.hasErrors()) {
                return this.errors.merge(org.brapi.schematools.core.response.Response.empty());
            }
            return (org.brapi.schematools.core.response.Response)this.requestsByEntity.entrySet().stream().filter(entry -> entityName.equals(entry.getKey())).map(this::executeAPIRequests).collect(org.brapi.schematools.core.response.Response.mergeLists());
        }

        public org.brapi.schematools.core.response.Response<List<AnalysisReport>> analyseSpecial() {
            if (this.errors.hasErrors()) {
                return this.errors.merge(org.brapi.schematools.core.response.Response.empty());
            }
            return (org.brapi.schematools.core.response.Response)this.specialRequests.stream().map(this::executeAPIRequest).collect(org.brapi.schematools.core.response.Response.toList());
        }

        public org.brapi.schematools.core.response.Response<Analyser> validate() {
            if (this.errors.hasErrors()) {
                return this.errors.merge(org.brapi.schematools.core.response.Response.empty());
            }
            return org.brapi.schematools.core.response.Response.success((Object)this);
        }

        public org.brapi.schematools.core.response.Response<List<APIRequest>> getErrors() {
            return this.errors;
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheRequest(Map.Entry<String, PathItem> pathItemEntry) {
            String endpoint = pathItemEntry.getKey();
            PathItem pathItem = pathItemEntry.getValue();
            if (pathItem.getGet() != null && BrAPISpecificationAnalyserFactory.this.SPECIAL_CASE_ENDPOINTS.contains(endpoint)) {
                if ("/commoncropnames".equals(endpoint)) {
                    return this.getAPIRequestBuilder("Get /commoncropnames", 0, "commoncropnames", pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getGetEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build()).cacheVariable(Variable.builder().variableName("commonCropName").parameterName("commonCropName").jsonPath("$.result.data[0]").build()).cacheVariable(Variable.builder().variableName("commonCropNames").parameterName("commonCropNames").jsonPath("$.result.data[0]").convertToList(true).build())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this.specialRequests::add);
                }
                return org.brapi.schematools.core.response.Response.success(null);
            }
            return this.PATH_PATTERN_MATCHERS.stream().map(pathMatcher -> pathMatcher.match(endpoint)).filter(PathMatcher::matches).findFirst().map(pathMatcher -> pathMatcher.createRequest(pathItem)).orElse(null);
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheEntityPath(PathItem pathItem, Matcher matcher) {
            String entityIdPropertyName;
            String entityName;
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                entityName = this.findEntityName(pathItem.getGet(), matcher.group(1), matcher.group(2));
                entityIdPropertyName = this.getIdPropertyNameFor(entityName);
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingGetForEntity(entityName) && this.isAnalysingOperation(pathItem.getGet())) {
                    return this.getAPIRequestBuilder("Get Entity", 20, entityName, pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getGetEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build())).mapResultToResponse(builder -> this.enrichWithParameter((APIRequest.APIRequestBuilder)builder, entityIdPropertyName, entityIdPropertyName + "1", pathItem.getGet().getParameters())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.GET, pathItem.getGet(), endpoint, "Get Entity");
            }
            if (pathItem.getPost() != null) {
                this.unmatchedEndpoint(Request.Method.POST, endpoint, "Entity");
            }
            if (pathItem.getPut() != null) {
                entityName = this.findEntityName(pathItem.getPut(), matcher.group(1), matcher.group(2));
                entityIdPropertyName = BrAPISpecificationAnalyserFactory.this.options.getProperties().getIdPropertyNameFor(entityName);
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingUpdateForEntity(entityName) && this.isAnalysingOperation(pathItem.getPut())) {
                    return this.getAPIRequestBuilder("Update Entity", 70, entityName, pathItem.getPut(), BrAPISpecificationAnalyserFactory.this.options.getUpdateEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.put((String)endpoint).build())).mapResultToResponse(builder -> this.enrichWithParameter((APIRequest.APIRequestBuilder)builder, entityIdPropertyName, entityIdPropertyName + "1", pathItem.getGet().getParameters())).mapResult(builder -> this.buildUpdateEntityBody((APIRequest.APIRequestBuilder)builder, pathItem.getPut().getRequestBody(), BrAPISpecificationAnalyserFactory.this.options.getUpdateEntity())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.PUT, pathItem.getPut(), endpoint, "Update Entity");
            }
            if (pathItem.getDelete() != null) {
                entityName = this.findEntityName(pathItem.getDelete(), matcher.group(1), matcher.group(2));
                entityIdPropertyName = BrAPISpecificationAnalyserFactory.this.options.getProperties().getIdPropertyNameFor(entityName);
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingDeleteForEntity(entityName) && this.isAnalysingOperation(pathItem.getDelete())) {
                    return this.getAPIRequestBuilder("Delete Entity", 80, entityName, pathItem.getDelete(), BrAPISpecificationAnalyserFactory.this.options.getDeleteEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.delete((String)endpoint).build())).mapResultToResponse(builder -> this.enrichWithParameter((APIRequest.APIRequestBuilder)builder, entityIdPropertyName, entityIdPropertyName + "1", pathItem.getGet().getParameters())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.DELETE, pathItem.getDelete(), endpoint, "Delete Entity");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheEntitiesPath(PathItem pathItem, Matcher matcher) {
            String entityName;
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                entityName = this.findEntityName(pathItem.getGet(), matcher.group(1), matcher.group(2), matcher.group(3));
                String entityIdPropertyName = this.getIdPropertyNameFor(entityName);
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingListForEntity(entityName) && this.isAnalysingOperation(pathItem.getGet())) {
                    return this.getAPIRequestBuilder("List Entities", 10, entityName, pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getListEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build())).onSuccessDoWithResultOnCondition(entityIdPropertyName != null, builder -> builder.cacheVariable(Variable.builder().variableName(entityIdPropertyName + "1").parameterName(entityIdPropertyName).jsonPath("$.result.data[0]." + entityIdPropertyName).build()).cacheVariable(Variable.builder().variableName(entityIdPropertyName + "s1").parameterName(entityIdPropertyName + "s").jsonPath("$.result.data[0:10]." + entityIdPropertyName).build())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.GET, pathItem.getGet(), endpoint, "List Entities");
            }
            if (pathItem.getPost() != null) {
                entityName = this.findEntityName(pathItem.getPost(), matcher.group(1), matcher.group(2), matcher.group(3));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingCreateForEntity(entityName) && this.isAnalysingOperation(pathItem.getPost())) {
                    return this.getAPIRequestBuilder("Create Entities", 60, entityName, pathItem.getPost(), BrAPISpecificationAnalyserFactory.this.options.getCreateEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.post((String)endpoint).build()).cacheVariable(Variable.builder().variableName("new" + entityName).jsonPath("$.result.data[0]").build())).mapResult(builder -> this.buildCreateEntitiesBody((APIRequest.APIRequestBuilder)builder, pathItem.getPost().getRequestBody(), BrAPISpecificationAnalyserFactory.this.options.getCreateEntity())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.POST, pathItem.getPost(), endpoint, "Create Entities");
            }
            if (pathItem.getPut() != null) {
                entityName = this.findEntityName(pathItem.getPut(), matcher.group(1), matcher.group(2), matcher.group(3));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingUpdateForEntity(entityName) && this.isAnalysingOperation(pathItem.getPut())) {
                    return this.getAPIRequestBuilder("Update Entities", 70, entityName, pathItem.getPut(), BrAPISpecificationAnalyserFactory.this.options.getUpdateEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.put((String)endpoint).build()).cacheVariable(Variable.builder().variableName("new" + entityName).jsonPath("$.result.data[0]").build())).mapResult(builder -> this.buildUpdateEntitiesBody((APIRequest.APIRequestBuilder)builder, pathItem.getPut().getRequestBody(), BrAPISpecificationAnalyserFactory.this.options.getUpdateEntity())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.PUT, pathItem.getPut(), endpoint, "Update Entities");
            }
            if (pathItem.getDelete() != null) {
                this.unmatchedEndpoint(Request.Method.DELETE, endpoint, "Entities");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheSearchPath(PathItem pathItem, Matcher matcher) {
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                this.unmatchedEndpoint(Request.Method.GET, endpoint, "Search Entities");
            }
            if (pathItem.getPost() != null) {
                String entityName = this.findEntityName(pathItem.getPost(), matcher.group(1), matcher.group(2));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingSearchForEntity(entityName) && this.isAnalysingOperation(pathItem.getPost())) {
                    return this.getAPIRequestBuilder("Search Entities", 30, entityName, pathItem.getPost(), BrAPISpecificationAnalyserFactory.this.options.getSearch()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.post((String)endpoint).build())).mapResult(builder -> this.buildSearchBody((APIRequest.APIRequestBuilder)builder, entityName, pathItem.getPost().getRequestBody(), BrAPISpecificationAnalyserFactory.this.options.getSearch())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.POST, pathItem.getPost(), endpoint, "Search Entities");
            }
            if (pathItem.getPut() != null) {
                this.unmatchedEndpoint(Request.Method.PUT, endpoint, "Search Entities");
            }
            if (pathItem.getDelete() != null) {
                this.unmatchedEndpoint(Request.Method.DELETE, endpoint, "Search Entities");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheSearchResultPath(PathItem pathItem, Matcher matcher) {
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                String entityName = this.findEntityName(pathItem.getPost(), matcher.group(1), matcher.group(2));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingSearchResultForEntity(entityName) && this.isAnalysingOperation(pathItem.getGet())) {
                    return this.getAPIRequestBuilder("Search Results", 40, entityName, pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getSearchResult()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build())).mapResultToResponse(builder -> this.enrichWithParameter((APIRequest.APIRequestBuilder)builder, "searchResultsDbId", entityName + "searchResultsDbId1", pathItem.getGet().getParameters())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.GET, pathItem.getGet(), endpoint, "Search Results");
            }
            if (pathItem.getPost() != null) {
                this.unmatchedEndpoint(Request.Method.POST, endpoint, "Search Results");
            }
            if (pathItem.getPut() != null) {
                this.unmatchedEndpoint(Request.Method.PUT, endpoint, "Search Results");
            }
            if (pathItem.getDelete() != null) {
                this.unmatchedEndpoint(Request.Method.DELETE, endpoint, "Search Results");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheTablePath(PathItem pathItem, Matcher matcher) {
            String entityName;
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                entityName = this.findEntityName(pathItem.getPost(), matcher.group(1));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingTableForEntity(entityName) && this.isAnalysingOperation(pathItem.getGet())) {
                    return this.getAPIRequestBuilder("Get Table", 50, entityName, pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getTable()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.GET, pathItem.getPost(), endpoint, "Get Table");
            }
            if (pathItem.getPost() != null) {
                entityName = this.findEntityName(pathItem.getPost(), matcher.group(1));
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingTableForEntity(entityName) && this.isAnalysingOperation(pathItem.getPost())) {
                    return this.getAPIRequestBuilder("Search Table", 50, entityName, pathItem.getPost(), BrAPISpecificationAnalyserFactory.this.options.getTable()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.post((String)endpoint).build())).mapResult(builder -> this.buildTableBody((APIRequest.APIRequestBuilder)builder, entityName, pathItem.getPost().getRequestBody(), BrAPISpecificationAnalyserFactory.this.options.getTable())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.POST, pathItem.getPost(), endpoint, "Search Table");
            }
            if (pathItem.getPut() != null) {
                this.unmatchedEndpoint(Request.Method.PUT, endpoint, "Table");
            }
            if (pathItem.getDelete() != null) {
                this.unmatchedEndpoint(Request.Method.DELETE, endpoint, "Table");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private org.brapi.schematools.core.response.Response<APIRequest> cacheSubPath(PathItem pathItem, Matcher matcher) {
            String endpoint = matcher.group();
            if (pathItem.getGet() != null) {
                String entityName = this.findEntityName(pathItem.getGet(), matcher.group(1), matcher.group(2), matcher.group(3));
                String entityIdPropertyName = matcher.group(3);
                if (BrAPISpecificationAnalyserFactory.this.options.isAnalysingListForEntity(entityName) && this.isAnalysingOperation(pathItem.getGet())) {
                    return this.getAPIRequestBuilder("List Sub Entities", 10, entityName, pathItem.getGet(), BrAPISpecificationAnalyserFactory.this.options.getListEntity()).onSuccessDoWithResult(builder -> builder.validatorRequest((Request)SimpleRequest.Builder.get((String)endpoint).build()).prerequisite("/" + matcher.group(1))).mapResultToResponse(builder -> this.enrichWithParameter((APIRequest.APIRequestBuilder)builder, entityIdPropertyName, entityIdPropertyName + "1", pathItem.getGet().getParameters())).mapResult(APIRequest.APIRequestBuilder::build).onSuccessDoWithResult(this::addRequest);
                }
                this.skippedEndpoint(entityName, Request.Method.GET, pathItem.getGet(), endpoint, "List Sub Entities");
            }
            if (pathItem.getPost() != null) {
                this.unmatchedEndpoint(Request.Method.POST, endpoint, "Sub Entities");
            }
            if (pathItem.getPut() != null) {
                this.unmatchedEndpoint(Request.Method.PUT, endpoint, "Sub Entities");
            }
            if (pathItem.getDelete() != null) {
                this.unmatchedEndpoint(Request.Method.DELETE, endpoint, "Sub Entities");
            }
            return org.brapi.schematools.core.response.Response.empty();
        }

        private boolean isAnalysingOperation(Operation operation) {
            if (this.isDeprecated(operation)) {
                return BrAPISpecificationAnalyserFactory.this.options.isAnalysingDepreciated();
            }
            return true;
        }

        private boolean isDeprecated(Operation operation) {
            return operation.getDeprecated() != null && operation.getDeprecated() != false;
        }

        private org.brapi.schematools.core.response.Response<APIRequest.APIRequestBuilder> enrichWithParameter(APIRequest.APIRequestBuilder builder, String parameterName, String variableName, List<io.swagger.v3.oas.models.parameters.Parameter> parameters) {
            if (parameterName != null) {
                return this.findParameterLinkAsResponse(parameterName, variableName, null, parameters).onSuccessDoWithResult(builder::pathParameter).map(() -> org.brapi.schematools.core.response.Response.success((Object)builder));
            }
            return org.brapi.schematools.core.response.Response.success((Object)builder);
        }

        private String getIdPropertyNameFor(String entityName) {
            if (entityName == null || PRIMITIVES.contains(entityName.toLowerCase())) {
                return null;
            }
            return BrAPISpecificationAnalyserFactory.this.options.getProperties().getIdPropertyNameFor(entityName);
        }

        private void addRequest(APIRequest request) {
            this.requests.put(request.getValidatorRequest().getPath(), request);
            this.endpoints.add(Endpoint.builder().entityName(request.getEntityName()).path(request.getValidatorRequest().getPath()).method(request.getValidatorRequest().getMethod()).category(request.getName()).build());
        }

        private void unmatchedEndpoint(Request.Method method, String path, String category) {
            this.unmatchedEndpoints.add(Endpoint.builder().entityName("Unmatched").path(path).method(method).category(category).build());
            log.warn(String.format("Unmatched endpoint %s '%s'", method, path));
        }

        private void skippedEndpoint(String entityName, Request.Method method, Operation operation, String path, String category) {
            if (this.isDeprecated(operation)) {
                this.deprecatedEndpoint(entityName, method, path, category);
            } else {
                this.skippedEndpoint(entityName, method, path, category);
            }
        }

        private void skippedEndpoint(String entityName, Request.Method method, String path, String category) {
            this.skippedEndpoints.add(Endpoint.builder().entityName(entityName).path(path).method(method).category(category).build());
            log.debug(String.format("Skipped endpoint %s '%s'", method, path));
        }

        private void deprecatedEndpoint(String entityName, Request.Method method, String path, String category) {
            this.deprecatedEndpoints.add(Endpoint.builder().entityName(entityName).path(path).method(method).category(category).build());
            log.debug(String.format("Skipped deprecated endpoint %s '%s'", method, path));
        }

        private String findEntityName(Operation operation, String ... pathElements) {
            MediaType content;
            ApiResponse response;
            if (operation != null && operation.getResponses() != null && (response = (ApiResponse)operation.getResponses().get((Object)"200")) != null && response.getContent() != null && (content = (MediaType)response.getContent().get((Object)"application/json")) != null && content.getSchema() != null) {
                Schema schema = content.getSchema();
                if (schema.get$ref() != null) {
                    schema = (Schema)this.findSchemaFromRef(schema.get$ref()).orElseResult(null);
                }
                if (schema != null && schema.getTitle() != null) {
                    String entityName;
                    String string = entityName = schema.getTitle() != null ? schema.getTitle() : schema.getName();
                    if (entityName.startsWith("200")) {
                        return Stream.of(pathElements).filter(Objects::nonNull).map(pathElement -> StringUtils.capitalise((String)StringUtils.toSingular((String)pathElement))).collect(Collectors.joining());
                    }
                    if (entityName.endsWith("ListResponse")) {
                        return (String)this.findChildSchema(schema, "result").mapResultToResponse(s -> this.findChildSchema((Schema)s, "data")).mapResultToResponse(this::findEntityName).getResultIfPresentOrElseResult((Object)entityName.substring(0, entityName.length() - 12));
                    }
                    if (entityName.endsWith("SingleResponse")) {
                        return (String)this.findChildSchema(schema, "result").mapResultToResponse(this::findEntityName).getResultIfPresentOrElseResult((Object)entityName.substring(0, entityName.length() - 14));
                    }
                    if (entityName.endsWith("Response")) {
                        return (String)this.findChildSchema(schema, "result").mapResultToResponse(this::findEntityName).getResultIfPresentOrElseResult((Object)entityName.substring(0, entityName.length() - 8));
                    }
                    return StringUtils.capitalise((String)StringUtils.toSingular((String)entityName));
                }
            }
            return Stream.of(pathElements).filter(Objects::nonNull).map(pathElement -> StringUtils.capitalise((String)StringUtils.toSingular((String)pathElement))).collect(Collectors.joining());
        }

        private org.brapi.schematools.core.response.Response<String> findEntityName(Schema schema) {
            if (schema.getType() != null && PRIMITIVES.contains(schema.getType().toLowerCase())) {
                return org.brapi.schematools.core.response.Response.empty();
            }
            if (schema instanceof ObjectSchema) {
                if (schema.getName() != null) {
                    return org.brapi.schematools.core.response.Response.success((Object)schema.getName());
                }
                if (schema.getTitle() != null) {
                    return org.brapi.schematools.core.response.Response.success((Object)schema.getTitle().replace(" ", ""));
                }
                if (schema.getExtensions() != null && schema.getExtensions().containsKey("x-brapi-metadata") && ((Map)schema.getExtensions().get("x-brapi-metadata")).containsKey("title")) {
                    return org.brapi.schematools.core.response.Response.success((Object)((String)((Map)schema.getExtensions().get("x-brapi-metadata")).get("title")).replace(" ", ""));
                }
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find name in '%s'", schema));
            }
            return org.brapi.schematools.core.response.Response.success((Object)schema.getType());
        }

        private org.brapi.schematools.core.response.Response<Schema> findChildSchema(Schema schema, String propertyName) {
            if (schema != null && schema.get$ref() != null) {
                schema = (Schema)this.findSchemaFromRef(schema.get$ref()).orElseResult(null);
            }
            if (schema != null) {
                if (schema.getProperties() != null) {
                    if ((schema = (Schema)schema.getProperties().get(propertyName)) == null) {
                        return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find child schema in property '%s'", propertyName));
                    }
                    return this.findChildSchema(schema);
                }
                return org.brapi.schematools.core.response.Response.success((Object)schema);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find child schema in property '%s'", propertyName));
        }

        private org.brapi.schematools.core.response.Response<Schema> findChildSchema(Schema schema) {
            if (schema != null && schema.get$ref() != null) {
                schema = (Schema)this.findSchemaFromRef(schema.get$ref()).orElseResult(null);
            }
            if (schema != null) {
                if (schema.getItems() != null) {
                    return this.findChildSchema(schema.getItems());
                }
                return org.brapi.schematools.core.response.Response.success((Object)schema);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)"Can not find child schema");
        }

        private org.brapi.schematools.core.response.Response<Schema> derefSchema(Schema schema) {
            if (schema.get$ref() != null) {
                return this.findSchemaFromRef(schema.get$ref());
            }
            return org.brapi.schematools.core.response.Response.success((Object)schema);
        }

        private org.brapi.schematools.core.response.Response<Schema> findSchemaFromRef(String ref) {
            Schema schema;
            Matcher matcher = REF_PATTERN.matcher(ref);
            if (matcher.matches() && (schema = (Schema)this.openAPI.getComponents().getSchemas().get(matcher.group(1))) != null) {
                if (schema.getName() == null) {
                    schema.setName(matcher.group(1));
                }
                return org.brapi.schematools.core.response.Response.success((Object)schema);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find schema '%s'", ref));
        }

        private APIRequest.APIRequestBuilder buildUpdateEntityBody(APIRequest.APIRequestBuilder builder, RequestBody requestBody, APIRequestOptions apiRequestOptions) {
            return builder;
        }

        private APIRequest.APIRequestBuilder buildCreateEntitiesBody(APIRequest.APIRequestBuilder builder, RequestBody requestBody, APIRequestOptions apiRequestOptions) {
            return builder;
        }

        private APIRequest.APIRequestBuilder buildUpdateEntitiesBody(APIRequest.APIRequestBuilder builder, RequestBody requestBody, APIRequestOptions apiRequestOptions) {
            return builder;
        }

        private APIRequest.APIRequestBuilder buildSearchBody(APIRequest.APIRequestBuilder builder, String entityName, RequestBody requestBody, APIRequestOptions apiRequestOptions) {
            this.getSchema(requestBody).onFailDoWithResponse(response -> log.warn(response.getMessagesCombined(", "))).mapResultToResponse(schema -> this.buildBody(entityName, (Schema)schema, apiRequestOptions)).onSuccessDoWithResult(builder::body);
            return builder;
        }

        private APIRequest.APIRequestBuilder buildTableBody(APIRequest.APIRequestBuilder builder, String entityName, RequestBody requestBody, APIRequestOptions apiRequestOptions) {
            this.getSchema(requestBody).onFailDoWithResponse(response -> log.warn(response.getMessagesCombined(", "))).mapResultToResponse(schema -> this.buildBody(entityName, (Schema)schema, apiRequestOptions)).onSuccessDoWithResult(builder::body);
            return builder;
        }

        private org.brapi.schematools.core.response.Response<Object> buildBody(String entityName, Schema schema, APIRequestOptions apiRequestOptions) {
            if (schema instanceof ObjectSchema) {
                ObjectSchema objectSchema = (ObjectSchema)schema;
                HashMap map = new HashMap();
                Map requiredParametersMap = apiRequestOptions.getRequiredParametersFor(entityName).stream().filter(parameter -> parameter.getIn().equals("body")).collect(Collectors.toMap(Parameter::getParameterName, UnaryOperator.identity()));
                List required = schema.getRequired() != null ? schema.getRequired() : new LinkedList();
                objectSchema.getProperties().entrySet().stream().filter(entry -> required.contains(entry.getKey())).forEach(entry -> {
                    if (!requiredParametersMap.containsKey(entry.getKey())) {
                        requiredParametersMap.put((String)entry.getKey(), this.createProperty((String)entry.getKey(), (Schema)entry.getValue()));
                    }
                });
                return ((org.brapi.schematools.core.response.Response)requiredParametersMap.values().stream().filter(parameter -> parameter.getIn().equals("body")).map(parameter -> this.findSchemaProperty(objectSchema, parameter.getParameterName()).onSuccessDoWithResult(propertySchema -> map.put(parameter.getParameterName(), PropertyLink.builder().propertyName(parameter.getParameterName()).schema((Schema)propertySchema).variableName(parameter.getVariableName()).build()))).collect(org.brapi.schematools.core.response.Response.toList())).mapOnCondition(BrAPISpecificationAnalyserFactory.this.options.isPartitionedByCrop(), () -> this.findSchemaProperty(objectSchema, "commonCropNames").onSuccessDoWithResult(propertySchema -> map.put("commonCropNames", PropertyLink.builder().propertyName("commonCropNames").schema((Schema)propertySchema).variableName("commonCropNames").build()))).map(() -> org.brapi.schematools.core.response.Response.success((Object)map));
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Schema must be object %s", schema));
        }

        private org.brapi.schematools.core.response.Response<Schema> findSchemaProperty(ObjectSchema objectSchema, String propertyName) {
            Schema schema = (Schema)objectSchema.getProperties().get(propertyName);
            if (schema != null) {
                return org.brapi.schematools.core.response.Response.success((Object)schema);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find schema for property %s", propertyName));
        }

        private org.brapi.schematools.core.response.Response<Schema> getSchema(RequestBody body) {
            if (body.get$ref() != null) {
                return this.findSchemaFromRef(body.get$ref());
            }
            if (body.getContent().containsKey((Object)"application/json")) {
                Schema schema = ((MediaType)body.getContent().get((Object)"application/json")).getSchema();
                if (schema != null && schema.get$ref() != null) {
                    return this.findSchemaFromRef(schema.get$ref());
                }
                return org.brapi.schematools.core.response.Response.success((Object)schema);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find schema for %s", body));
        }

        private org.brapi.schematools.core.response.Response<APIRequest.APIRequestBuilder> getAPIRequestBuilder(String name, int index, String entityName, Operation operation, APIRequestOptions apiRequestOptions) {
            APIRequest.APIRequestBuilder builder = APIRequest.builder().name(name).index(index).entityName(entityName);
            if (BrAPISpecificationAnalyserFactory.this.options.isPartitionedByCrop()) {
                this.findParameter("commonCropName", operation.getParameters()).ifPresent(parameter -> this.addParameterLink(builder, ParameterLink.builder().parameter((io.swagger.v3.oas.models.parameters.Parameter)parameter).variableName("commonCropName").build()));
            }
            apiRequestOptions.getPrerequisitesFor(entityName).forEach(builder::prerequisite);
            return this.findRequiredQueryParametersFor(operation.getParameters(), apiRequestOptions, entityName).onSuccessDoWithResult(p -> this.addParameterLinks(builder, (List<ParameterLink>)p)).map(() -> org.brapi.schematools.core.response.Response.success((Object)builder));
        }

        private org.brapi.schematools.core.response.Response<List<ParameterLink>> findRequiredQueryParametersFor(List<io.swagger.v3.oas.models.parameters.Parameter> parameters, APIRequestOptions apiRequestOptions, String entityName) {
            Map requiredParametersMap = apiRequestOptions.getRequiredParametersFor(entityName).stream().filter(parameter -> parameter.getIn().equals("query")).collect(Collectors.toMap(Parameter::getParameterName, UnaryOperator.identity()));
            parameters.stream().filter(parameter -> this.isTrue(parameter.getRequired())).filter(parameter -> parameter.getIn().equals("query")).forEach(parameter -> {
                if (!requiredParametersMap.containsKey(parameter.getName())) {
                    requiredParametersMap.put(parameter.getName(), this.createParameter((io.swagger.v3.oas.models.parameters.Parameter)parameter));
                }
            });
            return (org.brapi.schematools.core.response.Response)requiredParametersMap.values().stream().map(parameter -> this.findParameterLinkAsResponse((Parameter)parameter, parameters)).collect(org.brapi.schematools.core.response.Response.toList());
        }

        private Parameter createParameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
            Parameter newParameter = new Parameter();
            newParameter.setParameterName(parameter.getName());
            newParameter.setVariableName(parameter.getName());
            newParameter.setIn(parameter.getIn());
            newParameter.setExampleValue(parameter.getExample());
            Object example = null;
            if (parameter.getExample() != null) {
                example = parameter.getExample();
            } else if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
                example = parameter.getExamples().get(0);
            }
            if (example != null) {
                this.variableValues.put(parameter.getName(), this.createVariableValue(parameter.getName(), parameter.getName(), example));
            }
            return newParameter;
        }

        private Parameter createProperty(String name, Schema schema) {
            Parameter newParameter = new Parameter();
            newParameter.setParameterName(name);
            newParameter.setIn("body");
            newParameter.setExampleValue(schema.getExample());
            Object example = null;
            if (schema.getExample() != null) {
                example = schema.getExample();
            } else if (schema.getExamples() != null && !schema.getExamples().isEmpty()) {
                example = schema.getExamples().get(0);
            }
            if (example != null) {
                this.variableValues.put(name, this.createVariableValue(name, name, example));
            }
            return newParameter;
        }

        private boolean isTrue(Boolean required) {
            return required != null && required != false;
        }

        private org.brapi.schematools.core.response.Response<ParameterLink> findParameterLinkAsResponse(Parameter parameter, List<io.swagger.v3.oas.models.parameters.Parameter> parameters) {
            return this.findParameterLinkAsResponse(parameter.getParameterName(), parameter.getVariableName(), parameter.getExampleValue(), parameters);
        }

        private org.brapi.schematools.core.response.Response<ParameterLink> findParameterLinkAsResponse(String parameterName, String variableName, Object exampleValue, List<io.swagger.v3.oas.models.parameters.Parameter> parameters) {
            return this.findParameter(parameterName, parameters).map(p -> ParameterLink.builder().parameter((io.swagger.v3.oas.models.parameters.Parameter)p).variableName(variableName).build()).map(org.brapi.schematools.core.response.Response::success).orElseGet(() -> org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find parameter '%s' for variable '%s' in '%s'", parameterName, variableName, parameters))).onSuccessDoWithResultOnCondition(exampleValue != null, parameterLink -> this.variableValues.put(variableName, this.createVariableValue(parameterName, variableName, exampleValue)));
        }

        private Optional<io.swagger.v3.oas.models.parameters.Parameter> findParameter(String name, List<io.swagger.v3.oas.models.parameters.Parameter> parameters) {
            return parameters.stream().filter(parameter -> parameter.getName().equals(name)).findFirst();
        }

        private void addParameterLink(APIRequest.APIRequestBuilder builder, ParameterLink parameterLink) {
            if (parameterLink.getParameter().getIn().equals("path")) {
                builder.pathParameter(parameterLink);
            } else if (parameterLink.getParameter().getIn().equals("query")) {
                builder.queryParameter(parameterLink);
            }
        }

        private void addParameterLinks(APIRequest.APIRequestBuilder builder, List<ParameterLink> parameterLinks) {
            parameterLinks.forEach(parameterLink -> this.addParameterLink(builder, (ParameterLink)parameterLink));
        }

        private org.brapi.schematools.core.response.Response<List<AnalysisReport>> executeAPIRequests(Map.Entry<String, List<APIRequest>> entry) {
            log.debug("Executing requests for {}", (Object)entry.getKey());
            return (org.brapi.schematools.core.response.Response)entry.getValue().stream().sorted(Comparator.comparing(APIRequest::getIndex)).map(this::executeAPIRequest).collect(org.brapi.schematools.core.response.Response.toList());
        }

        private org.brapi.schematools.core.response.Response<AnalysisReport> executeAPIRequest(APIRequest request) {
            log.debug("Executing request {} for {}", (Object)request.getName(), (Object)request.getEntityName());
            log.debug("Full request {}", (Object)request);
            try {
                HttpRequest.Builder builder = HttpRequest.newBuilder();
                LocalDateTime startTime = LocalDateTime.now();
                return ((org.brapi.schematools.core.response.Response)request.getPrerequisites().stream().map(this::executePrerequisite).collect(org.brapi.schematools.core.response.Response.toList())).map(() -> this.createBody(request).mapResult(bodyPublisher -> builder.method(request.getValidatorRequest().getMethod().name(), (HttpRequest.BodyPublisher)bodyPublisher)).map(BrAPISpecificationAnalyserFactory.this.authorizationProvider::getAuthorization).mapResult(authorization -> builder.header("Authorization", (String)authorization)).merge(() -> this.createURI(builder, request)).mapResult(HttpRequest.Builder::build).mapResultToResponse(this::send).mapResultToResponse(httpResponse -> this.analyse(request, startTime, (HttpResponse<String>)httpResponse)).or(response -> org.brapi.schematools.core.response.Response.success((Object)AnalysisReport.builder().request(request).startTime(startTime).endTime(LocalDateTime.now()).errorKey("Pre-Execution").errorLevel(ValidationReport.Level.WARN).errorMessage(response.getMessagesCombined(", ")).build())));
            }
            catch (Exception e) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)e.getMessage());
            }
        }

        private org.brapi.schematools.core.response.Response<AnalysisReport> executePrerequisite(String prerequisite) {
            APIRequest request = this.requests.get(prerequisite);
            if (request != null) {
                return this.executeAPIRequest(request);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find prerequisite '%s'", prerequisite));
        }

        private org.brapi.schematools.core.response.Response<HttpRequest.Builder> createURI(HttpRequest.Builder builder, APIRequest request) {
            return this.createPath(request).mapResult(path -> builder.uri(URI.create(path)));
        }

        private org.brapi.schematools.core.response.Response<String> createPath(APIRequest request) {
            String path = String.format("%s%s", BrAPISpecificationAnalyserFactory.this.baseURL, request.getValidatorRequest().getPath());
            if (request.getPathParameters().isEmpty()) {
                Matcher matcher = this.PARAMETER_PATTERN.matcher(path);
                if (matcher.find()) {
                    org.brapi.schematools.core.response.Response response = org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Did not replace parameter '%s' in URI '%s'", matcher.group(1), path));
                    while (matcher.find()) {
                        response.addError(Response.ErrorType.VALIDATION, "", String.format("Did not replace parameter '%s' in URI '%s'", matcher.group(1), path));
                    }
                    return response;
                }
                return this.appendQuery(path, request);
            }
            return ((org.brapi.schematools.core.response.Response)request.getPathParameters().stream().map(this::getVariableValue).collect(org.brapi.schematools.core.response.Response.toList())).mapResultToResponse(variableValues -> this.replaceParametersWithVariableValues(path, (List<VariableValue>)variableValues)).mapResultToResponse(p -> this.appendQuery((String)p, request));
        }

        private org.brapi.schematools.core.response.Response<String> appendQuery(String path, APIRequest request) {
            if (request.getQueryParameters().isEmpty()) {
                return org.brapi.schematools.core.response.Response.success((Object)path);
            }
            return ((org.brapi.schematools.core.response.Response)request.getQueryParameters().stream().map(this::createQueryParam).collect(org.brapi.schematools.core.response.Response.toList())).mapResult(params -> String.join((CharSequence)"&", params)).mapResult(p -> String.format("%s?%s", path, p));
        }

        private org.brapi.schematools.core.response.Response<String> createQueryParam(ParameterLink parameterLink) {
            return this.getVariableValue(parameterLink).mapResultToResponse(variableValue -> this.writeValueAsStringAsResource(variableValue.getValue())).mapResult(value -> parameterLink.getParameterName() + "=" + value);
        }

        private org.brapi.schematools.core.response.Response<VariableValue> getVariableValue(ParameterLink parameter) {
            VariableValue value = this.variableValues.get(parameter.getVariableName());
            if (value != null) {
                return org.brapi.schematools.core.response.Response.success((Object)value);
            }
            return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not find variable '%s' for '%s'", parameter.getVariableName(), parameter.getParameter().getName()));
        }

        private org.brapi.schematools.core.response.Response<String> replaceParametersWithVariableValues(String path, List<VariableValue> variableValues) {
            try {
                for (VariableValue variableValue : variableValues) {
                    path = path.replace(String.format("{%s}", variableValue.getParameterName() != null ? variableValue.getParameterName() : variableValue.getVariableName()), this.writeValueAsString(variableValue.getValue()));
                }
                return org.brapi.schematools.core.response.Response.success((Object)path);
            }
            catch (JsonProcessingException e) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)e.getMessage());
            }
        }

        private String writeValueAsString(Object value) throws JsonProcessingException {
            if (value instanceof String) {
                String stringValue = (String)value;
                return stringValue;
            }
            return BrAPISpecificationAnalyserFactory.this.objectMapper.writeValueAsString(value);
        }

        private org.brapi.schematools.core.response.Response<String> writeValueAsStringAsResource(Object value) {
            try {
                return org.brapi.schematools.core.response.Response.success((Object)this.writeValueAsString(value));
            }
            catch (JsonProcessingException e) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)e.getMessage());
            }
        }

        private org.brapi.schematools.core.response.Response<HttpRequest.BodyPublisher> createBody(APIRequest request) {
            if (request.getBody() != null) {
                return this.replaceBodyWithVariableValues(request.getBody()).mapResultToResponse(this::writeBody);
            }
            return org.brapi.schematools.core.response.Response.success((Object)HttpRequest.BodyPublishers.noBody());
        }

        private org.brapi.schematools.core.response.Response<Object> replaceBodyWithVariableValues(Object body) {
            try {
                return org.brapi.schematools.core.response.Response.success((Object)this.replaceWithVariableValues(body));
            }
            catch (RuntimeException runtimeException) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)runtimeException.getMessage());
            }
        }

        private Object replaceWithVariableValues(Object body) throws RuntimeException {
            if (body instanceof List) {
                List list = (List)body;
                return list.stream().map(this::replaceBodyWithVariableValues).toList();
            }
            if (body instanceof Map) {
                Map map = (Map)body;
                HashMap newMap = new HashMap();
                map.forEach((key, value) -> newMap.put(key, this.replaceWithVariableValues(value)));
                return newMap;
            }
            if (body instanceof PropertyLink) {
                PropertyLink propertyLink = (PropertyLink)body;
                VariableValue value2 = this.variableValues.get(propertyLink.getVariableName());
                if (value2 != null) {
                    return value2.getValue();
                }
                throw new RuntimeException(String.format("Can not find value for variable '%s in property '%s;", propertyLink.getVariableName(), propertyLink.getPropertyName()));
            }
            return body;
        }

        private org.brapi.schematools.core.response.Response<HttpRequest.BodyPublisher> writeBody(Object body) {
            try {
                return org.brapi.schematools.core.response.Response.success((Object)HttpRequest.BodyPublishers.ofString(BrAPISpecificationAnalyserFactory.this.objectMapper.writeValueAsString(body)));
            }
            catch (JsonProcessingException e) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)e.getMessage());
            }
        }

        private org.brapi.schematools.core.response.Response<AnalysisReport> analyse(APIRequest request, LocalDateTime startTime, HttpResponse<String> httpResponse) {
            AnalysisReport.AnalysisReportBuilder builder = AnalysisReport.builder().request(request).uri(httpResponse.request().uri().toString()).startTime(startTime).statusCode(httpResponse.statusCode()).endTime(LocalDateTime.now());
            if (!request.getCacheVariables().isEmpty()) {
                if (httpResponse.statusCode() >= 200 && httpResponse.statusCode() < 300) {
                    try {
                        DocumentContext documentContext = JsonPath.parse((String)httpResponse.body());
                        request.getCacheVariables().forEach(variable -> this.cacheVariableValue(documentContext, (Variable)variable));
                    }
                    catch (Exception e) {
                        builder.errorKey(e.getClass().getSimpleName());
                        builder.errorLevel(ValidationReport.Level.WARN);
                        builder.errorMessage(e.getMessage());
                    }
                } else {
                    return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not cache value for variables '%s', return code was '%s'", request.getCacheVariables().stream().map(Variable::getVariableName).collect(Collectors.joining(", ")), httpResponse.statusCode()));
                }
            }
            return org.brapi.schematools.core.response.Response.success((Object)builder.request(request).validationReport(this.validator.validate(request.getValidatorRequest(), this.createResponse(httpResponse))).endTime(LocalDateTime.now()).build());
        }

        private void cacheVariableValue(DocumentContext documentContext, Variable variable) {
            if (variable.getJsonPath() != null) {
                this.variableValues.put(variable.getVariableName(), this.createVariableValue(variable, documentContext.read(variable.getJsonPath(), new Predicate[0])));
            }
        }

        private VariableValue createVariableValue(Variable variable, Object value) {
            if (variable.isConvertToList()) {
                return VariableValue.builder().variableName(variable.getVariableName()).parameterName(variable.getParameterName()).value(Collections.singletonList(value)).build();
            }
            return VariableValue.builder().variableName(variable.getVariableName()).parameterName(variable.getParameterName()).value(value).build();
        }

        private VariableValue createVariableValue(String variableName, String parameterName, Object value) {
            return VariableValue.builder().variableName(variableName).parameterName(parameterName).value(value).build();
        }

        private org.brapi.schematools.core.response.Response<HttpResponse<String>> send(HttpRequest request) {
            log.debug(String.format("Sending %s %s", request.method(), request.uri()));
            log.debug(String.format("Request body publisher %s", request.bodyPublisher().orElse(null)));
            try {
                return org.brapi.schematools.core.response.Response.success(BrAPISpecificationAnalyserFactory.this.client.send(request, HttpResponse.BodyHandlers.ofString()));
            }
            catch (IOException | InterruptedException e) {
                return org.brapi.schematools.core.response.Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)e.getMessage());
            }
        }

        private Response createResponse(HttpResponse<String> response) {
            log.debug(String.format("Response was %s for %s", response.statusCode(), response.uri()));
            log.debug(String.format("Response body %s", response.body()));
            return SimpleResponse.Builder.status((int)response.statusCode()).withContentType((String)response.headers().firstValue("Content-Type").orElse(null)).withBody(response.body()).build();
        }
    }

    private static class PathMatcher {
        private final Pattern pattern;
        private final BiFunction<PathItem, Matcher, org.brapi.schematools.core.response.Response<APIRequest>> function;
        private Matcher matcher;

        private PathMatcher(Pattern pattern, BiFunction<PathItem, Matcher, org.brapi.schematools.core.response.Response<APIRequest>> function) {
            this.pattern = pattern;
            this.function = function;
        }

        public PathMatcher match(String input) {
            this.matcher = this.pattern.matcher(input);
            return this;
        }

        public boolean matches() {
            return this.matcher.matches();
        }

        public org.brapi.schematools.core.response.Response<APIRequest> createRequest(PathItem pathItem) {
            return this.function.apply(pathItem, this.matcher);
        }
    }
}

