/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.atlassian.oai.validator.model.Request;

public final class Endpoint {
    private final String path;
    private final Request.Method method;
    private final String entityName;
    private final String category;

    public String toString() {
        return String.format("%s %s %s : %s", this.entityName, this.category, this.method.name(), this.path);
    }

    Endpoint(String path, Request.Method method, String entityName, String category) {
        this.path = path;
        this.method = method;
        this.entityName = entityName;
        this.category = category;
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public Request.Method getMethod() {
        return this.method;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Request.Method this$method = this.getMethod();
        Request.Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Request.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    public static class EndpointBuilder {
        private String path;
        private Request.Method method;
        private String entityName;
        private String category;

        EndpointBuilder() {
        }

        public EndpointBuilder path(String path) {
            this.path = path;
            return this;
        }

        public EndpointBuilder method(Request.Method method) {
            this.method = method;
            return this;
        }

        public EndpointBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public EndpointBuilder category(String category) {
            this.category = category;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.path, this.method, this.entityName, this.category);
        }

        public String toString() {
            return "Endpoint.EndpointBuilder(path=" + this.path + ", method=" + String.valueOf(this.method) + ", entityName=" + this.entityName + ", category=" + this.category + ")";
        }
    }
}

