/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse.authorization.oauth;

import com.fasterxml.jackson.annotation.JsonProperty;

public final class TokenRequest {
    @JsonProperty(value="grant_type")
    private final String grantType;
    @JsonProperty(value="client_id")
    private final String clientId;
    @JsonProperty(value="client_secret")
    private final String clientSecret;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="refresh_token")
    private final String refreshToken;

    public String params() {
        String params = "grant_type=" + this.grantType;
        if (this.clientId != null) {
            params = params + "&client_id=" + this.clientId;
        }
        if (this.clientSecret != null) {
            params = params + "&client_secret=" + this.clientSecret;
        }
        if (this.refreshToken != null) {
            params = params + "&refresh_token=" + this.refreshToken;
        }
        if (this.username != null) {
            params = params + "&username=" + this.username;
        }
        if (this.password != null) {
            params = params + "&password=" + this.password;
        }
        return params;
    }

    TokenRequest(String grantType, String clientId, String clientSecret, String username, String password, String refreshToken) {
        this.grantType = grantType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
        this.refreshToken = refreshToken;
    }

    public static TokenRequestBuilder builder() {
        return new TokenRequestBuilder();
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenRequest)) {
            return false;
        }
        TokenRequest other = (TokenRequest)o;
        String this$grantType = this.getGrantType();
        String other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !this$grantType.equals(other$grantType)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        return result;
    }

    public String toString() {
        return "TokenRequest(grantType=" + this.getGrantType() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", refreshToken=" + this.getRefreshToken() + ")";
    }

    public static class TokenRequestBuilder {
        private String grantType;
        private String clientId;
        private String clientSecret;
        private String username;
        private String password;
        private String refreshToken;

        TokenRequestBuilder() {
        }

        @JsonProperty(value="grant_type")
        public TokenRequestBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @JsonProperty(value="client_id")
        public TokenRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="client_secret")
        public TokenRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @JsonProperty(value="username")
        public TokenRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty(value="password")
        public TokenRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        @JsonProperty(value="refresh_token")
        public TokenRequestBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenRequest build() {
            return new TokenRequest(this.grantType, this.clientId, this.clientSecret, this.username, this.password, this.refreshToken);
        }

        public String toString() {
            return "TokenRequest.TokenRequestBuilder(grantType=" + this.grantType + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", username=" + this.username + ", password=" + this.password + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

