/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.atlassian.oai.validator.model.Request;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.brapi.schematools.analyse.ParameterLink;
import org.brapi.schematools.analyse.Variable;

public final class APIRequest {
    private final String name;
    private final int index;
    private final String entityName;
    private final List<ParameterLink> pathParameters;
    private final List<ParameterLink> queryParameters;
    private final Request validatorRequest;
    private final List<Variable> cacheVariables;
    private final Object body;
    private final List<String> prerequisites;

    APIRequest(String name, int index, String entityName, List<ParameterLink> pathParameters, List<ParameterLink> queryParameters, Request validatorRequest, List<Variable> cacheVariables, Object body, List<String> prerequisites) {
        this.name = name;
        this.index = index;
        this.entityName = entityName;
        this.pathParameters = pathParameters;
        this.queryParameters = queryParameters;
        this.validatorRequest = validatorRequest;
        this.cacheVariables = cacheVariables;
        this.body = body;
        this.prerequisites = prerequisites;
    }

    public static APIRequestBuilder builder() {
        return new APIRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public List<ParameterLink> getPathParameters() {
        return this.pathParameters;
    }

    public List<ParameterLink> getQueryParameters() {
        return this.queryParameters;
    }

    public Request getValidatorRequest() {
        return this.validatorRequest;
    }

    public List<Variable> getCacheVariables() {
        return this.cacheVariables;
    }

    public Object getBody() {
        return this.body;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIRequest)) {
            return false;
        }
        APIRequest other = (APIRequest)o;
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        List<ParameterLink> this$pathParameters = this.getPathParameters();
        List<ParameterLink> other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters)) {
            return false;
        }
        List<ParameterLink> this$queryParameters = this.getQueryParameters();
        List<ParameterLink> other$queryParameters = other.getQueryParameters();
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Request this$validatorRequest = this.getValidatorRequest();
        Request other$validatorRequest = other.getValidatorRequest();
        if (this$validatorRequest == null ? other$validatorRequest != null : !this$validatorRequest.equals(other$validatorRequest)) {
            return false;
        }
        List<Variable> this$cacheVariables = this.getCacheVariables();
        List<Variable> other$cacheVariables = other.getCacheVariables();
        if (this$cacheVariables == null ? other$cacheVariables != null : !((Object)this$cacheVariables).equals(other$cacheVariables)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<String> this$prerequisites = this.getPrerequisites();
        List<String> other$prerequisites = other.getPrerequisites();
        return !(this$prerequisites == null ? other$prerequisites != null : !((Object)this$prerequisites).equals(other$prerequisites));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        List<ParameterLink> $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        List<ParameterLink> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Request $validatorRequest = this.getValidatorRequest();
        result = result * 59 + ($validatorRequest == null ? 43 : $validatorRequest.hashCode());
        List<Variable> $cacheVariables = this.getCacheVariables();
        result = result * 59 + ($cacheVariables == null ? 43 : ((Object)$cacheVariables).hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<String> $prerequisites = this.getPrerequisites();
        result = result * 59 + ($prerequisites == null ? 43 : ((Object)$prerequisites).hashCode());
        return result;
    }

    public String toString() {
        return "APIRequest(name=" + this.getName() + ", index=" + this.getIndex() + ", entityName=" + this.getEntityName() + ", pathParameters=" + String.valueOf(this.getPathParameters()) + ", queryParameters=" + String.valueOf(this.getQueryParameters()) + ", validatorRequest=" + String.valueOf(this.getValidatorRequest()) + ", cacheVariables=" + String.valueOf(this.getCacheVariables()) + ", body=" + String.valueOf(this.getBody()) + ", prerequisites=" + String.valueOf(this.getPrerequisites()) + ")";
    }

    public static class APIRequestBuilder {
        private String name;
        private int index;
        private String entityName;
        private ArrayList<ParameterLink> pathParameters;
        private ArrayList<ParameterLink> queryParameters;
        private Request validatorRequest;
        private ArrayList<Variable> cacheVariables;
        private Object body;
        private ArrayList<String> prerequisites;

        APIRequestBuilder() {
        }

        public APIRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public APIRequestBuilder index(int index) {
            this.index = index;
            return this;
        }

        public APIRequestBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public APIRequestBuilder pathParameter(ParameterLink pathParameter) {
            if (this.pathParameters == null) {
                this.pathParameters = new ArrayList();
            }
            this.pathParameters.add(pathParameter);
            return this;
        }

        public APIRequestBuilder pathParameters(Collection<? extends ParameterLink> pathParameters) {
            if (pathParameters == null) {
                throw new NullPointerException("pathParameters cannot be null");
            }
            if (this.pathParameters == null) {
                this.pathParameters = new ArrayList();
            }
            this.pathParameters.addAll(pathParameters);
            return this;
        }

        public APIRequestBuilder clearPathParameters() {
            if (this.pathParameters != null) {
                this.pathParameters.clear();
            }
            return this;
        }

        public APIRequestBuilder queryParameter(ParameterLink queryParameter) {
            if (this.queryParameters == null) {
                this.queryParameters = new ArrayList();
            }
            this.queryParameters.add(queryParameter);
            return this;
        }

        public APIRequestBuilder queryParameters(Collection<? extends ParameterLink> queryParameters) {
            if (queryParameters == null) {
                throw new NullPointerException("queryParameters cannot be null");
            }
            if (this.queryParameters == null) {
                this.queryParameters = new ArrayList();
            }
            this.queryParameters.addAll(queryParameters);
            return this;
        }

        public APIRequestBuilder clearQueryParameters() {
            if (this.queryParameters != null) {
                this.queryParameters.clear();
            }
            return this;
        }

        public APIRequestBuilder validatorRequest(Request validatorRequest) {
            this.validatorRequest = validatorRequest;
            return this;
        }

        public APIRequestBuilder cacheVariable(Variable cacheVariable) {
            if (this.cacheVariables == null) {
                this.cacheVariables = new ArrayList();
            }
            this.cacheVariables.add(cacheVariable);
            return this;
        }

        public APIRequestBuilder cacheVariables(Collection<? extends Variable> cacheVariables) {
            if (cacheVariables == null) {
                throw new NullPointerException("cacheVariables cannot be null");
            }
            if (this.cacheVariables == null) {
                this.cacheVariables = new ArrayList();
            }
            this.cacheVariables.addAll(cacheVariables);
            return this;
        }

        public APIRequestBuilder clearCacheVariables() {
            if (this.cacheVariables != null) {
                this.cacheVariables.clear();
            }
            return this;
        }

        public APIRequestBuilder body(Object body) {
            this.body = body;
            return this;
        }

        public APIRequestBuilder prerequisite(String prerequisite) {
            if (this.prerequisites == null) {
                this.prerequisites = new ArrayList();
            }
            this.prerequisites.add(prerequisite);
            return this;
        }

        public APIRequestBuilder prerequisites(Collection<? extends String> prerequisites) {
            if (prerequisites == null) {
                throw new NullPointerException("prerequisites cannot be null");
            }
            if (this.prerequisites == null) {
                this.prerequisites = new ArrayList();
            }
            this.prerequisites.addAll(prerequisites);
            return this;
        }

        public APIRequestBuilder clearPrerequisites() {
            if (this.prerequisites != null) {
                this.prerequisites.clear();
            }
            return this;
        }

        public APIRequest build() {
            return new APIRequest(this.name, this.index, this.entityName, switch (this.pathParameters == null ? 0 : this.pathParameters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pathParameters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ParameterLink>(this.pathParameters));
            }, switch (this.queryParameters == null ? 0 : this.queryParameters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.queryParameters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ParameterLink>(this.queryParameters));
            }, this.validatorRequest, switch (this.cacheVariables == null ? 0 : this.cacheVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.cacheVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable>(this.cacheVariables));
            }, this.body, switch (this.prerequisites == null ? 0 : this.prerequisites.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.prerequisites.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.prerequisites));
            });
        }

        public String toString() {
            return "APIRequest.APIRequestBuilder(name=" + this.name + ", index=" + this.index + ", entityName=" + this.entityName + ", pathParameters=" + String.valueOf(this.pathParameters) + ", queryParameters=" + String.valueOf(this.queryParameters) + ", validatorRequest=" + String.valueOf(this.validatorRequest) + ", cacheVariables=" + String.valueOf(this.cacheVariables) + ", body=" + String.valueOf(this.body) + ", prerequisites=" + String.valueOf(this.prerequisites) + ")";
        }
    }
}

