/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.brapi.schematools.analyse.APIRequestOptions;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.options.PropertiesOptions;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.validiation.Validatable;
import org.brapi.schematools.core.validiation.Validation;

public class AnalysisOptions
implements Options {
    private Boolean analyseDepreciated;
    private APIRequestOptions getEntity;
    private APIRequestOptions listEntity;
    private APIRequestOptions createEntity;
    private APIRequestOptions updateEntity;
    private APIRequestOptions deleteEntity;
    private APIRequestOptions search;
    private APIRequestOptions searchResult;
    private APIRequestOptions table;
    private Boolean partitionedByCrop;
    private PropertiesOptions properties;

    public static AnalysisOptions load() {
        try {
            return (AnalysisOptions)ConfigurationUtils.load((String)"analyse-options.yaml", AnalysisOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static AnalysisOptions load(Path optionsFile) throws IOException {
        return AnalysisOptions.load().override((AnalysisOptions)ConfigurationUtils.load((Path)optionsFile, AnalysisOptions.class));
    }

    public static AnalysisOptions load(InputStream inputStream) throws IOException {
        return AnalysisOptions.load().override((AnalysisOptions)ConfigurationUtils.load((InputStream)inputStream, AnalysisOptions.class));
    }

    public AnalysisOptions override(AnalysisOptions overrideOptions) {
        if (overrideOptions.analyseDepreciated != null) {
            this.analyseDepreciated = overrideOptions.analyseDepreciated;
        }
        if (overrideOptions.getEntity != null) {
            this.getEntity.override(overrideOptions.getEntity);
        }
        if (overrideOptions.listEntity != null) {
            this.listEntity.override(overrideOptions.listEntity);
        }
        if (overrideOptions.createEntity != null) {
            this.createEntity.override(overrideOptions.createEntity);
        }
        if (overrideOptions.updateEntity != null) {
            this.updateEntity.override(overrideOptions.updateEntity);
        }
        if (overrideOptions.deleteEntity != null) {
            this.deleteEntity.override(overrideOptions.deleteEntity);
        }
        if (overrideOptions.search != null) {
            this.search.override(overrideOptions.search);
        }
        if (overrideOptions.searchResult != null) {
            this.searchResult.override(overrideOptions.searchResult);
        }
        if (overrideOptions.partitionedByCrop != null) {
            this.partitionedByCrop = overrideOptions.partitionedByCrop;
        }
        if (overrideOptions.properties != null) {
            this.properties.override(overrideOptions.getProperties());
        }
        return this;
    }

    public Validation validate() {
        return Validation.valid().assertNotNull((Object)this.analyseDepreciated, "'analyseDepreciated' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.getEntity, "'getEntity' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.listEntity, "'listEntity' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.createEntity, "'createEntity' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.updateEntity, "'updateEntity' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.deleteEntity, "'deleteEntity' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.search, "'search' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.searchResult, "'searchResult' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.partitionedByCrop, "'partitionedByCrop' option on %s is null", new Object[]{this.getClass().getSimpleName()}).assertNotNull((Object)this.properties, "Properties Options are null", new Object[0]).merge((Validatable)this.properties);
    }

    @JsonIgnore
    public boolean isAnalysingDepreciated() {
        return this.analyseDepreciated != null && this.analyseDepreciated != false;
    }

    @JsonIgnore
    public boolean isAnalysingGetForEntity(String entityName) {
        return this.getEntity.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingListForEntity(String entityName) {
        return this.listEntity.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingCreateForEntity(String entityName) {
        return this.createEntity.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingUpdateForEntity(String entityName) {
        return this.updateEntity.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingDeleteForEntity(String entityName) {
        return this.deleteEntity.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingSearchForEntity(String entityName) {
        return this.search.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingSearchResultForEntity(String entityName) {
        return this.searchResult.isAnalysingEntity(entityName);
    }

    @JsonIgnore
    public boolean isAnalysingTableForEntity(String entityName) {
        return this.table.isAnalysingEntity(entityName);
    }

    public boolean isPartitionedByCrop() {
        return this.partitionedByCrop != null && this.partitionedByCrop != false;
    }

    public Boolean getAnalyseDepreciated() {
        return this.analyseDepreciated;
    }

    public APIRequestOptions getGetEntity() {
        return this.getEntity;
    }

    public APIRequestOptions getListEntity() {
        return this.listEntity;
    }

    public APIRequestOptions getCreateEntity() {
        return this.createEntity;
    }

    public APIRequestOptions getUpdateEntity() {
        return this.updateEntity;
    }

    public APIRequestOptions getDeleteEntity() {
        return this.deleteEntity;
    }

    public APIRequestOptions getSearch() {
        return this.search;
    }

    public APIRequestOptions getSearchResult() {
        return this.searchResult;
    }

    public APIRequestOptions getTable() {
        return this.table;
    }

    public Boolean getPartitionedByCrop() {
        return this.partitionedByCrop;
    }

    public PropertiesOptions getProperties() {
        return this.properties;
    }

    public AnalysisOptions setAnalyseDepreciated(Boolean analyseDepreciated) {
        this.analyseDepreciated = analyseDepreciated;
        return this;
    }

    public AnalysisOptions setGetEntity(APIRequestOptions getEntity) {
        this.getEntity = getEntity;
        return this;
    }

    public AnalysisOptions setListEntity(APIRequestOptions listEntity) {
        this.listEntity = listEntity;
        return this;
    }

    public AnalysisOptions setCreateEntity(APIRequestOptions createEntity) {
        this.createEntity = createEntity;
        return this;
    }

    public AnalysisOptions setUpdateEntity(APIRequestOptions updateEntity) {
        this.updateEntity = updateEntity;
        return this;
    }

    public AnalysisOptions setDeleteEntity(APIRequestOptions deleteEntity) {
        this.deleteEntity = deleteEntity;
        return this;
    }

    public AnalysisOptions setSearch(APIRequestOptions search) {
        this.search = search;
        return this;
    }

    public AnalysisOptions setSearchResult(APIRequestOptions searchResult) {
        this.searchResult = searchResult;
        return this;
    }

    public AnalysisOptions setTable(APIRequestOptions table) {
        this.table = table;
        return this;
    }

    public AnalysisOptions setPartitionedByCrop(Boolean partitionedByCrop) {
        this.partitionedByCrop = partitionedByCrop;
        return this;
    }

    public AnalysisOptions setProperties(PropertiesOptions properties) {
        this.properties = properties;
        return this;
    }

    private AnalysisOptions() {
    }

    private AnalysisOptions(Boolean analyseDepreciated, APIRequestOptions getEntity, APIRequestOptions listEntity, APIRequestOptions createEntity, APIRequestOptions updateEntity, APIRequestOptions deleteEntity, APIRequestOptions search, APIRequestOptions searchResult, APIRequestOptions table, Boolean partitionedByCrop, PropertiesOptions properties) {
        this.analyseDepreciated = analyseDepreciated;
        this.getEntity = getEntity;
        this.listEntity = listEntity;
        this.createEntity = createEntity;
        this.updateEntity = updateEntity;
        this.deleteEntity = deleteEntity;
        this.search = search;
        this.searchResult = searchResult;
        this.table = table;
        this.partitionedByCrop = partitionedByCrop;
        this.properties = properties;
    }
}

