/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import com.atlassian.oai.validator.report.ValidationReport;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.brapi.schematools.analyse.APIRequest;

public final class AnalysisReport {
    private final APIRequest request;
    private final String uri;
    private final LocalDateTime startTime;
    private final LocalDateTime endTime;
    private final int statusCode;
    private final ValidationReport validationReport;
    private final String errorKey;
    private final ValidationReport.Level errorLevel;
    private final String errorMessage;

    public long getTimeElapsed() {
        return this.endTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - this.startTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public String getName() {
        return this.request.getName();
    }

    public String getEntityName() {
        return this.request.getEntityName();
    }

    AnalysisReport(APIRequest request, String uri, LocalDateTime startTime, LocalDateTime endTime, int statusCode, ValidationReport validationReport, String errorKey, ValidationReport.Level errorLevel, String errorMessage) {
        this.request = request;
        this.uri = uri;
        this.startTime = startTime;
        this.endTime = endTime;
        this.statusCode = statusCode;
        this.validationReport = validationReport;
        this.errorKey = errorKey;
        this.errorLevel = errorLevel;
        this.errorMessage = errorMessage;
    }

    public static AnalysisReportBuilder builder() {
        return new AnalysisReportBuilder();
    }

    public APIRequest getRequest() {
        return this.request;
    }

    public String getUri() {
        return this.uri;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public ValidationReport.Level getErrorLevel() {
        return this.errorLevel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisReport)) {
            return false;
        }
        AnalysisReport other = (AnalysisReport)o;
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        APIRequest this$request = this.getRequest();
        APIRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        ValidationReport this$validationReport = this.getValidationReport();
        ValidationReport other$validationReport = other.getValidationReport();
        if (this$validationReport == null ? other$validationReport != null : !this$validationReport.equals(other$validationReport)) {
            return false;
        }
        String this$errorKey = this.getErrorKey();
        String other$errorKey = other.getErrorKey();
        if (this$errorKey == null ? other$errorKey != null : !this$errorKey.equals(other$errorKey)) {
            return false;
        }
        ValidationReport.Level this$errorLevel = this.getErrorLevel();
        ValidationReport.Level other$errorLevel = other.getErrorLevel();
        if (this$errorLevel == null ? other$errorLevel != null : !this$errorLevel.equals(other$errorLevel)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        APIRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        ValidationReport $validationReport = this.getValidationReport();
        result = result * 59 + ($validationReport == null ? 43 : $validationReport.hashCode());
        String $errorKey = this.getErrorKey();
        result = result * 59 + ($errorKey == null ? 43 : $errorKey.hashCode());
        ValidationReport.Level $errorLevel = this.getErrorLevel();
        result = result * 59 + ($errorLevel == null ? 43 : $errorLevel.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisReport(request=" + String.valueOf(this.getRequest()) + ", uri=" + this.getUri() + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ", statusCode=" + this.getStatusCode() + ", validationReport=" + String.valueOf(this.getValidationReport()) + ", errorKey=" + this.getErrorKey() + ", errorLevel=" + String.valueOf(this.getErrorLevel()) + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public static class AnalysisReportBuilder {
        private APIRequest request;
        private String uri;
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private int statusCode;
        private ValidationReport validationReport;
        private String errorKey;
        private ValidationReport.Level errorLevel;
        private String errorMessage;

        AnalysisReportBuilder() {
        }

        public AnalysisReportBuilder request(APIRequest request) {
            this.request = request;
            return this;
        }

        public AnalysisReportBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public AnalysisReportBuilder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public AnalysisReportBuilder endTime(LocalDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public AnalysisReportBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public AnalysisReportBuilder validationReport(ValidationReport validationReport) {
            this.validationReport = validationReport;
            return this;
        }

        public AnalysisReportBuilder errorKey(String errorKey) {
            this.errorKey = errorKey;
            return this;
        }

        public AnalysisReportBuilder errorLevel(ValidationReport.Level errorLevel) {
            this.errorLevel = errorLevel;
            return this;
        }

        public AnalysisReportBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AnalysisReport build() {
            return new AnalysisReport(this.request, this.uri, this.startTime, this.endTime, this.statusCode, this.validationReport, this.errorKey, this.errorLevel, this.errorMessage);
        }

        public String toString() {
            return "AnalysisReport.AnalysisReportBuilder(request=" + String.valueOf(this.request) + ", uri=" + this.uri + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ", statusCode=" + this.statusCode + ", validationReport=" + String.valueOf(this.validationReport) + ", errorKey=" + this.errorKey + ", errorLevel=" + String.valueOf(this.errorLevel) + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

