/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.analyse;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.brapi.schematools.analyse.AnalysisReport;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Printers;
import org.dflib.builder.DataFrameArrayAppender;

public class TabularReportGenerator {
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Entity", "Path", "URI", "Status Code", "Duration", "Message Key", "Message Level", "Message"};
    private static final String[] SUMMARY_COLUMN_NAMES = new String[]{"Entity", "Path", "Status Code", "Message Key", "Message Level", "Count"};
    private boolean summariseAcrossReports = false;
    private DataFrame summary;

    private TabularReportGenerator() {
    }

    public static TabularReportGenerator generator() {
        return new TabularReportGenerator().clearSummary();
    }

    public TabularReportGenerator summariseAcrossReports() {
        this.summariseAcrossReports = true;
        return this;
    }

    public TabularReportGenerator clearSummary() {
        this.summary = DataFrame.empty((String[])SUMMARY_COLUMN_NAMES);
        return this;
    }

    public DataFrame getSummary() {
        return this.summary.as("Summary");
    }

    public List<String> getColumnNames() {
        return List.of(COLUMN_NAMES);
    }

    public List<String> getSummaryColumnNames() {
        return List.of(SUMMARY_COLUMN_NAMES);
    }

    public DataFrame generateReport(List<AnalysisReport> reports) {
        return this.generateReport("Report", reports);
    }

    public List<DataFrame> generateReportByEntity(List<AnalysisReport> reports) {
        return reports.stream().collect(Collectors.groupingBy(AnalysisReport::getEntityName)).entrySet().stream().map(this::generateReport).toList();
    }

    public String generateReportTable(List<AnalysisReport> reports) {
        DataFrame dataFrame = this.generateReport(reports);
        return Printers.tabular.toString(dataFrame);
    }

    private DataFrame generateReport(Map.Entry<String, List<AnalysisReport>> entry) {
        return this.generateReport(entry.getKey(), entry.getValue());
    }

    private DataFrame generateReport(String name, List<AnalysisReport> reports) {
        DataFrameArrayAppender appender = DataFrame.byArrayRow((String[])COLUMN_NAMES).appender();
        reports.forEach(analysisReport -> {
            if (analysisReport.getValidationReport() == null || analysisReport.getValidationReport().getMessages().isEmpty()) {
                appender.append(new Object[]{analysisReport.getName(), analysisReport.getEntityName(), analysisReport.getRequest().getValidatorRequest().getPath(), analysisReport.getUri(), analysisReport.getStatusCode(), DurationFormatUtils.formatDurationHMS((long)analysisReport.getTimeElapsed()), analysisReport.getErrorKey(), analysisReport.getErrorLevel(), analysisReport.getErrorMessage()});
            } else {
                analysisReport.getValidationReport().getMessages().forEach(message -> appender.append(new Object[]{analysisReport.getName(), analysisReport.getEntityName(), analysisReport.getRequest().getValidatorRequest().getPath(), analysisReport.getUri(), analysisReport.getStatusCode(), DurationFormatUtils.formatDurationHMS((long)analysisReport.getTimeElapsed()), message.getKey(), message.getLevel(), message.getMessage()}));
            }
        });
        return this.addToSummary(appender.toDataFrame().as(name));
    }

    private DataFrame addToSummary(DataFrame dataFrame) {
        if (this.summariseAcrossReports) {
            DataFrame agg = dataFrame.group(new String[]{"Path", "Status Code", "Message Key", "Message Level"}).cols(SUMMARY_COLUMN_NAMES).agg(new Exp[]{Exp.$col((String)"Entity").first(), Exp.$col((String)"Path").first(), Exp.$col((String)"Status Code").first(), Exp.$col((String)"Message Key").first(), Exp.$col((String)"Message Level").first(), Exp.count()});
            this.summary = this.summary.vConcat(new DataFrame[]{agg});
        }
        return dataFrame;
    }
}

