/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import java.nio.file.Path;
import java.util.List;
import org.brapi.schematools.cli.BrAPICommandException;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.response.Response;
import picocli.CommandLine;

@CommandLine.Command(name="validate", mixinStandardHelpOptions=true, description={"Validates the BrAPI JSON schema"})
public class ValidateSubCommand
implements Runnable {
    @CommandLine.Parameters(index="0", description={"The directory containing the BrAPI JSON schema"})
    private Path schemaDirectory;
    @CommandLine.Option(names={"-x", "--throwExceptionOnFail"}, description={"Throw an exception on failure. False by default, if set to True if an exception is thrown when validation or generation fails."})
    private boolean throwExceptionOnFail = false;

    @Override
    public void run() {
        BrAPISchemaReader schemaReader = new BrAPISchemaReader();
        schemaReader.readDirectories(this.schemaDirectory).onFailDoWithResponse(this::printErrors).onSuccessDo(() -> System.out.println("The BrAPI JSON schema is valid"));
    }

    private void printErrors(Response<List<BrAPIClass>> response) {
        String message;
        if (response.getAllErrors().size() == 1) {
            message = "There was 1 error validating the JSON Schema";
            System.err.println("There was 1 error validating the JSON Schema");
        } else {
            message = String.format("There were %d errors validating the JSON Schema", response.getAllErrors().size());
            System.err.println(message);
        }
        response.getAllErrors().forEach(this::printError);
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(message, response.getAllErrors());
        }
    }

    private void printError(Response.Error error) {
        switch (error.getType()) {
            case VALIDATION: {
                System.err.print("Validation Error :");
                break;
            }
            case PERMISSION: 
            case OTHER: {
                System.err.print("Error :");
            }
        }
        System.err.print('\t');
        System.err.println(error.getMessage());
    }
}

