/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.IOException;
import java.io.PrintStream;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brapi.schematools.analyse.AnalysisOptions;
import org.brapi.schematools.analyse.AnalysisReport;
import org.brapi.schematools.analyse.BrAPISpecificationAnalyserFactory;
import org.brapi.schematools.analyse.Endpoint;
import org.brapi.schematools.analyse.TabularReportGenerator;
import org.brapi.schematools.analyse.TabularReportWriter;
import org.brapi.schematools.analyse.authorization.AuthorizationProvider;
import org.brapi.schematools.analyse.authorization.BasicAuthorizationProvider;
import org.brapi.schematools.analyse.authorization.NoAuthorizationProvider;
import org.brapi.schematools.analyse.authorization.oauth.OpenIDToken;
import org.brapi.schematools.analyse.authorization.oauth.SingleSignOn;
import org.brapi.schematools.cli.BrAPICommandException;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.validiation.Validation;
import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="analyse", mixinStandardHelpOptions=true, description={"Executes a query pipeline or set of pipelines"})
public class AnalyseSubCommand
implements Runnable {
    private final PrintStream out = System.out;
    private final PrintStream err = System.err;
    @CommandLine.Parameters(index="0", description={"The path to the specification file."})
    private Path specificationPath;
    @CommandLine.Parameters(index="1", description={"The Base URL to be analysed."})
    private String baseURL;
    @CommandLine.Option(names={"-e", "--entities"}, description={"A list of entities or a file containing a list of entities on which to run the analysis"})
    private List<String> entityNames;
    @CommandLine.Option(names={"-a", "--oauth"}, description={"The URL of the OAuth access token if used"})
    private String oauthURL;
    @CommandLine.Option(names={"-o", "--options"}, description={"The path of the options file. If not provided the default options for the specified output format will be used."})
    private Path optionsPath;
    @CommandLine.Option(names={"-r", "--report"}, description={"The path to Excel workbook where the report is sent. If not provided, the standard out is used."})
    private Path reportPath;
    @CommandLine.Option(names={"-u", "--username"}, description={"The username for authentication if required. If not provided the current system username is used."})
    private String username = System.getProperty("user.name");
    @CommandLine.Option(names={"-p", "--password"}, interactive=true, arity="0..1", description={"The password for the supplied username. Will fail if not logged in and the password is not provided. Providing the option without a value make the application as for a value."})
    private String password;
    @CommandLine.Option(names={"-c", "--client"}, description={"The client id for authentication if required."})
    private String clientId;
    @CommandLine.Option(names={"-s", "--secret"}, description={"The client secret for authentication if required."})
    private String clientSecret;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Provide a verbose output to standard out describing the current step etc."})
    private boolean verbose;
    @CommandLine.Option(names={"-i", "--individualReportsByEntity"}, description={"Create an individual report for entity"})
    private boolean individualReportsByEntity;
    @CommandLine.Option(names={"-b", "--batchProcess"}, description={"Process the API requests in batches per entity. Use only with the -i option. WARNING the output file will be deleted prior to starting the batch process."})
    private boolean batchProcess;
    @CommandLine.Option(names={"-d", "--validate"}, description={"Does a dry run on the analyse, validating the options"})
    private boolean validate;
    @CommandLine.Option(names={"-ar", "--summariseAcrossReports"}, description={"Add a summary to any reporting"})
    private boolean summariseAcrossReports;
    @CommandLine.Option(names={"-x", "--throwExceptionOnFail"}, description={"Throw an exception on failure. False by default, if set to True if an exception is thrown when validation or generation fails."})
    private boolean throwExceptionOnFail = false;
    @CommandLine.Option(names={"-t", "--stackTrace"}, description={"If an error is recorded output the stack trace."})
    private boolean stackTrace = false;
    private TabularReportWriter writer = TabularReportWriter.writer().autoFilterColumns().autoSizeColumns().freezePane();

    @Override
    public void run() {
        LoggerContext loggerContext;
        Logger logger;
        if (this.verbose && (logger = (loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory()).exists("org.brapi.schematools.analyse")) != null) {
            logger.setLevel(Level.DEBUG);
        }
        try {
            AnalysisOptions options;
            AnalysisOptions analysisOptions = options = this.optionsPath != null ? AnalysisOptions.load((Path)this.optionsPath) : AnalysisOptions.load();
            if (this.validate) {
                this.validateOptions(options).onFailDoWithResponse(this::outputValidation).map(() -> this.createAnalyser(options)).mapResultToResponse(BrAPISpecificationAnalyserFactory.Analyser::validate).onSuccessDoWithResult(this::outputEndpointsToOut);
            } else if (this.batchProcess) {
                if (!this.individualReportsByEntity) {
                    this.err.println("Batch process can only be used in conjunction with 'individualReportsByEntity'");
                } else {
                    if (Files.exists(this.reportPath, new LinkOption[0])) {
                        this.out.printf("Deleting Report file '%s'!%n", this.reportPath.toFile().getAbsolutePath());
                        Files.delete(this.reportPath);
                    }
                    this.validateOptions(options).map(() -> this.createAnalyser(options)).mapResultToResponse(BrAPISpecificationAnalyserFactory.Analyser::validate).mapResultToResponse(this::batchAnalyse).onFailDoWithResponse(this::outputError);
                }
            } else {
                this.validateOptions(options).map(() -> this.createAnalyser(options)).mapResultToResponse(BrAPISpecificationAnalyserFactory.Analyser::validate).mapResultToResponse(this::analyse).onFailDoWithResponse(this::outputError);
            }
        }
        catch (Exception exception) {
            this.outputException(exception);
        }
    }

    private Response<Validation> validateOptions(AnalysisOptions options) {
        return options.validate().asResponse();
    }

    private Response<BrAPISpecificationAnalyserFactory.Analyser> createAnalyser(AnalysisOptions options) {
        if (Files.isRegularFile(this.specificationPath, new LinkOption[0])) {
            Stream<String> lines;
            try {
                lines = Files.lines(this.specificationPath);
            }
            catch (IOException e) {
                return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not read path '%s'", this.specificationPath.toFile()));
            }
            String specification = lines.collect(Collectors.joining("\n"));
            lines.close();
            return this.authorisation().mapResult(sso -> new BrAPISpecificationAnalyserFactory(this.baseURL, HttpClient.newBuilder().build(), sso, options)).mapResult(factory -> factory.analyser(specification));
        }
        return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Path '%s' is not regular file", this.specificationPath.toFile()));
    }

    private Response<List<AnalysisReport>> analyse(BrAPISpecificationAnalyserFactory.Analyser analyser) {
        List<String> entityNames = this.getEntityNames();
        if (entityNames.isEmpty()) {
            return ((Response)Stream.of(analyser.analyseSpecial(), analyser.analyseAll()).collect(Response.mergeLists())).onSuccessDoWithResult(this::outputReports).onSuccessDo(() -> this.outputEndpoints(analyser));
        }
        return ((Response)Stream.of(analyser.analyseSpecial(), analyser.analyseEntities(entityNames)).collect(Response.mergeLists())).onSuccessDoWithResult(this::outputReports).onSuccessDo(() -> this.outputEndpoints(analyser));
    }

    private Response<List<AnalysisReport>> batchAnalyse(BrAPISpecificationAnalyserFactory.Analyser analyser) {
        TabularReportGenerator tabularReportGenerator;
        LinkedList completedReports = new LinkedList();
        TabularReportGenerator tabularReportGenerator2 = tabularReportGenerator = this.summariseAcrossReports ? TabularReportGenerator.generator().summariseAcrossReports() : TabularReportGenerator.generator();
        if (this.reportPath != null) {
            if (Files.isDirectory(this.reportPath, new LinkOption[0])) {
                this.err.printf("Report file '%s' is directory!%n", this.reportPath.toFile().getAbsolutePath());
                return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Report file '%s' is directory", this.reportPath));
            }
            try {
                Files.createDirectories(this.reportPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Can not create report file directory '%s' ", this.reportPath.getParent()));
            }
            analyser.analyseSpecial().onFailDoWithResponse(this::outputError).onSuccessDoWithResult(reports -> this.writeReportsToFile(tabularReportGenerator, (List<AnalysisReport>)reports)).onSuccessDoWithResult(completedReports::addAll);
            List<String> entityNames = this.getEntityNames();
            if (entityNames.isEmpty()) {
                analyser.getEntityNames().forEach(entityName -> analyser.analyseEntity(entityName).onFailDoWithResponse(this::outputError).onSuccessDoWithResult(reports -> this.writeReportsToFile(tabularReportGenerator, (List<AnalysisReport>)reports)).onSuccessDoWithResult(completedReports::addAll));
            } else {
                entityNames.forEach(entityName -> analyser.analyseEntity(entityName).onFailDoWithResponse(this::outputError).onSuccessDoWithResult(reports -> this.writeReportsToFile(tabularReportGenerator, (List<AnalysisReport>)reports)).onSuccessDoWithResult(completedReports::addAll));
            }
            this.writeSummaryToFile(tabularReportGenerator);
            this.writeEndpointsToFile(analyser);
        } else {
            analyser.analyseSpecial().onFailDoWithResponse(this::outputError).onSuccessDoWithResult(reports -> this.outputReportsToOut(tabularReportGenerator, (List<AnalysisReport>)reports)).onSuccessDoWithResult(completedReports::addAll);
            analyser.getEntityNames().forEach(entityName -> analyser.analyseEntity(entityName).onFailDoWithResponse(this::outputError).onSuccessDoWithResult(reports -> this.outputReportsToOut(tabularReportGenerator, (List<AnalysisReport>)reports)).onSuccessDoWithResult(completedReports::addAll));
            this.outputSummaryToOut(tabularReportGenerator);
            this.outputEndpointsToOut(analyser);
        }
        return Response.success(completedReports);
    }

    private List<String> getEntityNames() {
        if (this.entityNames != null) {
            return this.entityNames;
        }
        return new LinkedList<String>();
    }

    private Response<AuthorizationProvider> authorisation() {
        if (this.oauthURL != null) {
            SingleSignOn sso = SingleSignOn.builder().url(this.oauthURL).clientId(this.clientId).username(this.username).build();
            return sso.getToken().or(() -> this.login(sso)).merge(() -> Response.success((Object)sso));
        }
        if (this.password != null) {
            return Response.success((Object)BasicAuthorizationProvider.builder().username(this.username).password(this.password).build());
        }
        return Response.success((Object)new NoAuthorizationProvider());
    }

    private Response<OpenIDToken> login(SingleSignOn sso) {
        if (this.password != null) {
            return sso.loginWithPassword(this.password);
        }
        if (this.clientSecret != null) {
            return sso.loginWithClientId(this.clientSecret);
        }
        return Response.fail((Response.ErrorType)Response.ErrorType.PERMISSION, (String)String.format("Not logged please provide password using option '-p' for user '%s' or client secret for client '%s'", this.username, this.clientId));
    }

    private void outputError(Response<List<AnalysisReport>> response) {
        this.err.println("Analysis failed due to: ");
        response.getMessages().forEach(this.err::println);
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(response.getMessagesCombined(", "));
        }
    }

    private void outputReports(List<AnalysisReport> listResponses) {
        TabularReportGenerator tabularReportGenerator = TabularReportGenerator.generator();
        if (this.summariseAcrossReports) {
            tabularReportGenerator = tabularReportGenerator.summariseAcrossReports();
        }
        if (this.reportPath != null) {
            if (Files.isDirectory(this.reportPath, new LinkOption[0])) {
                this.err.printf("Report file '%s' is directory!%n", this.reportPath.toFile().getAbsolutePath());
                return;
            }
            try {
                Files.createDirectories(this.reportPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.err.printf("Can not create report file directory '%s' %n", this.reportPath.getParent());
                return;
            }
            this.writeReportsToFile(tabularReportGenerator, listResponses);
            this.writeSummaryToFile(tabularReportGenerator);
        } else {
            this.outputReportsToOut(tabularReportGenerator, listResponses);
            this.outputSummaryToOut(tabularReportGenerator);
        }
    }

    private void outputReportsToOut(TabularReportGenerator tabularReportGenerator, List<AnalysisReport> listResponses) {
        this.out.println(tabularReportGenerator.generateReportTable(listResponses));
    }

    private void outputSummaryToOut(TabularReportGenerator tabularReportGenerator) {
        if (this.summariseAcrossReports) {
            this.out.println(tabularReportGenerator.getSummary());
        }
    }

    private void writeReportsToFile(TabularReportGenerator tabularReportGenerator, List<AnalysisReport> listResponses) {
        try {
            if (this.individualReportsByEntity) {
                this.writer.writeToExcel(tabularReportGenerator.generateReportByEntity(listResponses), this.reportPath);
            } else {
                this.writer.writeToExcel(tabularReportGenerator.generateReport(listResponses), this.reportPath);
            }
        }
        catch (IOException e) {
            this.outputException(e);
        }
    }

    private void writeSummaryToFile(TabularReportGenerator tabularReportGenerator) {
        if (this.summariseAcrossReports) {
            try {
                this.writer.writeToExcel(tabularReportGenerator.getSummary(), this.reportPath);
            }
            catch (IOException e) {
                this.outputException(e);
            }
        }
    }

    private void outputEndpoints(BrAPISpecificationAnalyserFactory.Analyser analyser) {
        if (this.reportPath != null) {
            if (Files.isDirectory(this.reportPath, new LinkOption[0])) {
                this.err.printf("Report file '%s' is directory!%n", this.reportPath.toFile().getAbsolutePath());
                return;
            }
            this.writeEndpointsToFile(analyser);
        } else {
            this.outputEndpointsToOut(analyser);
        }
    }

    private void writeEndpointsToFile(BrAPISpecificationAnalyserFactory.Analyser analyser) {
        DataFrame notAnalysed;
        DataFrame analysed;
        if (this.entityNames != null && !this.entityNames.isEmpty()) {
            analysed = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Analysed")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append(analyser.getEndpoints().stream().filter(endpoint -> this.entityNames.contains(endpoint.getEntityName())).toList()).toDataFrame();
            notAnalysed = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Not Analysed")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append(analyser.getEndpoints().stream().filter(endpoint -> !this.entityNames.contains(endpoint.getEntityName())).toList()).toDataFrame();
        } else {
            analysed = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Analysed")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append((Iterable)analyser.getEndpoints()).toDataFrame();
            notAnalysed = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Not Analysed")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append(new ArrayList()).toDataFrame();
        }
        DataFrame unmatched = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Unmatched")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append((Iterable)analyser.getUnmatchedEndpoints()).toDataFrame();
        DataFrame skipped = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Skipped")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append((Iterable)analyser.getSkippedEndpoints()).toDataFrame();
        DataFrame depreciated = DataFrame.byRow((Extractor[])new Extractor[]{Extractor.$col(Endpoint::getEntityName), Extractor.$col(Endpoint::getPath), Extractor.$col(Endpoint::getMethod), Extractor.$col(Endpoint::getCategory), Extractor.$val((Object)"Depreciated")}).columnNames(new String[]{"Entity", "Path", "Method", "Category", "Class"}).appender().append((Iterable)analyser.getDeprecatedEndpoints()).toDataFrame();
        DataFrame endpoints = analysed.vConcat(new DataFrame[]{notAnalysed, unmatched, skipped, depreciated}).as("Endpoints");
        try {
            this.writer.writeToExcel(endpoints, this.reportPath);
        }
        catch (IOException e) {
            this.outputException(e);
        }
    }

    private void outputEndpointsToOut(BrAPISpecificationAnalyserFactory.Analyser analyser) {
        this.out.println("Analysing Endpoints:");
        analyser.getEndpoints().forEach(this.out::println);
        this.out.println();
        this.out.println("Skipping Endpoints:");
        analyser.getSkippedEndpoints().forEach(this.out::println);
        this.out.println();
        this.out.println("Ignored Endpoints:");
        analyser.getUnmatchedEndpoints().forEach(this.out::println);
        this.out.println();
        this.out.println("Deprecated Endpoints:");
        analyser.getDeprecatedEndpoints().forEach(this.out::println);
    }

    private void outputValidation(Response<Validation> response) {
        this.err.println("Validation Errors:");
        response.getMessages().forEach(this.err::println);
    }

    private void outputException(Exception exception) throws BrAPICommandException {
        String message = String.format("%s: %s", exception.getClass().getSimpleName(), exception.getMessage());
        this.err.println(message);
        if (this.stackTrace) {
            exception.printStackTrace(this.err);
        }
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(message, exception);
        }
    }
}

