/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.brapi.schematools.cli.BrAPICommandException;
import org.brapi.schematools.core.response.Response;
import picocli.CommandLine;

public abstract class AbstractSubCommand
implements Runnable {
    private PrintWriter err;
    @CommandLine.Option(names={"-x", "--throwExceptionOnFail"}, description={"Throw an exception on failure. False by default, if set to True if an exception is thrown when validation or generation fails."})
    private boolean throwExceptionOnFail = false;
    @CommandLine.Option(names={"-t", "--stackTrace"}, description={"If an error is recorded output the stack trace."})
    private boolean stackTrace = false;

    @Override
    public void run() {
        try {
            this.err = new PrintWriter(System.err);
            this.execute();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        finally {
            this.closeOut();
            this.err.close();
        }
    }

    protected abstract void execute() throws IOException;

    protected void closeOut() {
    }

    protected void handleException(Exception exception) {
        this.printException(exception);
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(exception.getMessage(), exception);
        }
    }

    protected void handleError(String message) {
        this.err.println(message);
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(message);
        }
    }

    protected void printStackTrace(Exception exception) {
        if (this.stackTrace) {
            exception.printStackTrace(this.err);
        }
    }

    protected void printException(Exception exception) {
        String message = String.format("%s: %s", exception.getClass().getSimpleName(), exception.getMessage());
        this.err.println(message);
        this.printStackTrace(exception);
    }

    protected void printError(String errorMessage) {
        this.err.println(errorMessage);
    }

    protected void printErrors(String message, Collection<Response.Error> allErrors) {
        this.printError(message);
        allErrors.forEach(this::printError);
        if (this.throwExceptionOnFail) {
            throw new BrAPICommandException(message, allErrors);
        }
    }

    protected void printError(Response.Error error) {
        switch (error.getType()) {
            case VALIDATION: {
                this.err.print("Validation Error :");
                break;
            }
            case PERMISSION: 
            case OTHER: {
                this.err.print("Error :");
            }
        }
        this.err.print('\t');
        this.err.println(error.getMessage());
    }
}

