/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.introspection.IntrospectionQuery;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.jena.ontapi.model.OntModel;
import org.brapi.schematools.cli.AbstractSubCommand;
import org.brapi.schematools.cli.OutputFormat;
import org.brapi.schematools.core.graphql.GraphQLGenerator;
import org.brapi.schematools.core.graphql.metadata.GraphQLGeneratorMetadata;
import org.brapi.schematools.core.graphql.options.GraphQLGeneratorOptions;
import org.brapi.schematools.core.markdown.MarkdownGenerator;
import org.brapi.schematools.core.ontmodel.OntModelGenerator;
import org.brapi.schematools.core.ontmodel.metadata.OntModelGeneratorMetadata;
import org.brapi.schematools.core.ontmodel.options.OntModelGeneratorOptions;
import org.brapi.schematools.core.openapi.generator.OpenAPIGenerator;
import org.brapi.schematools.core.openapi.generator.metadata.OpenAPIGeneratorMetadata;
import org.brapi.schematools.core.openapi.generator.options.OpenAPIGeneratorOptions;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.OpenAPIUtils;
import org.brapi.schematools.core.xlsx.XSSFWorkbookGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="generate", mixinStandardHelpOptions=true, description={"Generates Various outputs from a BrAPI JSON schema, including OpenAPI Specification or GraphQL Schema"})
public class GenerateSubCommand
extends AbstractSubCommand {
    private PrintWriter out;
    private static final OutputFormat DEFAULT_FORMAT = OutputFormat.OPEN_API;
    @CommandLine.Parameters(index="0", description={"The directory containing the BrAPI JSON schema"})
    private Path schemaDirectory;
    @CommandLine.Option(names={"-l", "--language"}, defaultValue="GRAPHQL", fallbackValue="OPEN_API", description={"The format of the Output. Possible options are: ${COMPLETION-CANDIDATES}. Default is ${DEFAULT_FORMAT}"})
    private OutputFormat outputFormat = DEFAULT_FORMAT;
    @CommandLine.Option(names={"-f", "--file"}, description={"The path of the output file or directory for the generated result. If omitted the output will be written to the standard out"})
    private Path outputPath;
    @CommandLine.Option(names={"-c", "--components"}, description={"The directory containing the OpenAPI Components, required for the OPEN_API output format"})
    private Path componentsDirectory;
    @CommandLine.Option(names={"-o", "--options"}, description={"The path of the options file. If not provided the default options for the specified output format will be used."})
    private Path optionsPath;
    @CommandLine.Option(names={"-m", "--metadata"}, description={"The path of the metadata file. If not provided the default metadata for the specified output format will be used."})
    private Path metadataPath;
    @CommandLine.Option(names={"-r", "--overwrite"}, description={"Overwrite the output file(s) if it already exists. True by default, if set to False the output wll not be over writen."})
    private boolean overwrite = true;

    @Override
    public void execute() throws IOException {
        switch (this.outputFormat) {
            case OPEN_API: 
            case OPEN_API_JSON: {
                OpenAPIGeneratorOptions options = this.optionsPath != null ? OpenAPIGeneratorOptions.load((Path)this.optionsPath) : OpenAPIGeneratorOptions.load();
                OpenAPIGeneratorMetadata metadata = this.metadataPath != null ? OpenAPIGeneratorMetadata.load((Path)this.metadataPath) : OpenAPIGeneratorMetadata.load();
                this.generateOpenAPISpecification(options, metadata);
                break;
            }
            case GRAPHQL: 
            case GRAPHQL_INTROSPECTION: {
                GraphQLGeneratorOptions options = this.optionsPath != null ? GraphQLGeneratorOptions.load((Path)this.optionsPath) : GraphQLGeneratorOptions.load();
                GraphQLGeneratorMetadata metadata = this.metadataPath != null ? GraphQLGeneratorMetadata.load((Path)this.metadataPath) : GraphQLGeneratorMetadata.load();
                this.generateGraphQLSchema(options, metadata);
                break;
            }
            case OWL: {
                OntModelGeneratorOptions options = this.optionsPath != null ? OntModelGeneratorOptions.load((Path)this.optionsPath) : OntModelGeneratorOptions.load();
                OntModelGeneratorMetadata metadata = this.metadataPath != null ? OntModelGeneratorMetadata.load((Path)this.metadataPath) : OntModelGeneratorMetadata.load();
                this.generateOntModel(options, metadata);
                break;
            }
            case MARKDOWN: {
                this.generateMarkdown();
                break;
            }
            case XLSX: {
                this.generateExcel();
            }
        }
    }

    @Override
    protected void closeOut() {
        if (this.out != null) {
            this.out.close();
        }
    }

    private void generateGraphQLSchema(GraphQLGeneratorOptions options, GraphQLGeneratorMetadata metadata) {
        GraphQLGenerator graphQLGenerator = new GraphQLGenerator(options);
        Response response = graphQLGenerator.generate(this.schemaDirectory, metadata);
        response.onSuccessDoWithResultOnCondition(this.outputFormat == OutputFormat.GRAPHQL, this::outputIDLSchema).onSuccessDoWithResultOnCondition(this.outputFormat == OutputFormat.GRAPHQL_INTROSPECTION, this::outputIntrospectionSchema).onFailDoWithResponse(this::printGraphQLSchemaErrors);
    }

    private void outputIDLSchema(GraphQLSchema schema) {
        try {
            if (this.openWriter(this.outputPath)) {
                this.out.print(new SchemaPrinter().print(schema));
                this.out.close();
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private void outputIntrospectionSchema(GraphQLSchema schema) {
        try {
            GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
            ExecutionResult executionResult = graphQL.execute(IntrospectionQuery.INTROSPECTION_QUERY);
            ObjectMapper mapper = new ObjectMapper();
            if (this.openWriter(this.outputPath)) {
                this.out.print(mapper.writeValueAsString(executionResult.toSpecification().get("data")));
                this.out.close();
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private void printGraphQLSchemaErrors(Response<GraphQLSchema> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the GraphQL Schema", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating the GraphQL Schema", response.getAllErrors().size()), response.getAllErrors());
        }
    }

    private void generateOpenAPISpecification(OpenAPIGeneratorOptions options, OpenAPIGeneratorMetadata metadata) {
        OpenAPIGenerator openAPIGenerator = new OpenAPIGenerator(options);
        Response response = openAPIGenerator.generate(this.schemaDirectory, this.componentsDirectory, metadata);
        response.onSuccessDoWithResult(this::outputOpenAPISpecifications).onFailDoWithResponse(this::printOpenAPISpecificationErrors);
    }

    private void outputOpenAPISpecifications(List<OpenAPI> specifications) {
        try {
            if (specifications.size() == 1) {
                if (this.outputPath != null && Files.isDirectory(this.outputPath, new LinkOption[0])) {
                    this.outputOpenAPISpecification(specifications.getFirst(), this.resolveOutputPath(specifications.getFirst()));
                } else {
                    this.outputOpenAPISpecification(specifications.getFirst(), this.outputPath);
                }
            } else if (specifications.isEmpty()) {
                this.handleError("No specification to to output!");
            } else if (this.outputPath != null && Files.isRegularFile(this.outputPath, new LinkOption[0])) {
                this.handleError(String.format("Output path '%s' must be a directory if outputting to separate files.", this.outputPath.toFile()));
            } else {
                for (OpenAPI specification : specifications) {
                    this.outputOpenAPISpecification(specification, this.resolveOutputPath(specification));
                }
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private Path resolveOutputPath(OpenAPI specification) {
        return this.outputPath != null ? this.outputPath.resolve(String.format(this.outputFormat == OutputFormat.OPEN_API ? "%s.yaml" : "%s.json", specification.getInfo().getTitle())) : null;
    }

    private void outputOpenAPISpecification(OpenAPI specification, Path outputPath) throws IOException {
        if (this.openWriter(outputPath)) {
            this.out.print(OpenAPIUtils.prettyPrint((OpenAPI)specification, (String)(this.outputFormat == OutputFormat.OPEN_API_JSON ? "JSON" : "YAML")));
            this.out.close();
        }
    }

    private void printOpenAPISpecificationErrors(Response<List<OpenAPI>> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the OpenAPI Specification", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating the OpenAPI Specification", response.getAllErrors().size()), response.getAllErrors());
        }
    }

    private void generateOntModel(OntModelGeneratorOptions options, OntModelGeneratorMetadata metadata) {
        OntModelGenerator ontModelGenerator = new OntModelGenerator(options);
        Response response = ontModelGenerator.generate(this.schemaDirectory, metadata);
        response.onSuccessDoWithResult(this::outputOntModel).onFailDoWithResponse(this::printOntModelErrors);
    }

    private void outputOntModel(OntModel model) {
        try {
            if (this.openWriter(this.outputPath)) {
                model.write((Writer)this.out, "TURTLE");
                this.out.flush();
                this.out.close();
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private void printOntModelErrors(Response<OntModel> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the RDF Graph", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating the RDF Graph", response.getAllErrors().size()), response.getAllErrors());
        }
    }

    private boolean openWriter(Path outputPathFile) throws IOException {
        if (outputPathFile != null) {
            if (Files.isDirectory(outputPathFile, new LinkOption[0])) {
                this.handleError(String.format("Output path '%s' is a directory", this.outputPath));
                return false;
            }
            Files.createDirectories(outputPathFile.getParent(), new FileAttribute[0]);
            if (!this.overwrite && Files.isRegularFile(outputPathFile, new LinkOption[0])) {
                this.handleError(String.format("Output file '%s' already exists was not overwritten", this.outputPath));
                return false;
            }
            this.out = new PrintWriter(new FileOutputStream(outputPathFile.toFile()));
        } else {
            this.out = new PrintWriter(System.out);
        }
        return true;
    }

    private void generateMarkdown() {
        try {
            if (this.outputPath != null) {
                if (Files.isRegularFile(this.outputPath, new LinkOption[0])) {
                    this.handleError("For Markdown generation the output path must be a directory");
                } else {
                    Files.createDirectories(this.outputPath, new FileAttribute[0]);
                    MarkdownGenerator markdownGenerator = new MarkdownGenerator(this.outputPath, this.overwrite);
                    Response response = markdownGenerator.generate(this.schemaDirectory);
                    response.onSuccessDoWithResult(this::outputMarkdownPaths).onFailDoWithResponse(this::printMarkdownErrors);
                }
            } else {
                this.handleError("For Markdown generation the output directory must be provided");
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private void outputMarkdownPaths(List<Path> paths) {
        if (paths.isEmpty()) {
            System.out.println("Did not generate any markdown files");
        } else if (paths.size() == 1) {
            System.out.println("Generated '1' markdown file:");
            System.out.println(paths.getFirst().toString());
        } else {
            System.out.printf("Generated '%s' markdown files:%n", paths.size());
            paths.forEach(path -> System.out.println(path.toString()));
        }
    }

    private void printMarkdownErrors(Response<List<Path>> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the Markdown file(s)", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating the Markdown file(s)", response.getAllErrors().size()), response.getAllErrors());
        }
    }

    private void generateExcel() {
        try {
            if (this.outputPath != null) {
                Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
                if (Files.exists(this.outputPath, new LinkOption[0]) && !Files.isRegularFile(this.outputPath, new LinkOption[0])) {
                    this.handleError("For Excel (xlsx) generation the output path must be a file");
                } else {
                    XSSFWorkbookGenerator xssfWorkbookGenerator = new XSSFWorkbookGenerator(this.outputPath);
                    Response response = xssfWorkbookGenerator.generate(this.schemaDirectory);
                    response.onSuccessDoWithResult(this::outputExcelPaths).onFailDoWithResponse(this::printExcelErrors);
                }
            } else {
                this.handleError("For Excel (xlsx) generation the output file must be provided");
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void outputExcelPaths(List<Path> paths) {
        if (paths.isEmpty()) {
            System.out.println("Did not generate any excel files");
        } else if (paths.size() == 1) {
            System.out.println("Generated '1' excel file:");
            System.out.println(paths.getFirst().toString());
        } else {
            System.out.printf("Generated '%s' excel files:%n", paths.size());
            paths.forEach(path -> System.out.println(path.toString()));
        }
    }

    private void printExcelErrors(Response<List<Path>> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the Excel file", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating Excel file", response.getAllErrors().size()), response.getAllErrors());
        }
    }
}

