/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import java.io.PrintStream;
import org.brapi.schematools.core.authorization.oauth.SingleSignOn;
import picocli.CommandLine;

@CommandLine.Command(name="loginWithPassword", mixinStandardHelpOptions=true, description={"Login using 'Single Sign On (SSO)' to get access token"})
public class LoginSubCommand
implements Runnable {
    private final PrintStream out = System.out;
    private final PrintStream err = System.err;
    @CommandLine.Option(names={"-a", "--oauth"}, description={"The URL of the OAuth access token if used"})
    private String oauthURL;
    @CommandLine.Option(names={"-u", "--username"}, description={"The username for authentication if required. If not provided the current system username is used."})
    private String username = System.getProperty("user.name");
    @CommandLine.Option(names={"-p", "--password"}, interactive=true, arity="0..1", description={"The password for the supplied username. Will fail if not logged in and the password is not provided. Providing the option without a value make the application as for a value."})
    private String password;
    @CommandLine.Option(names={"-c", "--client"}, description={"The client id for authentication if required."})
    private String clientId;
    @CommandLine.Option(names={"-s", "--secret"}, description={"The client secret for authentication if required."})
    private String clientSecret;
    @CommandLine.Option(names={"-n", "--name"}, description={"The name of the SSO which is used as a sub-directory to store the token. If not provided the host URL is used."})
    private String name;

    @Override
    public void run() {
        if (this.password != null) {
            SingleSignOn.builder().name(this.name).url(this.oauthURL).username(this.username).build().loginWithPassword(this.password).onSuccessDo(() -> this.out.println("Logged in!")).onFailDoWithResponse(response -> this.err.printf("Login failed due to %s%n", response.getMessagesCombined(", ")));
        } else if (this.clientSecret != null) {
            SingleSignOn.builder().name(this.name).url(this.oauthURL).clientId(this.clientId).build().loginWithClientId(this.clientSecret).onSuccessDo(() -> this.out.println("Logged in!")).onFailDoWithResponse(response -> this.err.printf("Login failed due to %s%n", response.getMessagesCombined(", ")));
        } else {
            this.err.printf(String.format("Not logged please provide password using option '-p' for user '%s' or client secret for client '%s'", this.username, this.clientId), new Object[0]);
        }
    }
}

