/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.brapi.schematools.cli.AbstractSubCommand;
import org.brapi.schematools.cli.InputFormat;
import org.brapi.schematools.core.authorization.AuthorizationProvider;
import org.brapi.schematools.core.authorization.BasicAuthorizationProvider;
import org.brapi.schematools.core.authorization.BearerAuthorizationProvider;
import org.brapi.schematools.core.authorization.NoAuthorizationProvider;
import org.brapi.schematools.core.authorization.oauth.OpenIDToken;
import org.brapi.schematools.core.authorization.oauth.SingleSignOn;
import org.brapi.schematools.core.graphql.GraphQLSchemaParser;
import org.brapi.schematools.core.markdown.GraphQLMarkdownGenerator;
import org.brapi.schematools.core.markdown.GraphQLMarkdownGeneratorOptions;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="markdown", mixinStandardHelpOptions=true, description={"Generates Markdown descriptions from a GraphQL Schema"})
public class MarkdownSubCommand
extends AbstractSubCommand {
    private static final List<String> VALID_METHODS = Arrays.asList("GET", "POST");
    private static final InputFormat DEFAULT_FORMAT = InputFormat.GRAPHQL;
    @CommandLine.Parameters(index="0", description={"The URL or file path of the schema, or the result of an introspection query specification. If the path is a valid URL an introspection query will be sent to it. if the path is a file it will be read, otherwise it will be treated as the result of an introspection query."})
    private String schemaPath;
    @CommandLine.Option(names={"-l", "--language"}, defaultValue="GRAPHQL", fallbackValue="GRAPHQL", description={"The format of the Input. Possible options are: ${COMPLETION-CANDIDATES}. Default is ${DEFAULT_FORMAT}"})
    private InputFormat inputFormat = DEFAULT_FORMAT;
    @CommandLine.Option(names={"-f", "--file"}, description={"The path of the output file or directory for the generated result. If omitted the output will be written to the standard out"})
    private Path outputPath;
    @CommandLine.Option(names={"-a", "--oauth"}, description={"The URL of the OAuth access token if used"})
    private String oauthURL;
    @CommandLine.Option(names={"-o", "--options"}, description={"The path of the options file. If not provided the default options for the specified output format will be used."})
    private Path optionsPath;
    @CommandLine.Option(names={"-u", "--username"}, description={"The username for authentication if required. If not provided the current system username is used."})
    private String username = System.getProperty("user.name");
    @CommandLine.Option(names={"-p", "--password"}, interactive=true, arity="0..1", description={"The password for the supplied username. Will fail if not logged in and the password is not provided. Providing the option without a value make the application as for a value."})
    private String password;
    @CommandLine.Option(names={"-c", "--client"}, description={"The client id for authentication if required."})
    private String clientId;
    @CommandLine.Option(names={"-s", "--secret"}, description={"The client secret for authentication if required."})
    private String clientSecret;
    @CommandLine.Option(names={"-b", "--bearer"}, description={"The bearer token for authentication if required."})
    private String bearer;
    @CommandLine.Option(names={"-m", "--method"}, description={"If the schema path is an URL provide the HTTP method. The default is GET."})
    private String method;
    @CommandLine.Option(names={"-r", "--overwrite"}, description={"Overwrite the output file(s) if it already exists. True by default, if set to False the output wll not be over writen."})
    private boolean overwrite = true;

    @Override
    public void execute() throws IOException {
        if (Objects.requireNonNull(this.inputFormat) == InputFormat.GRAPHQL) {
            this.generateMarkdown();
        } else {
            this.printError(String.format("Unsupported input format '%s'", new Object[]{this.inputFormat}));
        }
    }

    private void generateMarkdown() throws IOException {
        if (this.outputPath != null) {
            if (Files.isRegularFile(this.outputPath, new LinkOption[0])) {
                this.printError("For Markdown generation the output path must be a directory");
                return;
            }
            if (this.method != null) {
                this.method = this.method.toUpperCase();
                if (!VALID_METHODS.contains(this.method)) {
                    this.printError(String.format("Unsupported method '%s'", this.method));
                    return;
                }
            } else {
                this.method = "GET";
            }
            Files.createDirectories(this.outputPath, new FileAttribute[0]);
            GraphQLMarkdownGeneratorOptions options = this.optionsPath != null ? GraphQLMarkdownGeneratorOptions.load((Path)this.optionsPath) : GraphQLMarkdownGeneratorOptions.load();
            options.setOverwrite(Boolean.valueOf(this.overwrite));
            GraphQLMarkdownGenerator markdownGenerator = GraphQLMarkdownGenerator.generator((Path)this.outputPath).options(options);
            this.readSchema(this.schemaPath, options).mapResultToResponse(this::parseJsonSchema).mapResultToResponse(arg_0 -> ((GraphQLMarkdownGenerator)markdownGenerator).generate(arg_0)).onSuccessDoWithResult(this::outputMarkdownPaths).onFailDoWithResponse(this::printMarkdownErrors);
        } else {
            this.printError("For Markdown generation the output directory must be provided");
        }
    }

    private Response<GraphQLSchema> parseJsonSchema(String schema) {
        GraphQLSchemaParser parser = new GraphQLSchemaParser();
        try {
            return Response.success((Object)parser.parseJsonSchema(schema));
        }
        catch (JsonProcessingException e) {
            return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Unable to parse schema from '%s'", schema));
        }
    }

    private Response<String> readSchema(String schema, GraphQLMarkdownGeneratorOptions options) throws IOException {
        if (schema.startsWith("http")) {
            return this.authorisation().mapResultToResponse(authorizationProvider -> this.queryForSchema((AuthorizationProvider)authorizationProvider, schema, options));
        }
        Path path = Path.of(schema, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return StringUtils.readStringFromPath((Path)path);
        }
        return Response.success((Object)schema);
    }

    private Response<String> queryForSchema(AuthorizationProvider authorizationProvider, String url, GraphQLMarkdownGeneratorOptions options) {
        try {
            HttpResponse<String> response;
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(new URI(url)).method(this.method, HttpRequest.BodyPublishers.ofString(new ObjectMapper().writeValueAsString(Collections.singletonMap("query", options.getIntrospectionQuery()))));
            if (authorizationProvider.required()) {
                authorizationProvider.getAuthorization().onSuccessDoWithResult(authorization -> builder.header("Authorization", (String)authorization));
            }
            if ((response = HttpClient.newHttpClient().send(builder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
                if (options.getIntrospectionQueryJsonPath() != null) {
                    String schema = (String)JsonPath.read((String)response.body(), (String)options.getIntrospectionQueryJsonPath(), (Predicate[])new Predicate[0]);
                    if (schema == null || schema.isEmpty()) {
                        return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Unable to extract schema from '%s', using JSONPath, '%s'", response.body(), options.getIntrospectionQueryJsonPath()));
                    }
                    return Response.success((Object)schema);
                }
                return Response.success((Object)response.body());
            }
            return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)String.format("Unable to get schema from '%s', status code %d, '%s'", url, response.statusCode(), response.body()));
        }
        catch (IOException | InterruptedException | URISyntaxException exception) {
            this.printStackTrace(exception);
            return Response.fail((Response.ErrorType)Response.ErrorType.VALIDATION, (String)exception.getMessage());
        }
    }

    private Response<AuthorizationProvider> authorisation() {
        if (this.oauthURL != null) {
            SingleSignOn sso = SingleSignOn.builder().url(this.oauthURL).clientId(this.clientId).username(this.username).build();
            return sso.getToken().or(() -> this.login(sso)).merge(() -> Response.success((Object)sso));
        }
        if (this.password != null) {
            return Response.success((Object)BasicAuthorizationProvider.builder().username(this.username).password(this.password).build());
        }
        if (this.bearer != null) {
            return Response.success((Object)BearerAuthorizationProvider.builder().token(this.bearer).build());
        }
        return Response.success((Object)new NoAuthorizationProvider());
    }

    private Response<OpenIDToken> login(SingleSignOn sso) {
        if (this.password != null) {
            return sso.loginWithPassword(this.password);
        }
        if (this.clientSecret != null) {
            return sso.loginWithClientId(this.clientSecret);
        }
        return Response.fail((Response.ErrorType)Response.ErrorType.PERMISSION, (String)String.format("Not logged in please provide password using option '-p' for user '%s' or client secret for client '%s'", this.username, this.clientId));
    }

    private void outputMarkdownPaths(List<Path> paths) {
        if (paths.isEmpty()) {
            System.out.println("Did not generate any markdown files");
        } else if (paths.size() == 1) {
            System.out.println("Generated '1' markdown file:");
            System.out.println(paths.getFirst().toString());
        } else {
            System.out.printf("Generated '%s' markdown files:%n", paths.size());
            paths.forEach(path -> System.out.println(path.toString()));
        }
    }

    private void printMarkdownErrors(Response<List<Path>> response) {
        if (response.getAllErrors().size() == 1) {
            this.printErrors("There was 1 error generating the Markdown", response.getAllErrors());
        } else {
            this.printErrors(String.format("There were %d errors generating the Markdown", response.getAllErrors().size()), response.getAllErrors());
        }
    }
}

