/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.introspection.IntrospectionQuery;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import java.util.Map;

public class GraphQLSchemaParser {
    private final ObjectMapper objectMapper;

    public GraphQLSchemaParser() {
        this.objectMapper = new ObjectMapper();
    }

    public GraphQLSchemaParser(ObjectMapper mapper) {
        this.objectMapper = mapper;
    }

    public GraphQLSchema parseJsonSchema(String jsonSchema) throws JsonProcessingException {
        IntrospectionResultToSchema introspectionResultToSchema = new IntrospectionResultToSchema();
        Map map = (Map)this.objectMapper.readValue(jsonSchema, Map.class);
        Document document = introspectionResultToSchema.createSchemaDefinition((Map)map.get("data"));
        String sdl = new SchemaPrinter().print(document);
        TypeDefinitionRegistry registry = new SchemaParser().parse(sdl);
        return UnExecutableSchemaGenerator.makeUnExecutableSchema((TypeDefinitionRegistry)registry);
    }

    public String writeSchemaToString(GraphQLSchema schema) throws JsonProcessingException {
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)schema).build();
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(IntrospectionQuery.INTROSPECTION_QUERY).build();
        ExecutionResult execute = graphQL.execute(executionInput);
        return this.objectMapper.writeValueAsString((Object)execute.toSpecification());
    }
}

