/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.brapi.schematools.core.metadata.Metadata;
import org.brapi.schematools.core.utils.ConfigurationUtils;

public class GraphQLGeneratorMetadata
implements Metadata {
    private String title;
    private String version;

    public static GraphQLGeneratorMetadata load() {
        try {
            return ConfigurationUtils.load("graphql-metadata.yaml", GraphQLGeneratorMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphQLGeneratorMetadata load(Path metadataFile) throws IOException {
        return GraphQLGeneratorMetadata.load().override(ConfigurationUtils.load(metadataFile, GraphQLGeneratorMetadata.class));
    }

    public static GraphQLGeneratorMetadata load(InputStream inputStream) throws IOException {
        return GraphQLGeneratorMetadata.load().override(ConfigurationUtils.load(inputStream, GraphQLGeneratorMetadata.class));
    }

    public GraphQLGeneratorMetadata override(GraphQLGeneratorMetadata overrideMetadata) {
        if (overrideMetadata.title != null) {
            this.setTitle(overrideMetadata.title);
        }
        if (overrideMetadata.version != null) {
            this.setVersion(overrideMetadata.version);
        }
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

