/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.markdown;

import com.fasterxml.jackson.annotation.JsonIgnore;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.regex.Matcher;
import org.brapi.schematools.core.markdown.GraphQLMarkdownGenerator;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.validiation.Validation;

public class GraphQLMarkdownGeneratorOptions
implements Options {
    private Boolean overwrite;
    private String queryDefinitionsDirectory;
    private String typeDefinitionsDirectory;
    private String descriptionsDirectory;
    private String fieldsDirectory;
    private String argumentsDirectory;
    private Boolean createTopLevelFieldDefinitions;
    private Boolean createTopLevelInputFieldDefinitions;
    private Boolean createTopLeveArgumentDefinitions;
    private String introspectionQuery;

    public static GraphQLMarkdownGeneratorOptions load() {
        try {
            return ConfigurationUtils.load("graphql-markdown-options.yaml", GraphQLMarkdownGeneratorOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphQLMarkdownGeneratorOptions load(Path optionsFile) throws IOException {
        return GraphQLMarkdownGeneratorOptions.load().override(ConfigurationUtils.load(optionsFile, GraphQLMarkdownGeneratorOptions.class));
    }

    public static GraphQLMarkdownGeneratorOptions load(InputStream inputStream) throws IOException {
        return GraphQLMarkdownGeneratorOptions.load().override(ConfigurationUtils.load(inputStream, GraphQLMarkdownGeneratorOptions.class));
    }

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.overwrite, "'overwrite' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.queryDefinitionsDirectory, "'queryDefinitionsDirectory' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.typeDefinitionsDirectory, "'typeDefinitionsDirectory' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.descriptionsDirectory, "'descriptionsDirectory' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.fieldsDirectory, "'fieldsDirectory' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.argumentsDirectory, "'argumentsDirectory' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.createTopLevelFieldDefinitions, "'createTopLevelFieldDefinitions' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.createTopLeveArgumentDefinitions, "'createTopLeveArgumentDefinitions' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.introspectionQuery, "'introspectionQuery' option on %s is null", this.getClass().getSimpleName());
    }

    public GraphQLMarkdownGeneratorOptions override(GraphQLMarkdownGeneratorOptions overrideOptions) {
        if (overrideOptions.overwrite != null) {
            this.overwrite = overrideOptions.overwrite;
        }
        if (overrideOptions.queryDefinitionsDirectory != null) {
            this.queryDefinitionsDirectory = overrideOptions.queryDefinitionsDirectory;
        }
        if (overrideOptions.typeDefinitionsDirectory != null) {
            this.typeDefinitionsDirectory = overrideOptions.typeDefinitionsDirectory;
        }
        if (overrideOptions.descriptionsDirectory != null) {
            this.descriptionsDirectory = overrideOptions.descriptionsDirectory;
        }
        if (overrideOptions.fieldsDirectory != null) {
            this.fieldsDirectory = overrideOptions.fieldsDirectory;
        }
        if (overrideOptions.argumentsDirectory != null) {
            this.argumentsDirectory = overrideOptions.argumentsDirectory;
        }
        if (overrideOptions.createTopLevelFieldDefinitions != null) {
            this.createTopLevelFieldDefinitions = overrideOptions.createTopLevelFieldDefinitions;
        }
        if (overrideOptions.createTopLeveArgumentDefinitions != null) {
            this.createTopLeveArgumentDefinitions = overrideOptions.createTopLeveArgumentDefinitions;
        }
        if (overrideOptions.introspectionQuery != null) {
            this.introspectionQuery = overrideOptions.introspectionQuery;
        }
        return this;
    }

    @JsonIgnore
    public boolean isOverwritingExistingFiles() {
        return this.overwrite;
    }

    public String getDescriptionForObjectType(GraphQLObjectType type, GraphQLOutputType dataType, GraphQLFieldDefinition queryDefinition) {
        if (dataType != null) {
            if (queryDefinition != null) {
                return String.format("%s is the response for the %s query, which returns %s.", type.getName(), this.getMarkdownLink(queryDefinition, "../../" + this.queryDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)dataType, ""));
            }
            return String.format("%s is an Response Object Type, which returns %s.", type.getName(), this.getMarkdownLink((GraphQLType)dataType, ""));
        }
        return String.format("%s is an Object Type.", type.getName());
    }

    public String getDescriptionForInputObjectType(GraphQLInputObjectType type, GraphQLFieldDefinition queryDefinition) {
        if (queryDefinition != null) {
            return String.format("%s is used as an input for the %s query.", type.getName(), this.getMarkdownLink(queryDefinition, "../../" + this.queryDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
        }
        return String.format("%s is an Input Type.", type.getName());
    }

    public String getDescriptionForQuery(GraphQLFieldDefinition queryDefinition, GraphQLOutputType dataType, GraphQLInputType inputType) {
        GraphQLOutputType graphQLOutputType = queryDefinition.getType();
        if (graphQLOutputType instanceof GraphQLNamedType) {
            GraphQLNamedType graphQLNamedType = (GraphQLNamedType)graphQLOutputType;
            Matcher matcher = GraphQLMarkdownGenerator.LIST_RESPONSE_PATTERN.matcher(graphQLNamedType.getName());
            if (matcher.matches()) {
                return this.getDescriptionForListQuery(queryDefinition, dataType, inputType);
            }
            matcher = GraphQLMarkdownGenerator.SEARCH_RESPONSE_PATTERN.matcher(graphQLNamedType.getName());
            if (matcher.matches()) {
                return this.getDescriptionForSearchQuery(queryDefinition, dataType, inputType);
            }
        }
        if (inputType != null) {
            return String.format("The %s query returns a %s, that matches the filters provided %s Input.", queryDefinition.getName(), this.getMarkdownLink((GraphQLType)queryDefinition.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)inputType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s query returns a %s.", queryDefinition.getName(), this.getMarkdownLink((GraphQLType)queryDefinition.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
    }

    public String getDescriptionForListQuery(GraphQLFieldDefinition query, GraphQLOutputType dataType, GraphQLInputType inputType) {
        if (dataType != null) {
            if (inputType != null) {
                return String.format("The %s query returns a %s, which is a paged list of %s values that matches the filters provided %s Input.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)dataType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)inputType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
            }
            return String.format("The %s query returns a %s, which is a paged list of %s values.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)dataType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s query returns a %s value.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
    }

    public String getDescriptionForSearchQuery(GraphQLFieldDefinition query, GraphQLOutputType dataType, GraphQLInputType inputType) {
        if (dataType != null) {
            if (inputType != null) {
                return String.format("The %s query returns a %s, which is a complete list of %s that matches the filters provided %s Input or a searchResultsDbId that can be used to lookup a results at a later point.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)dataType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)inputType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
            }
            return String.format("The %s query returns a %s, which is a complete list of %s that matches the filters provided by the Input or a searchResultsDbId that can be used to lookup a results at a later point.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)dataType, "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s query returns a %s value.", query.getName(), this.getMarkdownLink((GraphQLType)query.getType(), "../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
    }

    public String getDescriptionForInterface(GraphQLInterfaceType type) {
        return String.format("%s is an Interface.", type.getName());
    }

    public String getDescriptionForEnum(GraphQLEnumType type) {
        return String.format("%s is an Enumerated value.", type.getName());
    }

    public String getDescriptionForField(GraphQLNamedType type, GraphQLFieldDefinition field) {
        if (field.getArguments().isEmpty()) {
            if (type != null) {
                return String.format("The %s field in type %s returns a %s value.", field.getName(), this.getMarkdownLink((GraphQLType)type, "../../" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)field.getType(), "../../" + this.descriptionsDirectory + "/"));
            }
            return String.format("The %s field returns %s value.", field.getName(), this.getMarkdownLink((GraphQLType)field.getType(), "../../" + this.descriptionsDirectory + "/"));
        }
        if (type != null) {
            return String.format("The sub-query %s is a sub-query in type %s returns a %s value.", field.getName(), this.getMarkdownLink((GraphQLType)type, "../../" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)field.getType(), "../../" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s sub-query returns %s value.", field.getName(), this.getMarkdownLink((GraphQLType)field.getType(), "../../" + this.descriptionsDirectory + "/"));
    }

    public String getDescriptionForInputField(GraphQLInputObjectType type, GraphQLFieldDefinition queryDefinition, GraphQLInputObjectField field) {
        if (type != null) {
            if (queryDefinition != null) {
                return String.format("The %s field in type %s is used in the %s query to filter the returned results.", field.getName(), this.getMarkdownLink((GraphQLType)type, "../../" + this.descriptionsDirectory + "/"), this.getMarkdownLink(queryDefinition, "../../../" + this.queryDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
            }
            return String.format("The %s field in type %s is used to filter query results.", field.getName(), this.getMarkdownLink((GraphQLType)type, "../../" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s field returns %s value.", field.getName(), this.getMarkdownLink((GraphQLType)field.getType(), "../../" + this.descriptionsDirectory + "/"));
    }

    public String getDescriptionForArgument(GraphQLFieldDefinition queryDefinition, GraphQLArgument argument) {
        if (queryDefinition != null) {
            return String.format("The %s argument for query %s accepts a value of %s.", argument.getName(), this.getMarkdownLink(queryDefinition, "../../" + this.descriptionsDirectory + "/"), this.getMarkdownLink((GraphQLType)argument.getType(), "../../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
        }
        return String.format("The %s argument accepts a value of %s.", argument.getName(), this.getMarkdownLink((GraphQLType)argument.getType(), "../../../" + this.typeDefinitionsDirectory + "/" + this.descriptionsDirectory + "/"));
    }

    public boolean isCreatingTopLevelFieldDefinitions() {
        return this.createTopLevelFieldDefinitions != null && this.createTopLevelFieldDefinitions != false;
    }

    public boolean isCreatingTopLevelInputFieldDefinitions() {
        return this.createTopLevelInputFieldDefinitions != null && this.createTopLevelInputFieldDefinitions != false;
    }

    public boolean isCreatingTopLevelArgumentDefinitions() {
        return this.createTopLeveArgumentDefinitions != null && this.createTopLeveArgumentDefinitions != false;
    }

    private String getMarkdownLink(GraphQLType type, String prefix) {
        if (type instanceof GraphQLNamedType) {
            GraphQLNamedType graphQLNamedType = (GraphQLNamedType)type;
            if (type instanceof GraphQLScalarType) {
                return graphQLNamedType.getName();
            }
            return String.format("[%s](%s%s.md)", graphQLNamedType.getName(), prefix, graphQLNamedType.getName());
        }
        if (type instanceof GraphQLList) {
            GraphQLList graphQLList = (GraphQLList)type;
            return String.format("list of %s", this.getMarkdownLink(graphQLList.getWrappedType(), prefix));
        }
        if (type instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)type;
            return String.format("%s", this.getMarkdownLink(graphQLNonNull.getWrappedType(), prefix));
        }
        return type.toString();
    }

    private String getMarkdownLink(GraphQLFieldDefinition queryDefinition, String prefix) {
        return String.format("[%s](%s%s.md)", queryDefinition.getName(), prefix, queryDefinition.getName());
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public String getQueryDefinitionsDirectory() {
        return this.queryDefinitionsDirectory;
    }

    public String getTypeDefinitionsDirectory() {
        return this.typeDefinitionsDirectory;
    }

    public String getDescriptionsDirectory() {
        return this.descriptionsDirectory;
    }

    public String getFieldsDirectory() {
        return this.fieldsDirectory;
    }

    public String getArgumentsDirectory() {
        return this.argumentsDirectory;
    }

    public Boolean getCreateTopLevelFieldDefinitions() {
        return this.createTopLevelFieldDefinitions;
    }

    public Boolean getCreateTopLevelInputFieldDefinitions() {
        return this.createTopLevelInputFieldDefinitions;
    }

    public Boolean getCreateTopLeveArgumentDefinitions() {
        return this.createTopLeveArgumentDefinitions;
    }

    public String getIntrospectionQuery() {
        return this.introspectionQuery;
    }

    public GraphQLMarkdownGeneratorOptions setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setQueryDefinitionsDirectory(String queryDefinitionsDirectory) {
        this.queryDefinitionsDirectory = queryDefinitionsDirectory;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setTypeDefinitionsDirectory(String typeDefinitionsDirectory) {
        this.typeDefinitionsDirectory = typeDefinitionsDirectory;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setDescriptionsDirectory(String descriptionsDirectory) {
        this.descriptionsDirectory = descriptionsDirectory;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setFieldsDirectory(String fieldsDirectory) {
        this.fieldsDirectory = fieldsDirectory;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setArgumentsDirectory(String argumentsDirectory) {
        this.argumentsDirectory = argumentsDirectory;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setCreateTopLevelFieldDefinitions(Boolean createTopLevelFieldDefinitions) {
        this.createTopLevelFieldDefinitions = createTopLevelFieldDefinitions;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setCreateTopLevelInputFieldDefinitions(Boolean createTopLevelInputFieldDefinitions) {
        this.createTopLevelInputFieldDefinitions = createTopLevelInputFieldDefinitions;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setCreateTopLeveArgumentDefinitions(Boolean createTopLeveArgumentDefinitions) {
        this.createTopLeveArgumentDefinitions = createTopLeveArgumentDefinitions;
        return this;
    }

    public GraphQLMarkdownGeneratorOptions setIntrospectionQuery(String introspectionQuery) {
        this.introspectionQuery = introspectionQuery;
        return this;
    }

    private GraphQLMarkdownGeneratorOptions() {
    }

    private GraphQLMarkdownGeneratorOptions(Boolean overwrite, String queryDefinitionsDirectory, String typeDefinitionsDirectory, String descriptionsDirectory, String fieldsDirectory, String argumentsDirectory, Boolean createTopLevelFieldDefinitions, Boolean createTopLevelInputFieldDefinitions, Boolean createTopLeveArgumentDefinitions, String introspectionQuery) {
        this.overwrite = overwrite;
        this.queryDefinitionsDirectory = queryDefinitionsDirectory;
        this.typeDefinitionsDirectory = typeDefinitionsDirectory;
        this.descriptionsDirectory = descriptionsDirectory;
        this.fieldsDirectory = fieldsDirectory;
        this.argumentsDirectory = argumentsDirectory;
        this.createTopLevelFieldDefinitions = createTopLevelFieldDefinitions;
        this.createTopLevelInputFieldDefinitions = createTopLevelInputFieldDefinitions;
        this.createTopLeveArgumentDefinitions = createTopLeveArgumentDefinitions;
        this.introspectionQuery = introspectionQuery;
    }
}

