/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.comparator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openapitools.openapidiff.core.exception.RendererException;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.output.Render;

public class JsonRender
implements Render {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonRender(boolean prettyPrint) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        this.objectMapper.findAndRegisterModules();
    }

    public void render(ChangedOpenApi diff, OutputStreamWriter outputStreamWriter) {
        try {
            this.objectMapper.writeValue((Writer)outputStreamWriter, (Object)diff);
            outputStreamWriter.close();
        }
        catch (JsonProcessingException var4) {
            throw new RendererException("Could not serialize diff as JSON", (Throwable)var4);
        }
        catch (IOException var5) {
            throw new RendererException((Throwable)var5);
        }
    }
}

