/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.comparator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.brapi.schematools.core.openapi.comparator.ComparisonOutputFormat;
import org.brapi.schematools.core.openapi.comparator.JsonRender;
import org.brapi.schematools.core.openapi.comparator.options.OpenAPIComparatorOptions;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;
import org.openapitools.openapidiff.core.OpenApiCompare;
import org.openapitools.openapidiff.core.compare.OpenApiDiffOptions;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.Endpoint;
import org.openapitools.openapidiff.core.output.AsciidocRender;
import org.openapitools.openapidiff.core.output.HtmlRender;
import org.openapitools.openapidiff.core.output.MarkdownRender;

public class OpenAPIComparator {
    private final OpenAPIComparatorOptions options;
    private final List<Pattern> ignoreMissingEndpoints;
    private final List<Pattern> ignoreNewEndpoints;

    public OpenAPIComparator() {
        this(OpenAPIComparatorOptions.load());
    }

    public OpenAPIComparator(OpenAPIComparatorOptions options) {
        this.options = options;
        this.ignoreMissingEndpoints = options.getIgnoreMissingEndpoints() != null ? options.getIgnoreMissingEndpoints().stream().map(Pattern::compile).toList() : new ArrayList<Pattern>();
        this.ignoreNewEndpoints = options.getIgnoreNewEndpoints() != null ? options.getIgnoreNewEndpoints().stream().map(Pattern::compile).toList() : new ArrayList<Pattern>();
    }

    public Response<ChangedOpenApi> compare(Path firstPath, Path secondPath) {
        if (Files.isRegularFile(firstPath, new LinkOption[0]) && Files.isRegularFile(secondPath, new LinkOption[0])) {
            return Response.success(this.filterDiff(OpenApiCompare.fromFiles((File)firstPath.toFile(), (File)secondPath.toFile())));
        }
        if (!Files.isRegularFile(firstPath, new LinkOption[0]) && !Files.isRegularFile(secondPath, new LinkOption[0])) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Both input paths need to be regular files, Path 1: '%s' Path 2: '%s'", firstPath, secondPath));
        }
        if (!Files.isRegularFile(firstPath, new LinkOption[0])) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("First input path is not a regular file, Path 1: '%s'", firstPath));
        }
        return Response.fail(Response.ErrorType.VALIDATION, String.format("Second input path is not a regular file, Path 1: '%s'", secondPath));
    }

    public Response<Path> compare(Path firstPath, Path secondPath, Path outputPath, ComparisonOutputFormat outputFormat) {
        return this.findActualOutputPath(outputPath, outputFormat).mapResultToResponse(actualOutputPath -> this.compare(firstPath, secondPath).mapResultToResponse(diff -> this.renderOutput((ChangedOpenApi)diff, (Path)actualOutputPath, outputFormat)));
    }

    public Response<ChangedOpenApi> compare(String firstContent, String secondContent) {
        if (StringUtils.isNotBlank(firstContent) && StringUtils.isNotBlank(secondContent)) {
            return Response.success(this.filterDiff(OpenApiCompare.fromContents((String)firstContent, (String)secondContent, null, (OpenApiDiffOptions)this.createOptions())));
        }
        if (!StringUtils.isNotBlank(firstContent) && !StringUtils.isNotBlank(secondContent)) {
            return Response.fail(Response.ErrorType.VALIDATION, "Both input content need to be non blank");
        }
        if (!StringUtils.isNotBlank(firstContent)) {
            return Response.fail(Response.ErrorType.VALIDATION, "First input content need to be non blank");
        }
        return Response.fail(Response.ErrorType.VALIDATION, "Second input content need to be non blank");
    }

    public Response<Path> compare(String firstContent, String secondContent, Path outputPath, ComparisonOutputFormat outputFormat) {
        return this.findActualOutputPath(outputPath, outputFormat).mapResultToResponse(actualOutputPath -> this.compare(firstContent, secondContent).mapResultToResponse(diff -> this.renderOutput((ChangedOpenApi)diff, (Path)actualOutputPath, outputFormat)));
    }

    private OpenApiDiffOptions createOptions() {
        return OpenApiDiffOptions.builder().build();
    }

    private ChangedOpenApi filterDiff(ChangedOpenApi changedOpenApi) {
        return new ChangedOpenApi(this.createOptions()).setChangedExtensions(changedOpenApi.getChangedExtensions()).setChangedOperations(changedOpenApi.getChangedOperations().stream().filter(this::keepChangedOperation).toList()).setChangedSchemas(changedOpenApi.getChangedSchemas().stream().filter(this::keepChangedSchema).toList()).setMissingEndpoints(changedOpenApi.getMissingEndpoints().stream().filter(this::keepMissingEndpoint).toList()).setNewEndpoints(changedOpenApi.getNewEndpoints().stream().filter(this::keepNewEndpoint).toList()).setNewSpecOpenApi(changedOpenApi.getNewSpecOpenApi()).setOldSpecOpenApi(changedOpenApi.getOldSpecOpenApi());
    }

    private Response<Path> findActualOutputPath(Path outputPath, ComparisonOutputFormat outputFormat) {
        if (outputPath == null) {
            try {
                outputPath = Files.createTempFile(this.options.getTempFilePrefix(), this.getTempFileSuffix(outputFormat), new FileAttribute[0]);
            }
            catch (IOException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Parent directory can not created due to '%s'", e.getMessage()));
            }
        }
        if (outputPath.getParent() != null) {
            try {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Parent directory '%s' can not created", outputPath.getParent()));
            }
        }
        return Response.success(outputPath);
    }

    private String getTempFileSuffix(ComparisonOutputFormat outputFormat) {
        return switch (outputFormat) {
            default -> throw new MatchException(null, null);
            case ComparisonOutputFormat.HTML -> "html";
            case ComparisonOutputFormat.MARKDOWN -> "md";
            case ComparisonOutputFormat.ASCIIDOC -> "txt";
            case ComparisonOutputFormat.JSON -> "json";
        };
    }

    private Response<Path> renderOutput(ChangedOpenApi diff, Path outputPath, ComparisonOutputFormat outputFormat) {
        return switch (outputFormat) {
            default -> throw new MatchException(null, null);
            case ComparisonOutputFormat.HTML -> this.renderHtml(diff, outputPath);
            case ComparisonOutputFormat.MARKDOWN -> this.renderMarkdown(diff, outputPath);
            case ComparisonOutputFormat.ASCIIDOC -> this.renderAsciidoc(diff, outputPath);
            case ComparisonOutputFormat.JSON -> this.renderJson(diff, outputPath);
        };
    }

    private Response<Path> renderHtml(ChangedOpenApi diff, Path outputPath) {
        try {
            HtmlRender htmlRender = new HtmlRender(this.options.getHtml().getTitle(), this.options.getHtml().getLinkCss(), this.options.getHtml().isShowingAllChanges());
            FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            htmlRender.render(diff, outputStreamWriter);
        }
        catch (FileNotFoundException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create or use output file '%s'", outputPath));
        }
        return Response.success(outputPath);
    }

    private Response<Path> renderMarkdown(ChangedOpenApi diff, Path outputPath) {
        try {
            MarkdownRender markdownRender = new MarkdownRender();
            markdownRender.setShowChangedMetadata(this.options.getMarkdown().isShowingChangedMetadata());
            FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            markdownRender.render(diff, outputStreamWriter);
        }
        catch (FileNotFoundException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create or use output file '%s'", outputPath));
        }
        return Response.success(outputPath);
    }

    private Response<Path> renderAsciidoc(ChangedOpenApi diff, Path outputPath) {
        try {
            AsciidocRender asciidocRender = new AsciidocRender();
            FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            asciidocRender.render(diff, outputStreamWriter);
        }
        catch (FileNotFoundException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create or use output file '%s'", outputPath));
        }
        return Response.success(outputPath);
    }

    private Response<Path> renderJson(ChangedOpenApi diff, Path outputPath) {
        try {
            JsonRender jsonRender = new JsonRender(this.options.getJson().isPrettyPrinting());
            FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            jsonRender.render(diff, outputStreamWriter);
        }
        catch (FileNotFoundException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create or use output file '%s'", outputPath));
        }
        return Response.success(outputPath);
    }

    private boolean keepChangedOperation(ChangedOperation changedOperation) {
        return true;
    }

    private boolean keepChangedSchema(ChangedSchema changedSchema) {
        return true;
    }

    private boolean keepMissingEndpoint(Endpoint endpoint) {
        if (this.options.isIgnoringDeprecatedEndpoints() && endpoint.getOperation().getDeprecated() != null && endpoint.getOperation().getDeprecated().booleanValue()) {
            return false;
        }
        return this.ignoreMissingEndpoints.stream().noneMatch(pattern -> pattern.matcher(endpoint.getPathUrl()).matches());
    }

    private boolean keepNewEndpoint(Endpoint endpoint) {
        return this.ignoreNewEndpoints.stream().noneMatch(pattern -> pattern.matcher(endpoint.getPathUrl()).matches());
    }
}

