/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIRelationshipType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.BrAPIObjectTypeWithProperty;
import org.brapi.schematools.core.openapi.generator.LinkType;
import org.brapi.schematools.core.openapi.generator.OpenAPIComponentsReader;
import org.brapi.schematools.core.openapi.generator.metadata.OpenAPIGeneratorMetadata;
import org.brapi.schematools.core.openapi.generator.options.OpenAPIGeneratorOptions;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.BrAPITypeUtils;
import org.brapi.schematools.core.utils.StringUtils;

public class OpenAPIGenerator {
    public static final String BRAPI_COMMON = "BrAPI-Common";
    private final BrAPISchemaReader schemaReader;
    private final OpenAPIComponentsReader componentsReader;
    private final OpenAPIGeneratorOptions options;

    public OpenAPIGenerator() {
        this(new BrAPISchemaReader(), new OpenAPIComponentsReader(), OpenAPIGeneratorOptions.load());
    }

    public OpenAPIGenerator(OpenAPIGeneratorOptions options) {
        this(new BrAPISchemaReader(), new OpenAPIComponentsReader(), options);
    }

    public Response<List<OpenAPI>> generate(Path schemaDirectory, Path componentsDirectory) {
        return this.generate(schemaDirectory, componentsDirectory, new OpenAPIGeneratorMetadata());
    }

    public Response<List<OpenAPI>> generate(Path schemaDirectory, Path componentsDirectory, OpenAPIGeneratorMetadata metadata) {
        return this.options.validate().asResponse().merge(this.componentsReader.readComponents(componentsDirectory)).mapResultToResponse(components -> this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator(this.options, metadata, (List<BrAPIClass>)brAPISchemas, (Components)components).generate()));
    }

    public Response<List<OpenAPI>> generate(Path schemaDirectory, Path componentsDirectory, Collection<String> classNames) {
        return this.generate(schemaDirectory, componentsDirectory, new OpenAPIGeneratorMetadata(), classNames);
    }

    public Response<List<OpenAPI>> generate(Path schemaDirectory, Path componentsDirectory, OpenAPIGeneratorMetadata metadata, Collection<String> classNames) {
        return this.options.validate().asResponse().merge(this.componentsReader.readComponents(componentsDirectory)).mapResultToResponse(components -> this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator(this.options, metadata, (List<BrAPIClass>)brAPISchemas, (Components)components).generate(classNames)));
    }

    public OpenAPIGenerator(BrAPISchemaReader schemaReader, OpenAPIComponentsReader componentsReader, OpenAPIGeneratorOptions options) {
        this.schemaReader = schemaReader;
        this.componentsReader = componentsReader;
        this.options = options;
    }

    private static class Generator {
        private final OpenAPIGeneratorOptions options;
        private final OpenAPIGeneratorMetadata metadata;
        private final Map<String, BrAPIClass> brAPIClassMap;
        private final Map<String, Parameter> parameters;
        private final Map<String, ApiResponse> responses;
        private final Map<String, Schema> schemas;
        private final Map<String, SecurityScheme> securitySchemes;
        private final Set<String> referencedSchemas;

        public Generator(OpenAPIGeneratorOptions options, OpenAPIGeneratorMetadata metadata, List<BrAPIClass> brAPIClasses, Components components) {
            this.options = options;
            this.metadata = metadata;
            this.brAPIClassMap = brAPIClasses.stream().collect(Collectors.toMap(BrAPIType::getName, Function.identity()));
            this.parameters = components.getParameters() != null ? new HashMap<String, Parameter>(components.getParameters()) : new HashMap<String, Parameter>();
            this.responses = components.getResponses() != null ? new HashMap<String, ApiResponse>(components.getResponses()) : new HashMap<String, ApiResponse>();
            this.schemas = components.getSchemas() != null ? new HashMap<String, Schema>(components.getSchemas()) : new HashMap<String, Schema>();
            this.securitySchemes = components.getSecuritySchemes() != null ? new HashMap<String, SecurityScheme>(components.getSecuritySchemes()) : new HashMap<String, SecurityScheme>();
            this.referencedSchemas = new TreeSet<String>();
        }

        public Response<List<OpenAPI>> generate() {
            return this.generateSpecifications(this.brAPIClassMap.values());
        }

        public Response<List<OpenAPI>> generate(Collection<String> classNames) {
            if (classNames != null && !classNames.isEmpty()) {
                Collection values = this.brAPIClassMap.values().stream().filter(brAPIClass -> classNames.contains(brAPIClass.getName())).collect(Collectors.toSet());
                return this.generateSpecifications(values);
            }
            return this.generateSpecifications(this.brAPIClassMap.values());
        }

        public Response<List<OpenAPI>> generateSpecifications(Collection<BrAPIClass> classes) {
            if (this.options.isSeparatingByModule()) {
                Map classesByModule = classes.stream().filter(type -> Objects.nonNull(type.getModule())).collect(Collectors.groupingBy(BrAPIClass::getModule, Collectors.toList()));
                List commonClasses = classesByModule.remove(OpenAPIGenerator.BRAPI_COMMON);
                Response<List<OpenAPI>> res = classesByModule.entrySet().stream().map(entry -> {
                    if (commonClasses != null) {
                        ((List)entry.getValue()).addAll(commonClasses);
                    }
                    return entry;
                }).map(entry -> this.generateSpecifications(this.metadata.getTitleFor((String)entry.getKey()), this.options.getSupplementalSpecificationFor(this.metadata.getTitleFor((String)entry.getKey())), (Collection)entry.getValue())).collect(Response.toList());
                return res;
            }
            return this.generateSpecifications(this.metadata.getTitle(), this.options.getSupplementalSpecification(), classes.stream().filter(type -> Objects.nonNull(type.getModule())).toList()).mapResult(Collections::singletonList);
        }

        private Response<OpenAPI> generateSpecifications(String title, String supplementalSpecPath, Collection<BrAPIClass> classes) {
            OpenAPI openAPI;
            if (supplementalSpecPath != null && !supplementalSpecPath.isEmpty()) {
                try {
                    String supplementalSpecPathAbs = Path.of(supplementalSpecPath, new String[0]).toRealPath(new LinkOption[0]).toString();
                    OpenAPI supplementalOpenAPI = new OpenAPIParser().readLocation(supplementalSpecPathAbs, null, null).getOpenAPI();
                    openAPI = Objects.requireNonNullElseGet(supplementalOpenAPI, OpenAPI::new);
                }
                catch (IOException e) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find supplemental specification file : %s", e.getMessage()));
                }
            } else {
                openAPI = new OpenAPI();
            }
            Info info = new Info();
            info.setTitle(title != null ? title : "BrAPI");
            info.setVersion(this.metadata.getVersion() != null ? this.metadata.getVersion() : "0.0.0");
            openAPI.setInfo(info);
            ArrayList<BrAPIClass> nonPrimaryClasses = new ArrayList<BrAPIClass>(classes.stream().filter(BrAPITypeUtils::isNonPrimaryModel).toList());
            List<BrAPIObjectType> primaryClasses = classes.stream().filter(type -> type instanceof BrAPIObjectType).filter(BrAPITypeUtils::isPrimaryModel).sorted(Comparator.comparing(BrAPIType::getName)).map(type -> (BrAPIObjectType)type).toList();
            return Response.empty().mergeOnCondition(this.options.isGeneratingEndpoint(), () -> primaryClasses.stream().filter(this.options::isGeneratingEndpointFor).map(type -> this.generatePathItem((BrAPIObjectType)type).onSuccessDoWithResult(pathItem -> openAPI.path(this.createPathItemName((BrAPIObjectType)type), pathItem))).collect(Response.toList())).mapOnCondition(this.options.getControlledVocabulary().isGenerating(), () -> primaryClasses.stream().flatMap(this::findControlledVocabularyProperties).filter(this.options.getControlledVocabulary()::isGeneratingFor).map(typeWithProperty -> this.createControlledVocabularyPathItem((BrAPIObjectTypeWithProperty)typeWithProperty).onSuccessDoWithResult(pathItem -> openAPI.path(this.options.getPathItemNameForProperty((BrAPIObjectTypeWithProperty)typeWithProperty), pathItem))).collect(Response.toList())).mergeOnCondition(this.options.isGeneratingEndpointWithId(), () -> primaryClasses.stream().filter(this.options::isGeneratingEndpointNameWithIdFor).map(type -> this.createPathItemsWithId(openAPI, (BrAPIObjectType)type)).collect(Response.toList())).mergeOnCondition(this.options.getSearch().isGenerating(), () -> primaryClasses.stream().filter(type -> this.options.getSearch().isGeneratingFor((BrAPIType)type)).map(type -> this.createSearchPathItem((BrAPIObjectType)type).onSuccessDoWithResult(pathItem -> openAPI.path(this.createSearchPathItemName((BrAPIObjectType)type), pathItem))).collect(Response.toList())).mergeOnCondition(this.options.getSearch().isGenerating(), () -> primaryClasses.stream().filter(type -> this.options.getSearch().isGeneratingFor((BrAPIType)type)).map(type -> this.createSearchPathItemWithId((BrAPIObjectType)type).onSuccessDoWithResult(pathItem -> openAPI.path(this.createSearchPathItemWithIdName((BrAPIObjectType)type), pathItem))).collect(Response.toList())).merge(() -> this.processReferencedSchemas(classes).onSuccessDoWithResult(nonPrimaryClasses::addAll)).merge(() -> this.generateComponents(primaryClasses, nonPrimaryClasses, openAPI.getComponents()).onSuccessDoWithResult(arg_0 -> ((OpenAPI)openAPI).components(arg_0))).map(() -> Response.success(openAPI));
        }

        private Response<List<BrAPIClass>> processReferencedSchemas(Collection<BrAPIClass> classes) {
            classes.stream().map(BrAPIType::getName).toList().forEach(this.referencedSchemas::remove);
            this.schemas.keySet().forEach(this.referencedSchemas::remove);
            this.securitySchemes.keySet().forEach(this.referencedSchemas::remove);
            return this.referencedSchemas.stream().map(this::findReferencedClass).collect(Response.toList());
        }

        private Response<BrAPIClass> findReferencedClass(String typeName) {
            BrAPIClass brAPISchema = this.brAPIClassMap.get(typeName);
            if (brAPISchema != null) {
                return Response.success(brAPISchema);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find referenced type %s", typeName));
        }

        private String createPathItemName(BrAPIObjectType type) {
            return this.options.getPathItemNameFor(type);
        }

        private Response<PathItem> generatePathItem(BrAPIObjectType type) {
            PathItem pathItem = new PathItem();
            return Response.empty().mergeOnCondition(this.options.getListGet().isGeneratingFor(type), () -> this.generateListGetOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setGet(arg_0))).mergeOnCondition(this.options.getPost().isGeneratingFor(type), () -> this.generatePostOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setPost(arg_0))).mergeOnCondition(this.options.getPut().isGeneratingEndpointFor(type), () -> this.generateMultiplePutOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setPut(arg_0))).merge(() -> this.generateListResponse(type)).map(() -> Response.success(pathItem));
        }

        private String createPathItemWithIdName(BrAPIObjectType type) {
            return this.options.getPathItemWithIdNameFor(type);
        }

        private String createSubPathItemName(String pathItemName, BrAPIObjectProperty property) {
            return this.options.getSubPathItemNameFor(pathItemName, property);
        }

        private Response<OpenAPI> createPathItemsWithId(OpenAPI openAPI, BrAPIObjectType type) {
            String pathItemName = this.createPathItemWithIdName(type);
            return this.createPathItemWithId(type).onSuccessDoWithResult(pathItem -> openAPI.path(pathItemName, pathItem)).merge(type.getProperties().stream().filter(property -> this.options.isGeneratingSubPathFor(type, (BrAPIObjectProperty)property)).map(property -> this.createSubPathItemWithId(type, (BrAPIObjectProperty)property).onSuccessDoWithResult(subPathItem -> openAPI.path(this.createSubPathItemName(pathItemName, (BrAPIObjectProperty)property), subPathItem))).collect(Response.toList())).map(() -> Response.success(openAPI));
        }

        private Response<PathItem> createPathItemWithId(BrAPIObjectType type) {
            PathItem pathItem = new PathItem();
            return Response.empty().mergeOnCondition(this.options.getSingleGet().isGeneratingFor(type), () -> this.generateSingleGetOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setGet(arg_0))).mergeOnCondition(this.options.getPut().isGeneratingEndpointNameWithIdFor(type), () -> this.generateSinglePutOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setPut(arg_0))).mergeOnCondition(this.options.getDelete().isGeneratingFor(type), () -> this.generateDeleteOperation(type).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setDelete(arg_0))).merge(() -> this.generateSingleResponse(type)).map(() -> Response.success(pathItem));
        }

        private Response<PathItem> createSubPathItemWithId(BrAPIObjectType parentType, BrAPIObjectProperty property) {
            PathItem pathItem = new PathItem();
            BrAPIType type = this.dereferenceType(property.getType());
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                return this.generateSubPathSingleGetOperation(parentType, brAPIObjectType).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setGet(arg_0)).map(() -> Response.success(pathItem));
            }
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                int dimension = 1;
                BrAPIType itemType = this.dereferenceType(brAPIArrayType.getItems());
                while (itemType instanceof BrAPIArrayType) {
                    BrAPIArrayType brAPIArrayItemType = (BrAPIArrayType)itemType;
                    itemType = this.dereferenceType(brAPIArrayItemType.getItems());
                    ++dimension;
                }
                if (itemType instanceof BrAPIObjectType) {
                    BrAPIObjectType brAPIObjectType = (BrAPIObjectType)itemType;
                    if (dimension > 1) {
                        return Response.fail(Response.ErrorType.VALIDATION, String.format("Sub-path not available for property '%s' on type '%s' with type '%s', dimension > 1", property.getName(), parentType.getName(), type.getName()));
                    }
                    return this.generateSubPathListGetOperation(parentType, brAPIObjectType).onSuccessDoWithResult(arg_0 -> ((PathItem)pathItem).setGet(arg_0)).map(() -> Response.success(pathItem));
                }
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Sub-path not available for property '%s' on type '%s' with type '%s'", property.getName(), parentType.getName(), type.getName()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Sub-path not available for property '%s' on type '%s' with type '%s'", property.getName(), parentType.getName(), type.getName()));
        }

        private Stream<BrAPIObjectTypeWithProperty> findControlledVocabularyProperties(BrAPIObjectType type) {
            if (type.getMetadata() != null && type.getMetadata().getControlledVocabularyProperties() != null && !type.getMetadata().getControlledVocabularyProperties().isEmpty()) {
                return type.getProperties().stream().filter(property -> type.getMetadata().getControlledVocabularyProperties().contains(property.getName())).map(property -> BrAPIObjectTypeWithProperty.builder().type(type).property((BrAPIObjectProperty)property).build());
            }
            return Stream.empty();
        }

        private Response<PathItem> createControlledVocabularyPathItem(BrAPIObjectTypeWithProperty typeWithProperty) {
            PathItem pathItem = new PathItem();
            Operation operation = new Operation();
            operation.setSummary(this.options.getControlledVocabulary().getSummaryFor(typeWithProperty.getType(), typeWithProperty.getProperty()));
            operation.setDescription(this.options.getControlledVocabulary().getDescriptionFor(typeWithProperty.getType(), typeWithProperty.getProperty()));
            operation.addTagsItem(this.options.getTagFor(typeWithProperty.getType()));
            pathItem.setGet(operation);
            return this.createListApiResponses(typeWithProperty).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).merge(() -> this.generateListResponse(typeWithProperty)).map(() -> Response.success(pathItem));
        }

        private Response<ApiResponse> generateSingleResponse(BrAPIObjectType type) {
            String name = this.options.getSingleResponseNameFor(type);
            ApiResponse apiResponse = new ApiResponse().description("OK").content(new Content().addMediaType("application/json", new MediaType().schema(new ObjectSchema().title(name).addProperty("@context", new ObjectSchema().$ref(this.createSchemaRef("Context"))).addProperty("metadata", new ObjectSchema().$ref(this.createSchemaRef("metadata"))).addProperty("result", new ObjectSchema().$ref(this.createSchemaRef(type.getName()))).addRequiredItem("metadata").addRequiredItem("result"))));
            this.responses.put(name, apiResponse);
            return Response.success(apiResponse);
        }

        private Response<ApiResponse> generateListResponse(BrAPIObjectType type) {
            String name = this.options.getListResponseNameFor(type);
            if (this.responses.containsKey(name)) {
                return Response.success(this.responses.get(name));
            }
            ApiResponse apiResponse = new ApiResponse().description("OK").content(new Content().addMediaType("application/json", new MediaType().schema(new ObjectSchema().title(name).addProperty("@context", new ObjectSchema().$ref(this.createSchemaRef("Context"))).addProperty("metadata", new ObjectSchema().$ref(this.createSchemaRef("metadata"))).addProperty("result", new ObjectSchema().addProperty("data", (Schema)new ArraySchema().items(new Schema().$ref(this.createSchemaRef(type.getName())))).addRequiredItem("data")).addRequiredItem("metadata").addRequiredItem("result"))));
            this.responses.put(name, apiResponse);
            return Response.success(apiResponse);
        }

        private Response<ApiResponse> generateListResponse(BrAPIObjectTypeWithProperty typeWithProperty) {
            String name = this.options.getListResponseNameFor(typeWithProperty);
            if (this.responses.containsKey(name)) {
                return Response.success(this.responses.get(name));
            }
            Schema itemSchema = typeWithProperty.getProperty().getType() instanceof BrAPIObjectType ? new Schema().$ref(this.createSchemaRef(typeWithProperty.getProperty().getType().getName())) : this.createSchemaForType(typeWithProperty.getProperty().getType()).getResultOrThrow();
            ApiResponse apiResponse = new ApiResponse().description("OK").content(new Content().addMediaType("application/json", new MediaType().schema(new ObjectSchema().title(name).addProperty("@context", new ObjectSchema().$ref(this.createSchemaRef("Context"))).addProperty("metadata", new ObjectSchema().$ref(this.createSchemaRef("metadata"))).addProperty("result", new ObjectSchema().addProperty("data", (Schema)new ArraySchema().items(itemSchema)).addRequiredItem("data")).addRequiredItem("metadata").addRequiredItem("result"))));
            this.responses.put(name, apiResponse);
            return Response.success(apiResponse);
        }

        private Response<Operation> generateListGetOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getListGet().getSummaryOrDefault(type.getName(), this.options.getListGet().getSummaryFor(type)));
            operation.setDescription(this.metadata.getListGet().getDescriptionOrDefault(type.getName(), this.options.getListGet().getDescriptionFor(type)));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createListGetParametersFor(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).parameters(arg_0)).map(() -> this.createListApiResponses(type)).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<List<Parameter>> createListGetParametersFor(BrAPIObjectType type) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            if (type.getProperties().stream().anyMatch(property -> property.getName().equals("externalReferences"))) {
                parameters.add(new Parameter().$ref("#/components/parameters/externalReferenceID"));
                parameters.add(new Parameter().$ref("#/components/parameters/externalReferenceId"));
                parameters.add(new Parameter().$ref("#/components/parameters/externalReferenceSource"));
            }
            if (this.options.getListGet().isPagedFor(type)) {
                parameters.add(new Parameter().$ref("#/components/parameters/page"));
                parameters.add(new Parameter().$ref("#/components/parameters/pageSize"));
                parameters.add(new Parameter().$ref("#/components/parameters/authorizationHeader"));
            }
            if (this.options.getListGet().hasInputFor(type)) {
                BrAPIClass requestClass = this.brAPIClassMap.get(String.format("%sRequest", type.getName()));
                if (requestClass == null) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find '%sRequest' to create properties for list get endpoint for '%s'", type.getName(), this.createPathItemName(type)));
                }
                if (requestClass instanceof BrAPIObjectType) {
                    BrAPIObjectType brAPIObjectType = (BrAPIObjectType)requestClass;
                    return brAPIObjectType.getProperties().stream().filter(property -> this.options.getListGet().isUsingPropertyFromRequestFor(type, (BrAPIObjectProperty)property)).map(this::createListGetParameter).collect(Response.toList()).onSuccessDoWithResult(result -> parameters.addAll(0, (Collection<Parameter>)result)).map(() -> Response.success(parameters));
                }
                return Response.fail(Response.ErrorType.VALIDATION, String.format("'%sRequest' must be BrAPIObjectType but was '%s'", type.getName(), type.getClass().getSimpleName()));
            }
            return Response.success(parameters);
        }

        private Response<Parameter> createListGetParameter(BrAPIObjectProperty property) {
            return this.createSchemaForType(property.getType()).mapResult(schema -> new Parameter().name(this.options.getSingularForProperty(property.getName())).in("query").description(property.getDescription()).required(Boolean.valueOf(property.isRequired())).schema(this.upwrapSchema((Schema)schema)));
        }

        private Schema upwrapSchema(Schema schema) {
            if (schema instanceof ArraySchema) {
                return schema.getItems();
            }
            return schema;
        }

        private Response<Operation> generatePostOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getPost().getSummaryOrDefault(type.getName(), this.options.getPost().getSummaryFor(type)));
            operation.setDescription(this.metadata.getPost().getDescriptionOrDefault(type.getName(), this.options.getPost().getDescriptionFor(type)));
            operation.addParametersItem(new Parameter().$ref("#/components/parameters/authorizationHeader"));
            String requestBodyName = this.options.isGeneratingNewRequestFor(type) ? this.options.getNewRequestNameFor(type) : type.getName();
            operation.requestBody(new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(new ArraySchema().$ref(String.format("#/components/schemas/%s", requestBodyName))))));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createListApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateSingleGetOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getSingleGet().getSummaryOrDefault(type.getName(), this.options.getSingleGet().getSummaryFor(type)));
            operation.setDescription(this.metadata.getSingleGet().getDescriptionOrDefault(type.getName(), this.options.getSingleGet().getDescriptionFor(type)));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createSingleApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateSinglePutOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getPut().getSummaryOrDefault(type.getName(), this.options.getPut().getSummaryFor(type)));
            operation.setDescription(this.metadata.getPut().getDescriptionOrDefault(type.getName(), this.options.getPut().getDescriptionFor(type)));
            operation.addParametersItem(new Parameter().$ref("#/components/parameters/authorizationHeader"));
            String requestBodyName = this.options.isGeneratingNewRequestFor(type) ? this.options.getNewRequestNameFor(type) : type.getName();
            operation.requestBody(new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref(String.format("#/components/schemas/%s", requestBodyName))))));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createSingleApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateMultiplePutOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getPut().getSummaryOrDefault(type.getName(), this.options.getPut().getSummaryFor(type)));
            operation.setDescription(this.metadata.getPut().getDescriptionOrDefault(type.getName(), this.options.getPut().getDescriptionFor(type)));
            operation.addParametersItem(new Parameter().$ref("#/components/parameters/authorizationHeader"));
            String requestBodyName = this.options.isGeneratingNewRequestFor(type) ? this.options.getNewRequestNameFor(type) : type.getName();
            operation.requestBody(new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(new ArraySchema().$ref(String.format("#/components/schemas/%s", requestBodyName))))));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createListApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateDeleteOperation(BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getDelete().getSummaryOrDefault(type.getName(), this.options.getDelete().getSummaryFor(type)));
            operation.setDescription(this.metadata.getDelete().getDescriptionOrDefault(type.getName(), this.options.getDelete().getDescriptionFor(type)));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createSingleApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateSubPathSingleGetOperation(BrAPIObjectType parentType, BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getSingleGet().getSummaryOrDefault(type.getName(), this.options.getSingleGet().getSummaryFor(type)));
            operation.setDescription(this.metadata.getSingleGet().getDescriptionOrDefault(type.getName(), this.options.getSingleGet().getDescriptionFor(type)));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createSingleApiResponses(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<Operation> generateSubPathListGetOperation(BrAPIObjectType parentType, BrAPIObjectType type) {
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getListGet().getSummaryOrDefault(type.getName(), this.options.getListGet().getSummaryFor(type)));
            operation.setDescription(this.metadata.getListGet().getDescriptionOrDefault(type.getName(), this.options.getListGet().getDescriptionFor(type)));
            operation.addTagsItem(this.options.getTagFor(type));
            return this.createListGetParametersFor(type).onSuccessDoWithResult(arg_0 -> ((Operation)operation).parameters(arg_0)).map(() -> this.createListApiResponses(type)).onSuccessDoWithResult(arg_0 -> ((Operation)operation).responses(arg_0)).map(() -> Response.success(operation));
        }

        private Response<ApiResponses> createSingleApiResponses(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                return Response.success(this.addStandardApiResponses(new ApiResponses().addApiResponse("200", new ApiResponse().$ref(String.format("#/components/responses/%sSingleResponse", type.getName())))));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create a List API Response for '%s' which is a '%s'", type.getName(), type.getClass().getSimpleName()));
        }

        private Response<ApiResponses> createListApiResponses(BrAPIType type) {
            return Response.success(this.addStandardApiResponses(new ApiResponses().addApiResponse("200", new ApiResponse().$ref(String.format("#/components/responses/" + this.options.getListResponseNameFor(type), new Object[0])))));
        }

        private Response<ApiResponses> createListApiResponses(BrAPIObjectTypeWithProperty typeWithProperty) {
            return Response.success(this.addStandardApiResponses(new ApiResponses().addApiResponse("200", new ApiResponse().$ref(String.format("#/components/responses/" + this.options.getListResponseNameFor(typeWithProperty), typeWithProperty.getType().getName(), StringUtils.toSentenceCase(typeWithProperty.property.getName()))))));
        }

        private ApiResponses addStandardApiResponses(ApiResponses apiResponses) {
            return apiResponses.addApiResponse("400", new ApiResponse().$ref("#/components/responses/400BadRequest")).addApiResponse("401", new ApiResponse().$ref("#/components/responses/401Unauthorized")).addApiResponse("403", new ApiResponse().$ref("#/components/responses/403Forbidden"));
        }

        private String createSearchPathItemName(BrAPIObjectType type) {
            return String.format("/search%s", this.options.getPathItemNameFor(type));
        }

        private String createSearchPathItemWithIdName(BrAPIObjectType type) {
            return String.format("/search%s/{%s}", this.options.getPathItemNameFor(type), this.options.getSearch().getSearchIdFieldName());
        }

        public Response<PathItem> createSearchPathItem(BrAPIObjectType type) {
            PathItem pathItem = new PathItem();
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getSearch().getSummaryOrDefault(type.getName(), this.options.getSearch().getSummaryFor(type)));
            operation.setDescription(this.metadata.getSearch().getDescriptionOrDefault(type.getName(), this.options.getSearch().getSubmitDescriptionFormat(type)));
            operation.responses(this.createSearchPostResponseRefs(type));
            operation.addTagsItem(this.options.getTagFor(type));
            pathItem.setPost(operation);
            return this.generateListResponse(type).map(() -> Response.success(pathItem));
        }

        private ApiResponses createSearchPostResponseRefs(BrAPIObjectType type) {
            return this.addStandardApiResponses(new ApiResponses().addApiResponse("200", new ApiResponse().$ref(String.format("#/components/responses/%sListResponse", type.getName()))).addApiResponse("202", new ApiResponse().$ref("#/components/responses/202AcceptedSearchResponse")));
        }

        public Response<PathItem> createSearchPathItemWithId(BrAPIObjectType type) {
            PathItem pathItem = new PathItem();
            Operation operation = new Operation();
            operation.setSummary(this.metadata.getSearch().getSummaryOrDefault(type.getName(), this.options.getSearch().getSubmitDescriptionFormat(type)));
            operation.setDescription(this.metadata.getSearch().getDescriptionOrDefault(type.getName(), this.options.getSearch().getRetrieveDescriptionFormat(type)));
            operation.responses(this.createSearchGetResponseRefs(type));
            operation.addTagsItem(this.options.getTagFor(type));
            pathItem.setGet(operation);
            return this.generateListResponse(type).map(() -> Response.success(pathItem));
        }

        private ApiResponses createSearchGetResponseRefs(BrAPIObjectType type) {
            return this.addStandardApiResponses(new ApiResponses().addApiResponse("200", new ApiResponse().$ref(String.format("#/components/responses/%sListResponse", type.getName()))));
        }

        private Response<Components> generateComponents(Collection<BrAPIObjectType> primaryTypes, Collection<BrAPIClass> nonPrimaryTypes, Components supplementalComponents) {
            Components components;
            Components components2 = components = supplementalComponents != null ? supplementalComponents : new Components();
            if (components.getSchemas() == null) {
                components.setSchemas(new LinkedHashMap());
            }
            if (components.getResponses() == null) {
                components.setResponses(new LinkedHashMap());
            }
            if (components.getParameters() == null) {
                components.setParameters(new LinkedHashMap());
            }
            if (components.getSecuritySchemes() == null) {
                components.setSecuritySchemes(new LinkedHashMap());
            }
            return this.generateSchemas(primaryTypes, nonPrimaryTypes).onSuccessDoWithResult(schemaMap -> this.mergeComponents(components.getSchemas(), (Map)schemaMap)).merge(this::generateResponses).onSuccessDoWithResult(responsesMap -> this.mergeComponents(components.getResponses(), (Map)responsesMap)).merge(this::generateParameters).onSuccessDoWithResult(paramsMap -> this.mergeComponents(components.getParameters(), (Map)paramsMap)).merge(this::generateSecuritySchemes).onSuccessDoWithResult(securityMap -> this.mergeComponents(components.getSecuritySchemes(), (Map)securityMap)).map(() -> Response.success(components));
        }

        private <T> Map<String, T> mergeComponents(Map<String, T> existingComponents, Map<String, T> newComponents) {
            if (newComponents != null && !newComponents.isEmpty()) {
                existingComponents.putAll(newComponents);
            }
            return existingComponents;
        }

        private Response<Map<String, Schema>> generateSchemas(Collection<BrAPIObjectType> primaryTypes, Collection<BrAPIClass> nonPrimaryTypes) {
            TreeMap schemas = new TreeMap();
            return primaryTypes.stream().map(type -> this.generateSchemasForType((BrAPIObjectType)type).onSuccessDoWithResult(schemas::putAll)).collect(Response.toList()).merge(nonPrimaryTypes.stream().map(type -> this.createSchemaForType((BrAPIType)type).onSuccessDoWithResult(schema -> schemas.put(type.getName(), schema))).collect(Response.toList())).onSuccessDo(() -> schemas.putAll(this.schemas)).map(() -> Response.success(schemas));
        }

        private Response<Map<String, Schema>> generateSchemasForType(BrAPIObjectType type) {
            TreeMap schemas = new TreeMap();
            boolean creatingNewRequest = this.options.isGeneratingNewRequestFor(type);
            return Response.empty().merge(() -> this.createSchemaForType(type, creatingNewRequest).onSuccessDoWithResult(result -> schemas.put(type.getName(), result))).mergeOnCondition(creatingNewRequest, () -> this.createNewRequestSchemaForType(type).onSuccessDoWithResult(result -> schemas.put(this.options.getNewRequestNameFor(type), result))).mergeOnCondition(this.options.getSearch().isGeneratingFor(type), () -> this.createSearchRequestSchemaForType(type).onSuccessDoWithResult(result -> schemas.put(this.options.getSearchRequestNameFor(type), result))).map(() -> Response.success(schemas));
        }

        private Response<Schema> createSchemaForType(BrAPIObjectType type, boolean creatingNewRequest) {
            if (creatingNewRequest) {
                String idParameter = this.options.getProperties().getIdPropertyNameFor(type);
                if (type.getProperties().stream().noneMatch(property -> property.getName().equals(idParameter))) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find property '%s' in type '%s'", idParameter, type.getName()));
                }
                return this.createObjectSchema(type, type.getProperties().stream().filter(property -> !property.getName().equals(idParameter)).toList()).onSuccessDoWithResult(result -> result.addRequiredItem(idParameter));
            }
            return this.createObjectSchema(type);
        }

        private Response<Schema> createNewRequestSchemaForType(BrAPIObjectType type) {
            String idParameter = this.options.getProperties().getIdPropertyNameFor(type);
            if (type.getProperties().stream().noneMatch(property -> property.getName().equals(idParameter))) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find property '%s' in type '%s'", idParameter, type.getName()));
            }
            return this.createObjectSchema(type).onSuccessDoWithResult(result -> result.addRequiredItem(idParameter));
        }

        private Response<Schema> createSearchRequestSchemaForType(BrAPIObjectType type) {
            BrAPIClass requestSchema = this.brAPIClassMap.get(String.format("%sRequest", type.getName()));
            String name = this.options.getSearchRequestNameFor(type);
            if (requestSchema == null) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find '%sRequest' when creating '%s'", type.getName(), name));
            }
            if (requestSchema instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)requestSchema;
                Schema objectSchema = new ObjectSchema().name(type.getName()).description(type.getDescription());
                return this.createProperties(objectSchema, type, brAPIObjectType.getProperties().stream().toList()).mapResult(properties -> objectSchema.properties(properties));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("'%sRequest' must be BrAPIObjectType but was '%s'", type.getName(), type.getClass().getSimpleName()));
        }

        private Response<Map<String, ApiResponse>> generateResponses() {
            return Response.success(this.responses);
        }

        private Response<Map<String, Parameter>> generateParameters() {
            return Response.success(this.parameters);
        }

        private Response<Map<String, SecurityScheme>> generateSecuritySchemes() {
            return Response.success(this.securitySchemes);
        }

        private Response<Schema> createSchemaForType(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                return this.createObjectSchema((BrAPIObjectType)type);
            }
            if (type instanceof BrAPIOneOfType) {
                return this.createOneOfType((BrAPIOneOfType)type);
            }
            if (type instanceof BrAPIArrayType) {
                return this.createArraySchema((BrAPIArrayType)type);
            }
            if (type instanceof BrAPIReferenceType) {
                return this.createReferenceSchema((BrAPIReferenceType)type);
            }
            if (type instanceof BrAPIEnumType) {
                return this.createEnumSchema((BrAPIEnumType)type);
            }
            if (type instanceof BrAPIPrimitiveType) {
                return this.createScalarSchema((BrAPIPrimitiveType)type);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown type '%s'", type.getClass()));
        }

        private Response<Schema> createObjectSchema(BrAPIObjectType type) {
            return this.createObjectSchema(type, type.getProperties());
        }

        private Response<Schema> createObjectSchema(BrAPIObjectType type, List<BrAPIObjectProperty> properties) {
            Schema objectSchema = new ObjectSchema().name(type.getName()).description(type.getDescription());
            return this.createProperties(objectSchema, type, properties).mapResult(schema -> objectSchema.properties(schema));
        }

        private Response<Map<String, Schema>> createProperties(Schema objectSchema, BrAPIObjectType parentType, List<BrAPIObjectProperty> properties) {
            TreeMap schemas = new TreeMap();
            return properties.stream().map(property -> this.createProperty(objectSchema, parentType, (BrAPIObjectProperty)property).onSuccessDoWithResult(schemas::putAll)).collect(Response.toList()).map(() -> Response.success(schemas));
        }

        private Response<Map<String, Schema>> createProperty(Schema objectSchema, BrAPIObjectType parentType, BrAPIObjectProperty property) {
            LinkType linkType = this.options.getProperties().getLinkTypeFor(parentType, property);
            if (LinkType.SUB_PATH.equals((Object)linkType) || LinkType.NONE.equals((Object)linkType)) {
                return Response.success(Collections.emptyMap());
            }
            BrAPIType type = this.dereferenceType(property.getType());
            if (type instanceof BrAPIPrimitiveType || type instanceof BrAPIEnumType || type instanceof BrAPIOneOfType) {
                return this.createEmbeddedProperty(objectSchema, property, type);
            }
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                BrAPIRelationshipType relationshipType = property.getRelationshipType() != null ? property.getRelationshipType() : BrAPIRelationshipType.ONE_TO_ONE;
                return switch (relationshipType) {
                    default -> throw new MatchException(null, null);
                    case BrAPIRelationshipType.ONE_TO_ONE, BrAPIRelationshipType.MANY_TO_ONE -> {
                        if (LinkType.ID.equals((Object)linkType)) {
                            yield this.createLinkedProperty(objectSchema, property, brAPIObjectType);
                        }
                        yield this.createEmbeddedProperty(objectSchema, property, brAPIObjectType);
                    }
                    case BrAPIRelationshipType.ONE_TO_MANY, BrAPIRelationshipType.MANY_TO_MANY -> Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' has relationshipType '%s', referenced type '%s' is an object", new Object[]{property.getName(), relationshipType, brAPIObjectType.getName()}));
                };
            }
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                BrAPIRelationshipType relationshipType = property.getRelationshipType() != null ? property.getRelationshipType() : BrAPIRelationshipType.ONE_TO_MANY;
                BrAPIType itemType = this.dereferenceType(brAPIArrayType.getItems());
                return switch (relationshipType) {
                    default -> throw new MatchException(null, null);
                    case BrAPIRelationshipType.ONE_TO_ONE, BrAPIRelationshipType.MANY_TO_ONE -> Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' has relationshipType '%s', referenced type '%s' is an array", new Object[]{property.getName(), relationshipType, brAPIArrayType.getName()}));
                    case BrAPIRelationshipType.ONE_TO_MANY, BrAPIRelationshipType.MANY_TO_MANY -> LinkType.ID.equals((Object)linkType) ? this.createArrayOfIdsProperty(objectSchema, property, itemType) : this.createArrayProperty(objectSchema, property, brAPIArrayType);
                };
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unsupported type '%s' for property '%s'", type.getClass(), property.getName()));
        }

        private Response<Map<String, Schema>> createEmbeddedProperty(Schema objectSchema, BrAPIObjectProperty property, BrAPIType type) {
            return this.createSchemaForProperty(property, type).mapResult(schema -> Collections.singletonMap(property.getName(), schema)).onSuccessDoOnCondition(property.isRequired(), () -> objectSchema.addRequiredItem(property.getName()));
        }

        private Response<Map<String, Schema>> createLinkedProperty(Schema objectSchema, BrAPIObjectProperty property, BrAPIObjectType brAPIObjectType) {
            List<BrAPIObjectProperty> linkProperties = this.options.getProperties().getLinkPropertiesFor(brAPIObjectType);
            if (property.isRequired()) {
                for (BrAPIObjectProperty linkProperty : linkProperties) {
                    if (!linkProperty.isRequired()) continue;
                    objectSchema.addRequiredItem(linkProperty.getName());
                }
            }
            if (linkProperties.isEmpty()) {
                return this.createSchemaForProperty(property, brAPIObjectType).mapResult(schema -> Collections.singletonMap(property.getName(), schema));
            }
            return this.createLinkingProperties(linkProperties);
        }

        private Response<Map<String, Schema>> createArrayOfIdsProperty(Schema objectSchema, BrAPIObjectProperty property, BrAPIType itemType) {
            return this.options.getProperties().getIdPropertyFor(itemType).mapResult(BrAPIObjectProperty::getType).mapResultToResponse(this::createArraySchemaForType).mapResult(arraySchema -> Collections.singletonMap(this.options.getProperties().getIdsPropertyNameFor(property), arraySchema)).onSuccessDoOnCondition(property.isRequired(), () -> objectSchema.addRequiredItem(this.options.getProperties().getIdsPropertyNameFor(property))).or(() -> Response.success(Collections.emptyMap()));
        }

        private Response<Map<String, Schema>> createArrayProperty(Schema objectSchema, BrAPIObjectProperty property, BrAPIArrayType brAPIArrayType) {
            return this.createArraySchema(brAPIArrayType).mapResult(schema -> Collections.singletonMap(property.getName(), schema)).onSuccessDoOnCondition(property.isRequired(), () -> objectSchema.addRequiredItem(this.options.getProperties().getIdsPropertyNameFor(property))).or(() -> Response.success(Collections.emptyMap()));
        }

        private BrAPIType dereferenceType(BrAPIType type) {
            if (type instanceof BrAPIReferenceType) {
                return this.brAPIClassMap.get(type.getName());
            }
            return type;
        }

        private Response<Map<String, Schema>> createLinkingProperties(List<BrAPIObjectProperty> linkProperties) {
            HashMap schemas = new HashMap();
            return linkProperties.stream().map(linkProperty -> this.createSchemaForType(linkProperty.getType()).onSuccessDoWithResult(schema -> schemas.put(linkProperty.getName(), schema))).collect(Response.toList()).merge(() -> Response.success(schemas));
        }

        private Response<Schema> createSchemaForProperty(BrAPIObjectProperty property, BrAPIType type) {
            if (property.getType() instanceof BrAPIReferenceType) {
                return this.createSchemaForType(property.getType());
            }
            return this.createSchemaForType(type);
        }

        private Response<Schema> createOneOfType(BrAPIOneOfType type) {
            return type.getPossibleTypes().stream().map(this::createSchemaForType).collect(Response.toList()).mapResult(schema -> new Schema().oneOf(schema).name(type.getName()).description(type.getDescription()));
        }

        private Response<Schema> createArraySchema(BrAPIArrayType type) {
            return this.createSchemaForType(type.getItems()).mapResult(schema -> new ArraySchema().items(schema));
        }

        private Response<Schema> createArraySchemaForType(BrAPIType type) {
            return this.createSchemaForType(type).mapResult(schema -> new ArraySchema().items(schema));
        }

        private Response<Schema> createReferenceSchema(BrAPIReferenceType type) {
            return Response.success(new Schema().$ref(this.createSchemaRef(type.getName())));
        }

        private String createSchemaRef(String name) {
            this.referencedSchemas.add(name);
            return String.format("#/components/schemas/%s", name);
        }

        private Response<Schema> createEnumSchema(BrAPIEnumType type) {
            return switch (type.getType()) {
                case "string" -> this.createStringEnumSchema(type);
                case "integer" -> this.createIntegerEnumSchema(type);
                case "number" -> this.createNumberEnumSchema(type);
                case "boolean" -> this.createBooleanEnumSchema(type);
                default -> Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown primitive type '%s' for enum '%s'", type.getType(), type.getName()));
            };
        }

        private Response<Schema> createStringEnumSchema(BrAPIEnumType type) {
            StringSchema schema = new StringSchema();
            this.updateSchema(type, (Schema)schema);
            try {
                schema.setEnum(type.getValues().stream().map(value -> (String)value.getValue()).toList());
                return Response.success(schema);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not cast value to String : %s", e.getMessage()));
            }
        }

        private Response<Schema> createIntegerEnumSchema(BrAPIEnumType type) {
            IntegerSchema schema = new IntegerSchema();
            this.updateSchema(type, (Schema)schema);
            try {
                schema.setEnum(type.getValues().stream().map(value -> (Number)value.getValue()).toList());
                return Response.success(schema);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not cast value to Number : %s", e.getMessage()));
            }
        }

        private Response<Schema> createNumberEnumSchema(BrAPIEnumType type) {
            NumberSchema schema = new NumberSchema();
            this.updateSchema(type, (Schema)schema);
            try {
                schema.setEnum(type.getValues().stream().map(value -> (BigDecimal)value.getValue()).toList());
                return Response.success(schema);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not cast value to BigDecimal : %s", e.getMessage()));
            }
        }

        private Response<Schema> createBooleanEnumSchema(BrAPIEnumType type) {
            BooleanSchema schema = new BooleanSchema();
            this.updateSchema(type, (Schema)schema);
            try {
                schema.setEnum(type.getValues().stream().map(value -> (Boolean)value.getValue()).toList());
                return Response.success(schema);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not cast value to BigDecimal : %s", e.getMessage()));
            }
        }

        private Response<Schema> createScalarSchema(BrAPIPrimitiveType type) {
            return switch (type.getName()) {
                case "string" -> Response.success(new StringSchema());
                case "integer" -> Response.success(new IntegerSchema());
                case "number" -> Response.success(new NumberSchema());
                case "boolean" -> Response.success(new BooleanSchema());
                default -> Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown primitive type '%s'", type.getName()));
            };
        }

        private Schema updateSchema(BrAPIEnumType type, Schema schema) {
            schema.name(type.getName());
            schema.description(type.getDescription());
            return schema;
        }
    }
}

