/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ConfigurationUtils {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static <T> T load(Path configurationsFile, Class<T> configurationClass) throws IOException {
        return ConfigurationUtils.load(Files.newInputStream(configurationsFile, new OpenOption[0]), configurationClass);
    }

    public static <T> T load(String classPath, Class<T> configurationClass) throws IOException {
        InputStream inputStream = configurationClass.getClassLoader().getResourceAsStream(classPath);
        return ConfigurationUtils.load(inputStream, configurationClass);
    }

    public static <T> T load(InputStream inputStream, Class<T> configurationClass) throws IOException {
        return (T)mapper.readValue(inputStream, configurationClass);
    }
}

