/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.xlsx.options;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.validiation.Validation;
import org.brapi.schematools.core.xlsx.options.ColumnOption;

public class XSSFWorkbookGeneratorOptions
implements Options {
    List<ColumnOption> dataClassProperties;
    List<String> dataClassFieldHeaders;
    List<ColumnOption> dataClassFieldProperties;

    public static XSSFWorkbookGeneratorOptions load() {
        try {
            return ConfigurationUtils.load("xlsx-options.yaml", XSSFWorkbookGeneratorOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static XSSFWorkbookGeneratorOptions load(Path optionsFile) throws IOException {
        return XSSFWorkbookGeneratorOptions.load().override(ConfigurationUtils.load(optionsFile, XSSFWorkbookGeneratorOptions.class));
    }

    public static XSSFWorkbookGeneratorOptions load(InputStream inputStream) throws IOException {
        return XSSFWorkbookGeneratorOptions.load().override(ConfigurationUtils.load(inputStream, XSSFWorkbookGeneratorOptions.class));
    }

    @Override
    public Validation validate() {
        return Validation.valid().merge(this.dataClassProperties).assertNotNull(this.dataClassFieldHeaders, "'dataClassFieldHeaders' option on %s is null", this.getClass().getSimpleName()).merge(this.dataClassFieldProperties);
    }

    public XSSFWorkbookGeneratorOptions override(XSSFWorkbookGeneratorOptions overrideOptions) {
        if (overrideOptions.dataClassProperties != null) {
            this.setDataClassProperties(overrideOptions.dataClassProperties);
        }
        if (overrideOptions.dataClassFieldHeaders != null) {
            this.dataClassFieldHeaders = overrideOptions.dataClassFieldHeaders;
        }
        if (overrideOptions.dataClassFieldProperties != null) {
            this.setDataClassFieldProperties(overrideOptions.getDataClassFieldProperties());
        }
        return this;
    }

    public List<ColumnOption> getDataClassProperties() {
        return this.dataClassProperties;
    }

    public List<String> getDataClassFieldHeaders() {
        return this.dataClassFieldHeaders;
    }

    public List<ColumnOption> getDataClassFieldProperties() {
        return this.dataClassFieldProperties;
    }

    private XSSFWorkbookGeneratorOptions setDataClassProperties(List<ColumnOption> dataClassProperties) {
        this.dataClassProperties = dataClassProperties;
        return this;
    }

    private XSSFWorkbookGeneratorOptions setDataClassFieldHeaders(List<String> dataClassFieldHeaders) {
        this.dataClassFieldHeaders = dataClassFieldHeaders;
        return this;
    }

    private XSSFWorkbookGeneratorOptions setDataClassFieldProperties(List<ColumnOption> dataClassFieldProperties) {
        this.dataClassFieldProperties = dataClassFieldProperties;
        return this;
    }

    private XSSFWorkbookGeneratorOptions() {
    }
}

