/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.authorization.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import lombok.NonNull;
import org.brapi.schematools.core.authorization.AuthorizationProvider;
import org.brapi.schematools.core.authorization.oauth.OpenIDToken;
import org.brapi.schematools.core.authorization.oauth.TokenRequest;
import org.brapi.schematools.core.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSignOn
implements AuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(SingleSignOn.class);
    @NonNull
    private final String name;
    @NonNull
    private final String url;
    private final String clientId;
    private final String username;
    private final URI requestUri;
    private final ObjectMapper objectMapper = new ObjectMapper();

    private SingleSignOn(String name, @NonNull String url, String clientId, String username) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.name = name != null ? name : URI.create(url).getHost();
        this.url = url;
        this.clientId = clientId;
        this.username = username != null ? username : System.getProperty("user.name");
        this.requestUri = URI.create(url);
    }

    @Override
    public boolean required() {
        return true;
    }

    @Override
    public Response<String> getAuthorization() {
        return this.getToken().mapResult(openIDToken -> "Bearer " + openIDToken.getAccessToken());
    }

    public Response<OpenIDToken> loginWithPassword(String password) {
        log.debug("Attempting to login with password.");
        if (this.username == null) {
            return Response.fail(Response.ErrorType.PERMISSION, "Username not provided!");
        }
        if (password == null) {
            return Response.fail(Response.ErrorType.PERMISSION, "Password not provided!");
        }
        return this.requestToken(TokenRequest.builder().grantType("password").username(this.username).password(password).clientId(this.clientId).build()).onSuccessDo(() -> log.debug("Logged in!")).onFailDo(() -> log.debug("Log failed!"));
    }

    public Response<OpenIDToken> loginWithClientId(String clientSecret) {
        log.debug("Attempting to login with client secret");
        if (this.clientId == null) {
            return Response.fail(Response.ErrorType.PERMISSION, "Client ID not provided!");
        }
        if (clientSecret == null) {
            return Response.fail(Response.ErrorType.PERMISSION, "Client secret not provided!");
        }
        return this.requestToken(TokenRequest.builder().grantType("client_credentials").clientId(this.clientId).clientSecret(clientSecret).build()).onSuccessDo(() -> log.debug("Logged in!")).onFailDo(() -> log.debug("Log failed!"));
    }

    public Response<Void> logout() {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            return Response.fail(Response.ErrorType.VALIDATION, "You were not logged in, so can not logout!");
        }
        if (tokenFile.delete()) {
            log.debug("Logged out!");
            return Response.success(null);
        }
        return Response.fail(Response.ErrorType.VALIDATION, String.format("Was not able to logout, try to delete the sso token at %s manually!", tokenFile.getAbsolutePath()));
    }

    public Response<OpenIDToken> getToken() {
        try {
            File tokenFile = this.getTokenFile();
            long lastModified = tokenFile.lastModified();
            OpenIDToken token = (OpenIDToken)this.objectMapper.readValue(this.getTokenFile(), OpenIDToken.class);
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis > lastModified + (long)token.getExpiresIn() * 1000L) {
                if (currentTimeMillis > lastModified + (long)token.getRefreshExpiresIn() * 1000L) {
                    log.debug("Refresh token expired");
                    return Response.fail(Response.ErrorType.VALIDATION, "Token expired, please login first");
                }
                log.debug("Token expired will try to refresh");
                return this.requestToken(TokenRequest.builder().grantType("refresh_token").refreshToken(token.getRefresh_token()).build());
            }
            return Response.success(token);
        }
        catch (IOException e) {
            return Response.fail(Response.ErrorType.VALIDATION, "Not logged in, please login first");
        }
    }

    private File getTokenFile() {
        Path parentPath = Path.of(System.getProperty("user.home"), ".sso", this.name, this.clientId != null ? this.clientId : this.username);
        if (parentPath.toFile().mkdirs()) {
            log.debug("Created directory at {}", (Object)parentPath);
        } else {
            log.debug("Used existing directory at {}", (Object)parentPath);
        }
        return parentPath.resolve(String.format("%s.token", this.username)).toFile();
    }

    private Response<OpenIDToken> requestToken(TokenRequest tokenRequest) {
        try {
            HttpRequest request = HttpRequest.newBuilder(this.requestUri).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(tokenRequest.params())).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                OpenIDToken token = (OpenIDToken)this.objectMapper.readValue(response.body(), OpenIDToken.class);
                this.objectMapper.writeValue(this.getTokenFile(), (Object)token);
                return Response.success(token);
            }
            JsonNode tree = this.objectMapper.readTree(response.body());
            if (tree.has("error")) {
                if (tree.has("error_description")) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not login due to %s %s!", tree.get("error").asText(), tree.get("error_description").asText()));
                }
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not login due to %s!", tree.get("error").asText()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, "Can not login!");
        }
        catch (IOException | InterruptedException e) {
            return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
        }
    }

    public static SingleSignOnBuilder builder() {
        return new SingleSignOnBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    private URI getRequestUri() {
        return this.requestUri;
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static class SingleSignOnBuilder {
        private String name;
        private String url;
        private String clientId;
        private String username;

        SingleSignOnBuilder() {
        }

        public SingleSignOnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SingleSignOnBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public SingleSignOnBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SingleSignOnBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SingleSignOn build() {
            return new SingleSignOn(this.name, this.url, this.clientId, this.username);
        }

        public String toString() {
            return "SingleSignOn.SingleSignOnBuilder(name=" + this.name + ", url=" + this.url + ", clientId=" + this.clientId + ", username=" + this.username + ")";
        }
    }
}

