/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql;

import graphql.AssertException;
import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.graphql.metadata.GraphQLGeneratorMetadata;
import org.brapi.schematools.core.graphql.options.GraphQLGeneratorOptions;
import org.brapi.schematools.core.graphql.options.LinkType;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLGenerator {
    private static final Logger log = LoggerFactory.getLogger(GraphQLGenerator.class);
    private final BrAPISchemaReader schemaReader;
    private final GraphQLGeneratorOptions options;

    public GraphQLGenerator() {
        this(new BrAPISchemaReader(), GraphQLGeneratorOptions.load());
    }

    public GraphQLGenerator(GraphQLGeneratorOptions options) {
        this(new BrAPISchemaReader(), options);
    }

    public Response<GraphQLSchema> generate(Path schemaDirectory) {
        return this.generate(schemaDirectory, new GraphQLGeneratorMetadata());
    }

    public Response<GraphQLSchema> generate(Path schemaDirectory, GraphQLGeneratorMetadata metadata) {
        return this.options.validate().asResponse().merge(this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator(this.options, metadata, (List<BrAPIClass>)brAPISchemas).generate()));
    }

    public GraphQLGenerator(BrAPISchemaReader schemaReader, GraphQLGeneratorOptions options) {
        this.schemaReader = schemaReader;
        this.options = options;
    }

    private static class Generator {
        private final GraphQLGeneratorOptions options;
        private final GraphQLGeneratorMetadata metadata;
        private final Map<String, BrAPIClass> brAPISchemas;
        private final Map<String, GraphQLObjectType> objectOutputTypes;
        private final Map<String, GraphQLInterfaceType> interfaceTypes;
        private final Map<String, GraphQLUnionType> unionTypes;
        private final Map<String, GraphQLEnumType> enumTypes;
        private final Map<String, GraphQLNamedInputType> inputTypes;
        private final Map<String, String> listResponseTypesToBeCreated;
        private final Map<String, String> inputObjectTypeForListQueryToBeCreated;
        private final GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();

        public Generator(GraphQLGeneratorOptions options, GraphQLGeneratorMetadata metadata, List<BrAPIClass> brAPISchemas) {
            this.options = options;
            this.metadata = metadata;
            this.brAPISchemas = brAPISchemas.stream().collect(Collectors.toMap(BrAPIType::getName, Function.identity()));
            this.objectOutputTypes = new HashMap<String, GraphQLObjectType>();
            this.interfaceTypes = new HashMap<String, GraphQLInterfaceType>();
            this.unionTypes = new HashMap<String, GraphQLUnionType>();
            this.enumTypes = new HashMap<String, GraphQLEnumType>();
            this.inputTypes = new HashMap<String, GraphQLNamedInputType>();
            this.listResponseTypesToBeCreated = new HashMap<String, String>();
            this.inputObjectTypeForListQueryToBeCreated = new HashMap<String, String>();
        }

        public Response<GraphQLSchema> generate() {
            return this.brAPISchemas.values().stream().filter(this::isNonPrimaryModel).map(this::createOutputType).collect(Response.toList()).mapOnCondition(this.options.isGeneratingCreateMutation() || this.options.isGeneratingUpdateMutation(), () -> this.brAPISchemas.values().stream().filter(this::isGeneratingInputTypeForMutation).map(this::createInputObjectTypeForModel).collect(Response.toList())).mapOnCondition(this.options.isGeneratingListQueries(), () -> this.brAPISchemas.values().stream().filter(this::isGeneratingInputTypeForListQuery).map(this::createInputObjectTypeForListQuery).collect(Response.toList())).mapOnCondition(this.options.isGeneratingSearchQueries(), () -> this.brAPISchemas.values().stream().filter(this::isGeneratingInputTypeForSearchQuery).map(this::createInputObjectTypeForSearchQuery).collect(Response.toList())).map(() -> this.brAPISchemas.values().stream().filter(this::isInterface).map(this::createInterfaceType).collect(Response.toList())).map(() -> this.brAPISchemas.values().stream().filter(this::isPrimaryModel).map(this::createObjectType).collect(Response.toList())).mapResultToResponse(this::createSchema);
        }

        private boolean isGeneratingInputTypeForListQuery(BrAPIClass brAPIClass) {
            return this.isPrimaryModel(brAPIClass) && this.options.isGeneratingListQueryFor(brAPIClass.getName()) && !this.inputTypes.containsKey(this.options.getQueryInputTypeNameFor(brAPIClass)) && this.options.getQueryType().getListQuery().hasInputFor(brAPIClass);
        }

        private boolean isGeneratingInputTypeForSearchQuery(BrAPIClass brAPIClass) {
            return this.isPrimaryModel(brAPIClass) && this.options.isGeneratingSearchQueryFor(brAPIClass.getName()) && !this.inputTypes.containsKey(this.options.getQueryInputTypeNameFor(brAPIClass)) && this.options.getQueryType().getSearchQuery().hasInputFor(brAPIClass);
        }

        private boolean isGeneratingInputTypeForMutation(BrAPIClass brAPIClass) {
            return this.isPrimaryModel(brAPIClass) && (this.options.isGeneratingCreateMutationFor(brAPIClass.getName()) || this.options.isGeneratingDeleteMutationFor(brAPIClass.getName()));
        }

        private boolean isPrimaryModel(BrAPIClass type) {
            return type.getMetadata() != null && type.getMetadata().isPrimaryModel();
        }

        private boolean isNonPrimaryModel(BrAPIClass type) {
            return type.getMetadata() == null || !type.getMetadata().isPrimaryModel() && !type.getMetadata().isRequest() && !type.getMetadata().isParameters() && !type.getMetadata().isInterfaceClass();
        }

        private boolean isModel(BrAPIClass type) {
            return type.getMetadata() == null || !type.getMetadata().isRequest() && !type.getMetadata().isParameters();
        }

        private boolean isRequest(BrAPIClass type) {
            return type.getMetadata() != null && type.getMetadata().isRequest();
        }

        private boolean isInterface(BrAPIClass type) {
            return type.getMetadata() != null && type.getMetadata().isInterfaceClass();
        }

        private Response<GraphQLSchema> createSchema(List<GraphQLObjectType> primaryTypes) {
            GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
            this.objectOutputTypes.values().forEach(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
            this.interfaceTypes.values().forEach(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
            this.enumTypes.values().forEach(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
            this.inputTypes.values().forEach(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
            this.unionTypes.values().forEach(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
            new HashMap<String, String>(this.listResponseTypesToBeCreated).forEach((key, value) -> {
                GraphQLObjectType type = this.objectOutputTypes.get(value);
                if (type != null) {
                    boolean paged = this.options.getQueryType().getListQuery().isPagedFor(type.getName());
                    builder.additionalType((GraphQLType)this.createListResponse(paged, type));
                } else {
                    log.warn(String.format("Can not create '%s' no type '%s'", key, value));
                }
            });
            new HashMap<String, String>(this.inputObjectTypeForListQueryToBeCreated).forEach((key, value) -> {
                BrAPIClass type = this.brAPISchemas.get(value);
                if (type != null) {
                    this.createInputObjectTypeForListQuery(type).onSuccessDoWithResult(arg_0 -> ((GraphQLSchema.Builder)builder).additionalType(arg_0));
                } else {
                    log.warn(String.format("Can not create '%s' no type '%s'", key, value));
                }
            });
            if (this.options.isGeneratingListQueries() && this.options.getQueryType().getListQuery().hasPaging()) {
                builder.additionalType(this.createPageInputType());
                builder.additionalType(this.createPageType());
            }
            this.interfaceTypes.values().forEach(graphQLType -> this.codeRegistry.typeResolver(graphQLType, (TypeResolver)new InterfaceTypeResolver((GraphQLInterfaceType)graphQLType)));
            this.unionTypes.values().forEach(graphQLType -> this.codeRegistry.typeResolver(graphQLType, (TypeResolver)new UnionTypeResolver((GraphQLUnionType)graphQLType)));
            builder.codeRegistry(this.codeRegistry.build());
            try {
                return Response.empty().mapOnCondition(this.options.isGeneratingQueryType(), () -> this.generateQueryType(primaryTypes).onSuccessDoWithResult(arg_0 -> ((GraphQLSchema.Builder)builder).query(arg_0))).mapOnCondition(this.options.isGeneratingMutationType(), () -> this.generateMutationType(primaryTypes).onSuccessDoWithResult(arg_0 -> ((GraphQLSchema.Builder)builder).mutation(arg_0))).withResult(builder.build());
            }
            catch (AssertException e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private Response<GraphQLObjectType> generateQueryType(List<GraphQLObjectType> primaryTypes) {
            GraphQLObjectType.Builder query = GraphQLObjectType.newObject().name(this.options.getQueryType().getName());
            if (this.options.isGeneratingSingleQueries()) {
                primaryTypes.stream().filter(type -> this.options.getQueryType().getSingleQuery().isGeneratingFor(type.getName())).map(this::generateSingleGraphQLQuery).forEach(arg_0 -> ((GraphQLObjectType.Builder)query).field(arg_0));
            }
            if (this.options.isGeneratingListQueries()) {
                primaryTypes.stream().filter(type -> this.options.getQueryType().getListQuery().isGeneratingFor(type.getName())).map(this::generateListGraphQLQuery).forEach(arg_0 -> ((GraphQLObjectType.Builder)query).field(arg_0));
            }
            if (this.options.isGeneratingSearchQueries()) {
                primaryTypes.stream().filter(type -> this.options.getQueryType().getSearchQuery().isGeneratingFor(type.getName())).map(this::generateSearchGraphQLQuery).forEach(arg_0 -> ((GraphQLObjectType.Builder)query).field(arg_0));
            }
            return Response.success(query.build());
        }

        private Response<GraphQLObjectType> generateMutationType(List<GraphQLObjectType> primaryTypes) {
            GraphQLObjectType.Builder mutation = GraphQLObjectType.newObject().name(this.options.getMutationType().getName());
            primaryTypes.stream().filter(type -> this.options.isGeneratingCreateMutationFor(type.getName())).map(this::generateCreateGraphQLMutation).forEach(arg_0 -> ((GraphQLObjectType.Builder)mutation).field(arg_0));
            primaryTypes.stream().filter(type -> this.options.isGeneratingUpdateMutationFor(type.getName())).map(this::generateUpdateGraphQLMutation).forEach(arg_0 -> ((GraphQLObjectType.Builder)mutation).field(arg_0));
            return primaryTypes.stream().filter(type -> this.options.isGeneratingDeleteMutationFor(type.getName())).map(this::generateDeleteGraphQLMutation).collect(Response.toList()).withResult(mutation.build());
        }

        private Response<GraphQLOutputType> createOutputType(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                return this.createObjectType(brAPIObjectType).mapResult(t -> t);
            }
            if (type instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)type;
                return this.createOutputType(brAPIOneOfType).mapResult(t -> t);
            }
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                return this.createOutputListType(brAPIArrayType).mapResult(t -> t);
            }
            if (type instanceof BrAPIReferenceType) {
                BrAPIReferenceType brAPIReferenceType = (BrAPIReferenceType)type;
                return this.createOutputReferenceType(brAPIReferenceType).mapResult(t -> t);
            }
            if (type instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)type;
                return this.createEnumType(brAPIEnumType).mapResult(t -> t);
            }
            if (type instanceof BrAPIPrimitiveType) {
                BrAPIPrimitiveType brAPIPrimitiveType = (BrAPIPrimitiveType)type;
                return this.createScalarType(brAPIPrimitiveType).mapResult(t -> t);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown output type '%s'", type.getName()));
        }

        private Response<GraphQLTypeReference> createOutputReferenceType(BrAPIReferenceType type) {
            return Response.success(GraphQLTypeReference.typeRef((String)type.getName()));
        }

        private Response<GraphQLList> createOutputListType(BrAPIArrayType type) {
            return this.createOutputType(type.getItems()).mapResult(GraphQLList::list);
        }

        private Response<GraphQLObjectType> createObjectType(BrAPIClass brAPIClass) {
            if (brAPIClass instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                GraphQLObjectType existingType = this.objectOutputTypes.get(brAPIObjectType.getName());
                if (existingType != null) {
                    return Response.success(existingType);
                }
                GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(brAPIObjectType.getName()).description(brAPIObjectType.getDescription());
                brAPIObjectType.getInterfaces().forEach(interfaceType -> builder.withInterface(GraphQLTypeReference.typeRef((String)interfaceType.getName())));
                return brAPIObjectType.getInterfaces().stream().map(interfaceType -> this.createInterfaceType((BrAPIClass)interfaceType).onSuccessDoWithResult(arg_0 -> ((GraphQLObjectType.Builder)builder).withInterface(arg_0))).collect(Response.toList()).map(() -> this.extractProperties(brAPIObjectType).filter(property -> !LinkType.NONE.equals((Object)this.options.getProperties().getLinkTypeFor(brAPIObjectType, (BrAPIObjectProperty)property))).map(property -> this.createFieldDefinition(brAPIObjectType, (BrAPIObjectProperty)property)).collect(Response.toList())).onSuccessDoWithResult(arg_0 -> ((GraphQLObjectType.Builder)builder).fields(arg_0)).map(() -> this.addObjectType(builder.build()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create GraphQLObjectType, type is not BrAPIObjectType, but was '%s'", brAPIClass.getClass()));
        }

        private Response<GraphQLInterfaceType> createInterfaceType(BrAPIClass brAPIClass) {
            if (brAPIClass instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                GraphQLInterfaceType existingType = this.interfaceTypes.get(brAPIObjectType.getName());
                if (existingType != null) {
                    return Response.success(existingType);
                }
                GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface().name(brAPIObjectType.getName()).description(brAPIObjectType.getDescription());
                brAPIObjectType.getInterfaces().forEach(interfaceType -> builder.withInterface(GraphQLTypeReference.typeRef((String)interfaceType.getName())));
                return brAPIObjectType.getInterfaces().stream().map(interfaceType -> this.createInterfaceType((BrAPIClass)interfaceType).onSuccessDoWithResult(arg_0 -> ((GraphQLInterfaceType.Builder)builder).withInterface(arg_0))).collect(Response.toList()).map(() -> brAPIObjectType.getProperties().stream().filter(property -> !LinkType.NONE.equals((Object)this.options.getProperties().getLinkTypeFor(brAPIObjectType, (BrAPIObjectProperty)property))).map(property -> this.createFieldDefinition(brAPIObjectType, (BrAPIObjectProperty)property)).collect(Response.toList())).onSuccessDoWithResult(arg_0 -> ((GraphQLInterfaceType.Builder)builder).fields(arg_0)).map(() -> this.addInterfaceType(builder.build()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not create GraphQLInterfaceType, type is not BrAPIObjectType, but was '%s'", brAPIClass.getClass()));
        }

        private Response<GraphQLFieldDefinition> createFieldDefinition(BrAPIObjectType parentType, BrAPIObjectProperty property) {
            LinkType linkType = this.options.getProperties().getLinkTypeFor(parentType, property);
            return switch (linkType) {
                default -> throw new MatchException(null, null);
                case LinkType.EMBEDDED -> {
                    GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(property.getName()).description(property.getDescription());
                    yield this.createOutputType(property.getType()).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).type(arg_0)).map(() -> Response.success(builder.build()));
                }
                case LinkType.SUB_QUERY -> {
                    GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(property.getName()).description(property.getDescription());
                    if (property.getType() instanceof BrAPIArrayType) {
                        BrAPIType type = this.unwrapType(property.getType());
                        boolean paged = this.options.getQueryType().getListQuery().isPagedFor(type.getName());
                        boolean hasInput = this.options.getQueryType().getListQuery().hasInputFor(type.getName());
                        String responseTypeName = this.options.getQueryType().getListQuery().getResponseTypeNameForType(type.getName());
                        String inputTypeName = this.options.getQueryInputTypeNameFor(type.getName());
                        this.listResponseTypesToBeCreated.put(responseTypeName, type.getName());
                        this.inputObjectTypeForListQueryToBeCreated.put(inputTypeName, type.getName());
                        yield Response.success(GraphQLTypeReference.typeRef((String)responseTypeName)).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).type(arg_0)).map(() -> Response.success(this.createListQueryArguments(paged, hasInput, type.getName()))).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).arguments(arg_0)).map(() -> Response.success(builder.build()));
                    }
                    yield this.createOutputType(property.getType()).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).type(arg_0)).map(() -> Response.success(builder.build()));
                }
                case LinkType.ID -> {
                    GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().description(property.getDescription());
                    if (property.getType() instanceof BrAPIArrayType) {
                        builder.name(this.options.getProperties().getIds().getIdFieldFor(property)).type((GraphQLOutputType)GraphQLList.list((GraphQLType)(this.options.isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString)));
                    } else {
                        builder.name(this.options.getProperties().getIds().getIdsFieldFor(property)).type((GraphQLOutputType)(this.options.isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString));
                    }
                    yield Response.success(builder.build());
                }
                case LinkType.NONE -> Response.fail(Response.ErrorType.VALIDATION, "Should have been filtered out!");
            };
        }

        private Response<GraphQLTypeReference> createInputReferenceType(BrAPIReferenceType type) {
            BrAPIClass referencedSchema = this.brAPISchemas.get(type.getName());
            if (referencedSchema != null && !(referencedSchema instanceof BrAPIEnumType)) {
                String inputTypeName = this.options.getInput().getTypeNameFor(referencedSchema);
                if (this.isModel(referencedSchema)) {
                    return this.createInputObjectTypeForModel(referencedSchema).withResult(GraphQLTypeReference.typeRef((String)inputTypeName));
                }
                if (this.isRequest(referencedSchema)) {
                    return this.createInputTypeFromClass(inputTypeName, referencedSchema).withResult(GraphQLTypeReference.typeRef((String)inputTypeName));
                }
                return Response.success(GraphQLTypeReference.typeRef((String)inputTypeName));
            }
            return Response.success(GraphQLTypeReference.typeRef((String)type.getName()));
        }

        private Response<GraphQLList> createInputListType(BrAPIArrayType type) {
            return this.createInputType(type.getItems()).mapResult(GraphQLList::list);
        }

        private Response<GraphQLNamedInputType> createInputObjectTypeForModel(BrAPIClass type) {
            return this.createInputObjectType(this.options.getInput().getTypeNameFor(type), type);
        }

        private Response<GraphQLNamedInputType> createInputObjectTypeForListQuery(BrAPIClass type) {
            BrAPIClass requestSchema = this.brAPISchemas.get(String.format("%sRequest", type.getName()));
            return this.createInputTypeFromClass(this.options.getQueryInputTypeNameFor(type), Objects.requireNonNullElse(requestSchema, type));
        }

        private Response<GraphQLNamedInputType> createInputObjectTypeForSearchQuery(BrAPIClass type) {
            BrAPIClass requestSchema = this.brAPISchemas.get(String.format("%sRequest", type.getName()));
            return this.createInputTypeFromClass(this.options.getQueryInputTypeNameFor(type), Objects.requireNonNullElse(requestSchema, type));
        }

        private Response<GraphQLNamedInputType> createInputTypeFromClass(String name, BrAPIClass type) {
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                if (type.getName().endsWith("Request")) {
                    return this.createInputObjectType(this.options.getInput().getTypeNameForQuery(this.options.getQueryType().getListQuery().getNameFor(this.options.getPluralFor(type.getName().substring(0, type.getName().length() - 7)))), type).onSuccessDoWithResult(inputType -> this.inputObjectTypeForListQueryToBeCreated.remove(inputType.getName()));
                }
                return this.createInputObjectType(name, brAPIObjectType).onSuccessDoWithResult(inputType -> this.inputObjectTypeForListQueryToBeCreated.remove(inputType.getName())).mapResult(t -> t);
            }
            if (type instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)type;
                return this.createEnumType(brAPIEnumType).mapResult(t -> t);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Input object '%s' must be BrAPIObjectType or BrAPIEnumType but was '%s'", type.getName(), type.getClass().getSimpleName()));
        }

        private Response<GraphQLNamedInputType> createInputObjectType(String name, BrAPIClass type) {
            GraphQLNamedInputType existingType = this.inputTypes.get(name);
            if (existingType != null) {
                return Response.success(existingType);
            }
            this.addInputObjectType((GraphQLNamedInputType)GraphQLTypeReference.typeRef((String)name));
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(name).description(brAPIObjectType.getDescription());
                boolean hasExternalReferences = brAPIObjectType.getProperties().stream().anyMatch(property -> property.getName().equals("externalReferences"));
                return brAPIObjectType.getProperties().stream().map(this::createInputObjectField).collect(Response.toList()).onSuccessDoWithResult(arg_0 -> ((GraphQLInputObjectType.Builder)builder).fields(arg_0)).mapOnCondition(hasExternalReferences, () -> this.createExternalReferencesInputObjectField().onSuccessDoWithResult(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0))).map(() -> this.addInputObjectType((GraphQLNamedInputType)builder.build()));
            }
            if (type instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)type;
                GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(name).description(brAPIOneOfType.getDescription());
                if (this.options.isMergingOneOfType(type)) {
                    return brAPIOneOfType.getPossibleTypes().stream().flatMap(this::extractProperties).map(this::createInputObjectField).collect(Response.toList()).mapResultToResponse(this::removeDuplicates).onSuccessDoWithResult(arg_0 -> ((GraphQLInputObjectType.Builder)builder).fields(arg_0)).map(() -> this.addInputObjectType((GraphQLNamedInputType)builder.build()));
                }
                return brAPIOneOfType.getPossibleTypes().stream().map(this::createInputType).collect(Response.toList()).mapResultToResponse(this::createInputObjectFieldForTypes).onSuccessDoWithResult(arg_0 -> ((GraphQLInputObjectType.Builder)builder).fields(arg_0)).map(() -> this.addInputObjectType((GraphQLNamedInputType)builder.build()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Input object '%s' must be BrAPIObjectType or BrAPIOneOfType but was '%s'", type.getName(), type.getClass().getSimpleName()));
        }

        private Response<List<GraphQLInputObjectField>> createInputObjectFieldForTypes(List<GraphQLInputType> graphQLInputTypes) {
            return graphQLInputTypes.stream().map(this::createInputObjectFieldForType).collect(Response.toList());
        }

        private Response<GraphQLInputObjectField> createInputObjectFieldForType(GraphQLInputType graphQLInputType) {
            if (graphQLInputType instanceof GraphQLNamedInputType) {
                GraphQLNamedInputType graphQLNamedInputType = (GraphQLNamedInputType)graphQLInputType;
                return Response.success(GraphQLInputObjectField.newInputObjectField().name(StringUtils.toParameterCase(graphQLNamedInputType.getName())).description(String.format("Field for possible type '%s'", graphQLNamedInputType.getName())).type(graphQLInputType).build());
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Input type must be GraphQLNamedInputType but was '%s'", graphQLInputType.getClass().getSimpleName()));
        }

        private Response<List<GraphQLInputObjectField>> removeDuplicates(List<GraphQLInputObjectField> graphQLInputObjectFields) {
            try {
                return Response.success(new ArrayList(graphQLInputObjectFields.stream().collect(Collectors.toMap(GraphQLInputObjectField::getName, Function.identity(), this::merge)).values()));
            }
            catch (RuntimeException e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private GraphQLInputObjectField merge(GraphQLInputObjectField fieldA, GraphQLInputObjectField fieldB) {
            if (!this.typeEquals((GraphQLType)fieldA.getType(), (GraphQLType)fieldB.getType())) {
                throw new RuntimeException(String.format("Can not merge fields called '%s', field A has type '%s' and field B has type '%s", fieldA.getName(), fieldA.getType(), fieldB.getType()));
            }
            return fieldA;
        }

        private boolean typeEquals(GraphQLType typeA, GraphQLType typeB) {
            if (typeA.equals((Object)typeB)) {
                return true;
            }
            if (typeA instanceof GraphQLNamedType) {
                GraphQLNamedType graphQLNamedTypeA = (GraphQLNamedType)typeA;
                if (typeB instanceof GraphQLNamedType) {
                    GraphQLNamedType graphQLNamedTypeB = (GraphQLNamedType)typeB;
                    return graphQLNamedTypeA.equals((Object)graphQLNamedTypeB);
                }
            }
            if (typeA instanceof GraphQLList) {
                GraphQLList graphQLListA = (GraphQLList)typeA;
                if (typeB instanceof GraphQLList) {
                    GraphQLList graphQLListB = (GraphQLList)typeB;
                    return this.typeEquals(graphQLListA.getWrappedType(), graphQLListB.getWrappedType());
                }
            }
            return false;
        }

        private Stream<BrAPIObjectProperty> extractProperties(BrAPIType brAPIType) {
            BrAPIReferenceType brAPIReferenceType;
            BrAPIClass referencedSchema;
            BrAPIType type = brAPIType instanceof BrAPIReferenceType ? ((referencedSchema = this.brAPISchemas.get((brAPIReferenceType = (BrAPIReferenceType)brAPIType).getName())) != null ? referencedSchema : brAPIType) : brAPIType;
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                return brAPIObjectType.getProperties().stream();
            }
            return Stream.empty();
        }

        private Response<GraphQLInputType> createInputType(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                return this.createInputObjectTypeForModel(brAPIObjectType).mapResult(t -> t).mapResult(t -> t);
            }
            if (type instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)type;
                return this.createInputObjectType(this.options.getInput().getTypeNameFor(brAPIOneOfType), brAPIOneOfType).mapResult(t -> t);
            }
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                return this.createInputListType(brAPIArrayType).mapResult(t -> t);
            }
            if (type instanceof BrAPIReferenceType) {
                BrAPIReferenceType brAPIReferenceType = (BrAPIReferenceType)type;
                return this.createInputReferenceType(brAPIReferenceType).mapResult(t -> t);
            }
            if (type instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)type;
                return this.createEnumType(brAPIEnumType).mapResult(t -> t);
            }
            if (type instanceof BrAPIPrimitiveType) {
                BrAPIPrimitiveType brAPIPrimitiveType = (BrAPIPrimitiveType)type;
                return this.createScalarType(brAPIPrimitiveType).mapResult(t -> t);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown input type '%s' for '%s'", type.getClass().getSimpleName(), type.getName()));
        }

        private Response<GraphQLInputObjectField> createInputObjectField(BrAPIObjectProperty property) {
            GraphQLInputObjectField.Builder builder;
            BrAPIClass brAPIClass;
            BrAPIType brAPIType = property.getType();
            if (brAPIType instanceof BrAPIClass && this.isPrimaryModel(brAPIClass = (BrAPIClass)brAPIType)) {
                builder = GraphQLInputObjectField.newInputObjectField().name(this.options.getProperties().getIds().getIDFieldFor(property.getType())).description(property.getDescription()).type((GraphQLInputType)(this.options.isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString));
                return Response.success(builder.build());
            }
            builder = GraphQLInputObjectField.newInputObjectField().name(property.getName()).description(property.getDescription());
            return this.createInputType(property.getType()).onSuccessDoWithResult(arg_0 -> ((GraphQLInputObjectField.Builder)builder).type(arg_0)).map(() -> Response.success(builder.build()));
        }

        private Response<GraphQLInputObjectField> createExternalReferencesInputObjectField() {
            return Response.success(GraphQLInputObjectField.newInputObjectField().name("externalReferences").description("Filter by External References").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)"ExternalReferenceInput"))).build());
        }

        private Response<GraphQLNamedOutputType> createOutputType(BrAPIOneOfType type) {
            GraphQLUnionType existingType = this.unionTypes.get(type.getName());
            if (existingType != null) {
                return Response.success(existingType);
            }
            GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType().name(type.getName()).description(type.getDescription());
            return type.getPossibleTypes().stream().map(this::createNamedOutputType).collect(Response.toList()).onSuccessDoWithResult(arg_0 -> ((GraphQLUnionType.Builder)builder).replacePossibleTypes(arg_0)).map(() -> this.addUnionType(builder.build())).mapResult(result -> result);
        }

        private Response<GraphQLNamedOutputType> createNamedOutputType(BrAPIType type) {
            try {
                return this.createOutputType(type).mapResult(t -> (GraphQLNamedOutputType)t);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Type can not be cast to GraphQLNamedOutputType, due to '%s'", e));
            }
        }

        private Response<GraphQLEnumType> createEnumType(BrAPIEnumType type) {
            GraphQLEnumType existingType = this.enumTypes.get(type.getName());
            if (existingType != null) {
                return Response.success(existingType);
            }
            return this.addEnumType(GraphQLEnumType.newEnum().name(type.getName()).description(type.getDescription()).values(type.getValues().stream().map(this::createEnumValue).toList()).build());
        }

        private GraphQLEnumValueDefinition createEnumValue(BrAPIEnumValue brAPIEnumValue) {
            return GraphQLEnumValueDefinition.newEnumValueDefinition().name(StringUtils.makeValidName(brAPIEnumValue.getName())).value(brAPIEnumValue.getValue()).build();
        }

        private Response<GraphQLScalarType> createScalarType(BrAPIPrimitiveType type) {
            return switch (type.getName()) {
                case "string" -> Response.success(Scalars.GraphQLString);
                case "integer" -> Response.success(Scalars.GraphQLInt);
                case "number" -> Response.success(Scalars.GraphQLFloat);
                case "boolean" -> Response.success(Scalars.GraphQLBoolean);
                default -> Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown primitive type '%s'", type.getName()));
            };
        }

        private Response<GraphQLObjectType> addObjectType(GraphQLObjectType type) {
            this.objectOutputTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private Response<GraphQLInterfaceType> addInterfaceType(GraphQLInterfaceType type) {
            this.interfaceTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private Response<GraphQLUnionType> addUnionType(GraphQLUnionType type) {
            this.unionTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private Response<GraphQLEnumType> addEnumType(GraphQLEnumType type) {
            this.enumTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private Response<GraphQLNamedInputType> addInputObjectType(GraphQLNamedInputType type) {
            this.inputTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private GraphQLFieldDefinition.Builder generateSingleGraphQLQuery(GraphQLObjectType type) {
            return GraphQLFieldDefinition.newFieldDefinition().name(this.options.getSingleQueryNameFor(type.getName())).description(this.createSingleQueryDescription(type)).arguments(this.createSingleQueryArguments(type)).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)type.getName()));
        }

        private String createSingleQueryDescription(GraphQLObjectType type) {
            return this.options.getQueryType().getSingleQuery().getDescriptionFor(type.getName());
        }

        private List<GraphQLArgument> createSingleQueryArguments(GraphQLObjectType type) {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            arguments.add(GraphQLArgument.newArgument().name(this.options.getProperties().getIds().getNameFor(type.getName())).type((GraphQLInputType)(this.options.isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString)).build());
            if (this.options.getQueryType().isPartitionedByCrop()) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            return arguments;
        }

        private GraphQLFieldDefinition.Builder generateListGraphQLQuery(GraphQLObjectType type) {
            String queryName = this.options.getListQueryNameFor(type.getName());
            boolean paged = this.options.getQueryType().getListQuery().isPagedFor(type.getName());
            boolean hasInput = this.options.getQueryType().getListQuery().hasInputFor(type.getName());
            return GraphQLFieldDefinition.newFieldDefinition().name(queryName).description(this.createListQueryDescription(type)).arguments(this.createListQueryArguments(paged, hasInput, type.getName())).type(this.createListResponse(paged, type));
        }

        private String createListQueryDescription(GraphQLObjectType type) {
            return this.options.getQueryType().getListQuery().getDescriptionFor(type.getName());
        }

        private List<GraphQLArgument> createListQueryArguments(boolean paged, boolean hasInput, String typeName) {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            String inputTypeName = this.options.getQueryInputTypeNameFor(typeName);
            if (hasInput) {
                arguments.add(GraphQLArgument.newArgument().name(this.options.getQueryInputParameterNameFor(typeName)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)inputTypeName)).build());
            }
            if (this.options.getQueryType().isPartitionedByCrop() && !this.hasField(inputTypeName, "commonCropName")) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            if (paged) {
                arguments.add(GraphQLArgument.newArgument().name(this.options.getQueryType().getListQuery().getPagingInputName()).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)this.options.getQueryType().getListQuery().getPageInputTypeName())).build());
            }
            return arguments;
        }

        private BrAPIType unwrapType(BrAPIType type) {
            BrAPIReferenceType brAPIReferenceType;
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                return this.unwrapType(brAPIArrayType.getItems());
            }
            if (type instanceof BrAPIReferenceType && this.brAPISchemas.containsKey((brAPIReferenceType = (BrAPIReferenceType)type).getName())) {
                return this.brAPISchemas.get(brAPIReferenceType.getName());
            }
            return type;
        }

        private boolean hasField(String typeName, String fieldName) {
            GraphQLNamedInputType type = this.inputTypes.get(typeName);
            if (type instanceof GraphQLInputObjectType) {
                GraphQLInputObjectType graphQLInputObjectType = (GraphQLInputObjectType)type;
                return graphQLInputObjectType.getField(fieldName) == null;
            }
            return false;
        }

        private GraphQLOutputType createListResponse(boolean paged, GraphQLObjectType graphQLObjectType) {
            String name = String.format(this.options.getQueryType().getListQuery().getResponseTypeNameForType(graphQLObjectType.getName()), new Object[0]);
            if (this.objectOutputTypes.containsKey(name)) {
                return (GraphQLOutputType)this.objectOutputTypes.get(name);
            }
            GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(name).field(this.createListDataField(graphQLObjectType));
            if (paged) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name(this.options.getQueryType().getListQuery().getPageFieldName()).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)this.options.getQueryType().getListQuery().getPageTypeName())).build());
            }
            this.listResponseTypesToBeCreated.remove(name);
            return (GraphQLOutputType)this.addObjectType(builder.build()).getResult();
        }

        private GraphQLFieldDefinition createListDataField(GraphQLObjectType graphQLObjectType) {
            return GraphQLFieldDefinition.newFieldDefinition().name(this.options.getQueryType().getListQuery().getDataFieldName()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)graphQLObjectType.getName()))).build();
        }

        private GraphQLType createPageInputType() {
            return GraphQLInputObjectType.newInputObject().name(this.options.getQueryType().getListQuery().getPageInputTypeName()).field(GraphQLInputObjectField.newInputObjectField().name("page").type((GraphQLInputType)Scalars.GraphQLInt)).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt)).build();
        }

        private GraphQLType createPageType() {
            return GraphQLObjectType.newObject().name(this.options.getQueryType().getListQuery().getPageTypeName()).field(GraphQLFieldDefinition.newFieldDefinition().name("currentPage").type((GraphQLOutputType)Scalars.GraphQLInt)).field(GraphQLFieldDefinition.newFieldDefinition().name("pageSize").type((GraphQLOutputType)Scalars.GraphQLInt)).field(GraphQLFieldDefinition.newFieldDefinition().name("totalCount").type((GraphQLOutputType)Scalars.GraphQLInt)).field(GraphQLFieldDefinition.newFieldDefinition().name("totalPages").type((GraphQLOutputType)Scalars.GraphQLInt)).build();
        }

        private GraphQLFieldDefinition.Builder generateSearchGraphQLQuery(GraphQLObjectType graphQLObjectType) {
            String queryName = this.options.getSearchQueryNameFor(graphQLObjectType.getName());
            return GraphQLFieldDefinition.newFieldDefinition().name(queryName).description(this.createSearchQueryDescription(graphQLObjectType)).arguments(this.createSearchQueryArguments(graphQLObjectType)).type(this.createSearchResponse(queryName, graphQLObjectType));
        }

        private String createSearchQueryDescription(GraphQLObjectType graphQLObjectType) {
            return this.options.getQueryType().getSearchQuery().getDescriptionFor(graphQLObjectType.getName());
        }

        private List<GraphQLArgument> createSearchQueryArguments(GraphQLObjectType graphQLObjectType) {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            String inputTypeName = this.options.getQueryInputTypeNameFor(graphQLObjectType.getName());
            arguments.add(GraphQLArgument.newArgument().name(this.options.getInput().getNameFor(graphQLObjectType.getName())).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)inputTypeName)).build());
            if (this.options.getQueryType().isPartitionedByCrop() && !this.hasField(inputTypeName, "commonCropName")) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            return arguments;
        }

        private GraphQLOutputType createSearchResponse(String queryName, GraphQLObjectType type) {
            GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(String.format(this.options.getQueryType().getSearchQuery().getResponseTypeNameForQuery(queryName), new Object[0])).field(GraphQLFieldDefinition.newFieldDefinition().name(this.options.getQueryType().getSearchQuery().getSearchIdFieldName()).type((GraphQLOutputType)Scalars.GraphQLString).build()).field(this.createListDataField(type));
            return builder.build();
        }

        private GraphQLFieldDefinition.Builder generateCreateGraphQLMutation(GraphQLObjectType graphQLObjectType) {
            return GraphQLFieldDefinition.newFieldDefinition().name(this.options.getCreateMutationNameFor(graphQLObjectType.getName())).description(this.createCreateMutationDescription(graphQLObjectType)).arguments(this.createCreateMutationArguments(graphQLObjectType)).type((GraphQLOutputType)(this.options.getMutationType().getCreateMutation().isMultiple() ? GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())) : GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())));
        }

        private String createCreateMutationDescription(GraphQLObjectType graphQLObjectType) {
            return this.options.getMutationType().getCreateMutation().getDescriptionFor(graphQLObjectType.getName());
        }

        private List<GraphQLArgument> createCreateMutationArguments(GraphQLObjectType graphQLObjectType) {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            String inputTypeName = this.options.getInput().getTypeNameFor(graphQLObjectType.getName());
            arguments.add(GraphQLArgument.newArgument().name(this.options.getInput().getNameFor(graphQLObjectType.getName())).type((GraphQLInputType)(this.options.getMutationType().getCreateMutation().isMultiple() ? GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)inputTypeName)) : GraphQLTypeReference.typeRef((String)inputTypeName))).build());
            if (this.options.getQueryType().isPartitionedByCrop() && !this.hasField(inputTypeName, "commonCropName")) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            return arguments;
        }

        private GraphQLFieldDefinition.Builder generateUpdateGraphQLMutation(GraphQLObjectType graphQLObjectType) {
            return GraphQLFieldDefinition.newFieldDefinition().name(this.options.getUpdateMutationNameFor(graphQLObjectType.getName())).description(this.createUpdateMutationDescription(graphQLObjectType)).arguments(this.createUpdateMutationArguments(graphQLObjectType)).type((GraphQLOutputType)(this.options.getMutationType().getUpdateMutation().isMultiple() ? GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())) : GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())));
        }

        private String createUpdateMutationDescription(GraphQLObjectType graphQLObjectType) {
            return this.options.getMutationType().getUpdateMutation().getDescriptionFor(graphQLObjectType.getName());
        }

        private List<GraphQLArgument> createUpdateMutationArguments(GraphQLObjectType graphQLObjectType) {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            String inputTypeName = this.options.getInput().getTypeNameFor(graphQLObjectType.getName());
            arguments.add(GraphQLArgument.newArgument().name(this.options.getInput().getNameFor(graphQLObjectType.getName())).type((GraphQLInputType)(this.options.getMutationType().getCreateMutation().isMultiple() ? GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)inputTypeName)) : GraphQLTypeReference.typeRef((String)inputTypeName))).build());
            if (this.options.getQueryType().isPartitionedByCrop() && !this.hasField(inputTypeName, "commonCropName")) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            return arguments;
        }

        private Response<GraphQLFieldDefinition.Builder> generateDeleteGraphQLMutation(GraphQLObjectType graphQLObjectType) {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(this.options.getDeleteMutationNameFor(graphQLObjectType.getName())).description(this.createDeleteMutationDescription(graphQLObjectType)).type((GraphQLOutputType)(this.options.getMutationType().getDeleteMutation().isMultiple() ? GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())) : GraphQLTypeReference.typeRef((String)graphQLObjectType.getName())));
            return this.createDeleteMutationArguments(graphQLObjectType).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).arguments(arg_0)).withResult(builder);
        }

        private String createDeleteMutationDescription(GraphQLObjectType graphQLObjectType) {
            return this.options.getMutationType().getDeleteMutation().getDescriptionFor(graphQLObjectType.getName());
        }

        private Response<List<GraphQLArgument>> createDeleteMutationArguments(GraphQLObjectType graphQLObjectType) {
            GraphQLScalarType idType;
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            String idField = this.options.getProperties().getIds().getIDFieldFor(graphQLObjectType.getName());
            if (graphQLObjectType.getFields().stream().noneMatch(field -> field.getName().equals(idField))) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find field '%s' in type '%s'", idField, graphQLObjectType.getName()));
            }
            GraphQLScalarType graphQLScalarType = idType = this.options.isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString;
            if (this.options.getMutationType().getDeleteMutation().isMultiple()) {
                arguments.add(GraphQLArgument.newArgument().name(StringUtils.toPlural(idField)).type((GraphQLInputType)GraphQLList.list((GraphQLType)idType)).build());
            } else {
                arguments.add(GraphQLArgument.newArgument().name(this.options.getProperties().getIds().getNameFor(graphQLObjectType.getName())).type((GraphQLInputType)idType).build());
            }
            if (this.options.getQueryType().isPartitionedByCrop()) {
                arguments.add(GraphQLArgument.newArgument().name("commonCropName").type((GraphQLInputType)Scalars.GraphQLString).build());
            }
            return Response.success(arguments);
        }

        public GraphQLGeneratorOptions getOptions() {
            return this.options;
        }

        public GraphQLGeneratorMetadata getMetadata() {
            return this.metadata;
        }

        public Map<String, BrAPIClass> getBrAPISchemas() {
            return this.brAPISchemas;
        }

        public Map<String, GraphQLObjectType> getObjectOutputTypes() {
            return this.objectOutputTypes;
        }

        public Map<String, GraphQLInterfaceType> getInterfaceTypes() {
            return this.interfaceTypes;
        }

        public Map<String, GraphQLUnionType> getUnionTypes() {
            return this.unionTypes;
        }

        public Map<String, GraphQLEnumType> getEnumTypes() {
            return this.enumTypes;
        }

        public Map<String, GraphQLNamedInputType> getInputTypes() {
            return this.inputTypes;
        }

        public Map<String, String> getListResponseTypesToBeCreated() {
            return this.listResponseTypesToBeCreated;
        }

        public Map<String, String> getInputObjectTypeForListQueryToBeCreated() {
            return this.inputObjectTypeForListQueryToBeCreated;
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }
    }

    private static class InterfaceTypeResolver
    implements TypeResolver {
        private GraphQLInterfaceType interfaceType;

        public GraphQLObjectType getType(TypeResolutionEnvironment schemaName) {
            return (GraphQLObjectType)this.interfaceType.getChildren().get(0);
        }

        public InterfaceTypeResolver(GraphQLInterfaceType interfaceType) {
            this.interfaceType = interfaceType;
        }
    }

    private static class UnionTypeResolver
    implements TypeResolver {
        private GraphQLUnionType unionType;

        public GraphQLObjectType getType(TypeResolutionEnvironment schemaName) {
            return (GraphQLObjectType)this.unionType.getTypes().get(0);
        }

        public UnionTypeResolver(GraphQLUnionType unionType) {
            this.unionType = unionType;
        }
    }
}

