/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.graphql.options.AbstractGraphQLOptions;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class AbstractGraphQLQueryOptions
extends AbstractGraphQLOptions {
    private String responseTypeNameFormat;
    private Map<String, Boolean> input = new HashMap<String, Boolean>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.responseTypeNameFormat, "'responseTypeNameFormat' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.input, "'input' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(AbstractGraphQLQueryOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.responseTypeNameFormat != null) {
            this.setResponseTypeNameFormat(overrideOptions.responseTypeNameFormat);
        }
        this.input.putAll(overrideOptions.input);
    }

    @JsonIgnore
    public final String getResponseTypeNameForType(@NonNull String typeName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        return String.format(this.responseTypeNameFormat, typeName);
    }

    @JsonIgnore
    public final String getResponseTypeNameForQuery(@NonNull String queryName) {
        if (queryName == null) {
            throw new NullPointerException("queryName is marked non-null but is null");
        }
        return String.format(this.responseTypeNameFormat, StringUtils.toSentenceCase(queryName));
    }

    @JsonIgnore
    public final boolean hasInputFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.input.getOrDefault(name, true);
    }

    @JsonIgnore
    public final boolean hasInputFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.hasInputFor(type.getName());
    }

    @JsonIgnore
    public AbstractGraphQLQueryOptions setInputFor(String name, boolean hasInput) {
        this.input.put(name, hasInput);
        return this;
    }

    public void setResponseTypeNameFormat(String responseTypeNameFormat) {
        this.responseTypeNameFormat = responseTypeNameFormat;
    }

    protected AbstractGraphQLQueryOptions() {
    }

    protected AbstractGraphQLQueryOptions(String responseTypeNameFormat, Map<String, Boolean> input) {
        this.responseTypeNameFormat = responseTypeNameFormat;
        this.input = input;
    }

    private String getResponseTypeNameFormat() {
        return this.responseTypeNameFormat;
    }

    private void setInput(Map<String, Boolean> input) {
        this.input = input;
    }
}

