/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import java.util.Arrays;
import java.util.Optional;
import org.brapi.schematools.core.response.Response;

public enum LinkType {
    EMBEDDED("embedded"),
    ID("id"),
    SUB_QUERY("sub-query"),
    NONE("none");

    private final String label;

    public static Optional<LinkType> findByNameOrLabel(String value) {
        return Arrays.stream(LinkType.values()).filter(provider -> provider.name().equals(value) || provider.getLabel().equals(value)).findAny();
    }

    public static Response<LinkType> fromNameOrLabels(String value) {
        return LinkType.findByNameOrLabel(value).map(Response::success).orElseGet(() -> Response.fail(Response.ErrorType.VALIDATION, String.format("No LinkType found for value [%s]", value)));
    }

    private LinkType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }
}

