/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.graphql.options.AbstractGraphQLQueryOptions;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.validiation.Validation;

public class ListQueryOptions
extends AbstractGraphQLQueryOptions {
    private String dataFieldName;
    private Boolean pagedDefault;
    private Map<String, Boolean> paged = new HashMap<String, Boolean>();
    private String pagingInputName;
    private String pageInputTypeName;
    private String pageTypeName;
    private String pageFieldName;

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.dataFieldName, "'dataFieldName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pagedDefault, "'pagedDefault' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.paged, "'paged' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pagingInputName, "'pagingInputName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pageInputTypeName, "'pageInputTypeName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pageTypeName, "'pageTypeName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pageFieldName, "'pageFieldName' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(ListQueryOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.dataFieldName != null) {
            this.setDataFieldName(overrideOptions.dataFieldName);
        }
        if (overrideOptions.pagedDefault != null) {
            this.setPagedDefault(overrideOptions.pagedDefault);
        }
        this.paged.putAll(overrideOptions.paged);
        if (overrideOptions.pagingInputName != null) {
            this.setPagingInputName(overrideOptions.pagingInputName);
        }
        if (overrideOptions.pageInputTypeName != null) {
            this.setPageInputTypeName(overrideOptions.pageInputTypeName);
        }
        if (overrideOptions.pageTypeName != null) {
            this.setPageTypeName(overrideOptions.pageTypeName);
        }
        if (overrideOptions.pageFieldName != null) {
            this.setPageFieldName(overrideOptions.pageFieldName);
        }
    }

    @JsonIgnore
    public boolean hasPaging() {
        return this.pagedDefault != false || this.paged.values().stream().anyMatch(paged -> paged);
    }

    @JsonIgnore
    public final boolean isPagedFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.paged.getOrDefault(name, this.pagedDefault);
    }

    @JsonIgnore
    public final boolean isPagedFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isPagedFor(type.getName());
    }

    @JsonIgnore
    public final ListQueryOptions setPagedFor(String name, boolean hasInput) {
        this.paged.put(name, hasInput);
        return this;
    }

    public String getDataFieldName() {
        return this.dataFieldName;
    }

    public String getPagingInputName() {
        return this.pagingInputName;
    }

    public String getPageInputTypeName() {
        return this.pageInputTypeName;
    }

    public String getPageTypeName() {
        return this.pageTypeName;
    }

    public String getPageFieldName() {
        return this.pageFieldName;
    }

    public void setDataFieldName(String dataFieldName) {
        this.dataFieldName = dataFieldName;
    }

    public void setPagedDefault(Boolean pagedDefault) {
        this.pagedDefault = pagedDefault;
    }

    public void setPagingInputName(String pagingInputName) {
        this.pagingInputName = pagingInputName;
    }

    public void setPageInputTypeName(String pageInputTypeName) {
        this.pageInputTypeName = pageInputTypeName;
    }

    public void setPageTypeName(String pageTypeName) {
        this.pageTypeName = pageTypeName;
    }

    public void setPageFieldName(String pageFieldName) {
        this.pageFieldName = pageFieldName;
    }

    private ListQueryOptions() {
    }

    private ListQueryOptions(String dataFieldName, Boolean pagedDefault, Map<String, Boolean> paged, String pagingInputName, String pageInputTypeName, String pageTypeName, String pageFieldName) {
        this.dataFieldName = dataFieldName;
        this.pagedDefault = pagedDefault;
        this.paged = paged;
        this.pagingInputName = pagingInputName;
        this.pageInputTypeName = pageInputTypeName;
        this.pageTypeName = pageTypeName;
        this.pageFieldName = pageFieldName;
    }

    private Boolean getPagedDefault() {
        return this.pagedDefault;
    }

    private void setPaged(Map<String, Boolean> paged) {
        this.paged = paged;
    }
}

