/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.markdown;

import com.fasterxml.jackson.annotation.JsonIgnore;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.brapi.schematools.core.markdown.GraphQLMarkdownGeneratorOptions;
import org.brapi.schematools.core.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLMarkdownGenerator {
    private static final Logger log = LoggerFactory.getLogger(GraphQLMarkdownGenerator.class);
    private Path outputPath;
    private GraphQLMarkdownGeneratorOptions options;
    public static final Pattern LIST_RESPONSE_PATTERN = Pattern.compile("(\\w+)ListResponse");
    public static final Pattern SEARCH_RESPONSE_PATTERN = Pattern.compile("(\\w+)SearchResponse");
    public static final Pattern RESPONSE_PATTERN = Pattern.compile("(\\w+)Response");
    public static final Pattern INPUT_PATTERN = Pattern.compile("(\\w+)Input");

    private GraphQLMarkdownGenerator(Path outputPath) {
        this.outputPath = outputPath;
    }

    public static GraphQLMarkdownGenerator generator(Path outputPath) {
        return new GraphQLMarkdownGenerator(outputPath);
    }

    public GraphQLMarkdownGenerator outputPath(Path outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    public GraphQLMarkdownGenerator options(GraphQLMarkdownGeneratorOptions options) {
        this.options = options;
        return this;
    }

    public Response<List<Path>> generate(GraphQLSchema schema) {
        return new Generator(schema).generate();
    }

    public GraphQLMarkdownGenerator(Path outputPath, GraphQLMarkdownGeneratorOptions options) {
        this.outputPath = outputPath;
        this.options = options;
    }

    private class Generator {
        private final Path typeDescriptionsPath;
        private final Path typeFieldsPath;
        private final Path queryDescriptionsPath;
        private final Path queryArgumentsPath;
        private final GraphQLSchema graphQLSchema;
        private final Map<String, GraphQLFieldDefinition> queryDefinitions;
        private final Map<String, GraphQLFieldDefinition> duplicateObjectFieldDefinitions;
        private final Map<String, GraphQLInputObjectField> duplicateInputObjectFieldDefinitions;
        private final Map<String, GraphQLArgument> duplicateQueryArgumentDefinitions;
        private final Pattern ignoreQueryNamePattern;
        private final Pattern ignoreTypeNamePattern;

        public Generator(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
            Path typeDefinitionsPath = GraphQLMarkdownGenerator.this.options.getTypeDefinitionsDirectory().isEmpty() ? GraphQLMarkdownGenerator.this.outputPath : GraphQLMarkdownGenerator.this.outputPath.resolve(GraphQLMarkdownGenerator.this.options.getTypeDefinitionsDirectory());
            this.typeDescriptionsPath = typeDefinitionsPath.resolve(GraphQLMarkdownGenerator.this.options.getDescriptionsDirectory());
            this.typeFieldsPath = typeDefinitionsPath.resolve(GraphQLMarkdownGenerator.this.options.getFieldsDirectory());
            Path queryDefinitionsPath = GraphQLMarkdownGenerator.this.options.getQueryDefinitionsDirectory().isEmpty() ? GraphQLMarkdownGenerator.this.outputPath : GraphQLMarkdownGenerator.this.outputPath.resolve(GraphQLMarkdownGenerator.this.options.getQueryDefinitionsDirectory());
            this.queryDescriptionsPath = queryDefinitionsPath.resolve(GraphQLMarkdownGenerator.this.options.getDescriptionsDirectory());
            this.queryArgumentsPath = queryDefinitionsPath.resolve(GraphQLMarkdownGenerator.this.options.getArgumentsDirectory());
            this.ignoreQueryNamePattern = GraphQLMarkdownGenerator.this.options.getIgnoreQueryNamePattern() != null ? Pattern.compile(GraphQLMarkdownGenerator.this.options.getIgnoreQueryNamePattern()) : null;
            this.ignoreTypeNamePattern = GraphQLMarkdownGenerator.this.options.getIgnoreTypeNamePattern() != null ? Pattern.compile(GraphQLMarkdownGenerator.this.options.getIgnoreTypeNamePattern()) : null;
            ArrayList objectFieldDefinitions = new ArrayList(graphQLSchema.getAllTypesAsList().stream().filter(type -> type instanceof GraphQLObjectType).flatMap(type -> ((GraphQLObjectType)type).getFields().stream()).toList());
            objectFieldDefinitions.addAll(graphQLSchema.getAllTypesAsList().stream().filter(type -> type instanceof GraphQLInterfaceType).flatMap(type -> ((GraphQLInterfaceType)type).getFields().stream()).toList());
            this.duplicateObjectFieldDefinitions = new TreeMap(objectFieldDefinitions.stream().collect(Collectors.groupingBy(GraphQLFieldDefinition::getName)).values().stream().filter(fields -> fields.size() > 1).map(List::getFirst).collect(Collectors.toMap(GraphQLFieldDefinition::getName, Function.identity())));
            TreeMap<String, List<GraphQLInputObjectField>> inputObjectFieldDefinitions = new TreeMap<String, List<GraphQLInputObjectField>>(graphQLSchema.getAllTypesAsList().stream().filter(type -> type instanceof GraphQLInputObjectType).flatMap(type -> ((GraphQLInputObjectType)type).getFields().stream()).collect(Collectors.groupingBy(GraphQLInputObjectField::getName)));
            this.duplicateInputObjectFieldDefinitions = new TreeMap(inputObjectFieldDefinitions.values().stream().filter(fields -> fields.size() > 1).map(List::getFirst).collect(Collectors.toMap(GraphQLInputObjectField::getName, UnaryOperator.identity())));
            this.queryDefinitions = new TreeMap(graphQLSchema.getQueryType().getFields().stream().collect(Collectors.toMap(queryDefinition -> queryDefinition.getName().toLowerCase(), UnaryOperator.identity())));
            TreeMap<String, List<GraphQLArgument>> queryArgumentDefinitions = new TreeMap<String, List<GraphQLArgument>>(graphQLSchema.getQueryType().getFields().stream().flatMap(queryDefinition -> queryDefinition.getArguments().stream()).collect(Collectors.groupingBy(GraphQLArgument::getName)));
            this.duplicateQueryArgumentDefinitions = new TreeMap(queryArgumentDefinitions.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("input") && ((List)entry.getValue()).size() > 1).map(Map.Entry::getValue).map(List::getFirst).collect(Collectors.toMap(GraphQLArgument::getName, UnaryOperator.identity())));
        }

        public Response<List<Path>> generate() {
            try {
                Files.createDirectories(this.typeDescriptionsPath, new FileAttribute[0]);
                Files.createDirectories(this.typeFieldsPath, new FileAttribute[0]);
                Files.createDirectories(this.queryDescriptionsPath, new FileAttribute[0]);
                Files.createDirectories(this.queryArgumentsPath, new FileAttribute[0]);
                return this.generateMarkdownFiles(this.graphQLSchema);
            }
            catch (Exception e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private Response<List<Path>> generateMarkdownFiles(GraphQLSchema graphQLSchema) {
            LinkedList generatedPaths = new LinkedList();
            return Response.empty().mapOnCondition(GraphQLMarkdownGenerator.this.options.isCreatingTopLevelFieldDefinitions(), () -> this.duplicateObjectFieldDefinitions.values().stream().map(this::generateMarkdownForTopLevelField).collect(Response.mergeLists()).mapResult(generatedPaths::addAll)).mapOnCondition(GraphQLMarkdownGenerator.this.options.isCreatingTopLevelInputFieldDefinitions(), () -> this.duplicateInputObjectFieldDefinitions.values().stream().map(this::generateMarkdownForTopLevelField).collect(Response.mergeLists()).mapResult(generatedPaths::addAll)).mapOnCondition(GraphQLMarkdownGenerator.this.options.isCreatingTopLevelArgumentDefinitions(), () -> this.duplicateQueryArgumentDefinitions.values().stream().map(this::generateMarkdownForTopLevelArgument).collect(Response.mergeLists()).mapResult(generatedPaths::addAll)).map(() -> graphQLSchema.getAllTypesAsList().stream().filter(type -> this.isGeneratingDescriptionForType(type.getName())).map(this::generateTypeMarkdown).collect(Response.mergeLists()).mapResult(generatedPaths::addAll)).map(() -> graphQLSchema.getQueryType().getFields().stream().filter(query -> this.isGeneratingDescriptionQuery(query.getName())).map(this::generateQueryMarkdown).collect(Response.mergeLists()).mapResult(generatedPaths::addAll)).map(() -> Response.success(generatedPaths));
        }

        private Response<List<Path>> generateTypeMarkdown(GraphQLNamedType graphQLNamedType) {
            if (graphQLNamedType instanceof GraphQLObjectType) {
                GraphQLObjectType graphQLObjectType = (GraphQLObjectType)graphQLNamedType;
                return this.generateMarkdownForObjectType(graphQLObjectType);
            }
            if (graphQLNamedType instanceof GraphQLInputObjectType) {
                GraphQLInputObjectType graphQLInputObjectType = (GraphQLInputObjectType)graphQLNamedType;
                return this.generateMarkdownForInputObjectType(graphQLInputObjectType);
            }
            if (graphQLNamedType instanceof GraphQLInterfaceType) {
                GraphQLInterfaceType graphQLInterfaceType = (GraphQLInterfaceType)graphQLNamedType;
                return this.generateMarkdownForInterfaceType(graphQLInterfaceType);
            }
            if (graphQLNamedType instanceof GraphQLEnumType) {
                GraphQLEnumType graphQLEnumType = (GraphQLEnumType)graphQLNamedType;
                return this.generateMarkdownForEnumType(graphQLEnumType);
            }
            if (graphQLNamedType instanceof GraphQLScalarType) {
                return Response.empty();
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown type '%s' with class '%s'", graphQLNamedType.getName(), graphQLNamedType.getClass().getSimpleName()));
        }

        private Response<List<Path>> generateMarkdownForObjectType(GraphQLObjectType objectType) {
            Matcher matcher = LIST_RESPONSE_PATTERN.matcher(objectType.getName());
            Object queryName = null;
            if (matcher.matches()) {
                queryName = matcher.group(1);
            } else if (matcher.matches()) {
                matcher = SEARCH_RESPONSE_PATTERN.matcher(objectType.getName());
                queryName = matcher.group(1) + "Search";
            } else {
                matcher = RESPONSE_PATTERN.matcher(objectType.getName());
            }
            GraphQLFieldDefinition queryDefinition = queryName != null ? this.queryDefinitions.get(((String)queryName).toLowerCase()) : null;
            GraphQLOutputType dataType = matcher.matches() ? this.findEntityFromResponse((GraphQLType)objectType) : null;
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.typeDescriptionsPath.resolve(String.format("%s.md", objectType.getName()));
            return this.writeToFile(descriptionPath, objectType.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForObjectType(objectType, dataType, queryDefinition)).onSuccessDoWithResult(paths::addAll).map(() -> this.generateMarkdownForFields((GraphQLNamedType)objectType, objectType.getFields())).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private Response<List<Path>> generateMarkdownForInputObjectType(GraphQLInputObjectType objectType) {
            Matcher matcher = INPUT_PATTERN.matcher(objectType.getName());
            GraphQLFieldDefinition queryDefinition = matcher.matches() ? this.queryDefinitions.get(matcher.group(1).toLowerCase()) : null;
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.typeDescriptionsPath.resolve(String.format("%s.md", objectType.getName()));
            return this.writeToFile(descriptionPath, objectType.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForInputObjectType(objectType, queryDefinition)).onSuccessDoWithResult(paths::addAll).map(() -> this.generateMarkdownForInputFields(objectType, queryDefinition, objectType.getFields())).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private Response<List<Path>> generateQueryMarkdown(GraphQLFieldDefinition queryDefinition) {
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.queryDescriptionsPath.resolve(String.format("%s.md", queryDefinition.getName()));
            GraphQLOutputType dataType = this.findEntityFromResponse((GraphQLType)queryDefinition.getType());
            GraphQLInputType inputType = queryDefinition.getArgument("input") != null ? queryDefinition.getArgument("input").getType() : null;
            return this.writeToFile(descriptionPath, this.graphQLSchema.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForQuery(queryDefinition, dataType, inputType)).onSuccessDoWithResult(paths::addAll).map(() -> this.generateMarkdownForArguments(queryDefinition, queryDefinition.getArguments())).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private GraphQLOutputType findEntityFromResponse(GraphQLType type) {
            if (type instanceof GraphQLObjectType) {
                GraphQLObjectType graphQLObjectType = (GraphQLObjectType)type;
                return graphQLObjectType.getField("data") != null ? graphQLObjectType.getField("data").getType() : null;
            }
            if (type instanceof GraphQLList) {
                GraphQLList graphQLList = (GraphQLList)type;
                return this.findEntityFromResponse(graphQLList.getWrappedType());
            }
            if (type instanceof GraphQLNonNull) {
                GraphQLNonNull graphQLNonNull = (GraphQLNonNull)type;
                return this.findEntityFromResponse(graphQLNonNull.getWrappedType());
            }
            return null;
        }

        private Response<List<Path>> generateMarkdownForTopLevelField(GraphQLFieldDefinition field) {
            Path fieldPath = this.typeFieldsPath.resolve(String.format("%s.md", field.getName()));
            return this.writeToFile(fieldPath, field.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForField(null, field));
        }

        private Response<List<Path>> generateMarkdownForTopLevelField(GraphQLInputObjectField field) {
            Path fieldPath = this.typeFieldsPath.resolve(String.format("%s.md", field.getName()));
            return this.writeToFile(fieldPath, field.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForInputField(null, null, field));
        }

        private Response<List<Path>> generateMarkdownForFields(GraphQLNamedType type, List<GraphQLFieldDefinition> fields) {
            return fields.stream().map(field -> this.generateMarkdownForField(type, (GraphQLFieldDefinition)field)).collect(Response.mergeLists());
        }

        private Response<List<Path>> generateMarkdownForField(GraphQLNamedType type, GraphQLFieldDefinition field) {
            if (!GraphQLMarkdownGenerator.this.options.isCreatingTopLevelFieldDefinitions() || !this.duplicateObjectFieldDefinitions.containsKey(field.getName())) {
                return this.createPath(this.typeFieldsPath, type.getName(), String.format("%s.md", field.getName())).mapResultToResponse(filePath -> this.writeToFile((Path)filePath, field.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForField(type, field)));
            }
            log.warn("Skipping duplicate field '{}' in type '{}', it was created in top level", (Object)type.getName(), (Object)field.getName());
            return Response.success(Collections.emptyList());
        }

        private Response<Path> createPath(Path parentPath, String directory, String file) {
            Path path = parentPath.resolve(directory);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                return Response.success(path.resolve(file));
            }
            catch (IOException e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private Response<List<Path>> generateMarkdownForInputFields(GraphQLInputObjectType type, GraphQLFieldDefinition queryDefinition, List<GraphQLInputObjectField> fields) {
            return fields.stream().map(field -> this.generateMarkdownForInputField(type, queryDefinition, (GraphQLInputObjectField)field)).collect(Response.mergeLists());
        }

        private Response<List<Path>> generateMarkdownForInputField(GraphQLInputObjectType type, GraphQLFieldDefinition queryDefinition, GraphQLInputObjectField field) {
            if (!GraphQLMarkdownGenerator.this.options.isCreatingTopLevelInputFieldDefinitions() || !this.duplicateInputObjectFieldDefinitions.containsKey(field.getName())) {
                return this.createPath(this.typeFieldsPath, type.getName(), String.format("%s.md", field.getName())).mapResultToResponse(filePath -> this.writeToFile((Path)filePath, field.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForInputField(type, queryDefinition, field)));
            }
            log.warn("Skipping duplicate field '{}' in type '{}', it was created in top level", (Object)type.getName(), (Object)field.getName());
            return Response.success(Collections.emptyList());
        }

        private Response<List<Path>> generateMarkdownForInterfaceType(GraphQLInterfaceType interfaceType) {
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.typeDescriptionsPath.resolve(String.format("%s.md", interfaceType.getName()));
            return this.writeToFile(descriptionPath, interfaceType.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForInterface(interfaceType)).onSuccessDoWithResult(paths::addAll).map(() -> this.generateMarkdownForFields((GraphQLNamedType)interfaceType, interfaceType.getFieldDefinitions())).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private Response<List<Path>> generateMarkdownForEnumType(GraphQLEnumType graphQLEnumType) {
            ArrayList paths = new ArrayList();
            Path descriptionPath = this.typeDescriptionsPath.resolve(String.format("%s.md", graphQLEnumType.getName()));
            return this.writeToFile(descriptionPath, graphQLEnumType.getDescription(), () -> this.createEnumDescription(graphQLEnumType)).onSuccessDoWithResult(paths::addAll).map(() -> Response.success(paths));
        }

        private Response<List<Path>> generateMarkdownForTopLevelArgument(GraphQLArgument argument) {
            Path fieldPath = this.queryArgumentsPath.resolve(String.format("%s.md", argument.getName()));
            return this.writeToFile(fieldPath, argument.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForArgument(null, argument));
        }

        private Response<List<Path>> generateMarkdownForArguments(GraphQLFieldDefinition queryDefinition, List<GraphQLArgument> arguments) {
            return arguments.stream().map(argument -> this.generateMarkdownForArgument(queryDefinition, (GraphQLArgument)argument)).collect(Response.mergeLists());
        }

        private Response<List<Path>> generateMarkdownForArgument(GraphQLFieldDefinition queryDefinition, GraphQLArgument argument) {
            if (!GraphQLMarkdownGenerator.this.options.isCreatingTopLevelArgumentDefinitions() || !this.duplicateQueryArgumentDefinitions.containsKey(argument.getName())) {
                return this.createPath(this.queryArgumentsPath, queryDefinition.getName(), String.format("%s.md", argument.getName())).mapResultToResponse(filePath -> this.writeToFile((Path)filePath, argument.getDescription(), () -> GraphQLMarkdownGenerator.this.options.getDescriptionForArgument(queryDefinition, argument)));
            }
            log.warn("Skipping duplicate argument '{}' in query '{}', it was created in top level", (Object)argument.getName(), (Object)queryDefinition.getName());
            return Response.success(Collections.emptyList());
        }

        private String createEnumDescription(GraphQLEnumType graphQLEnumType) {
            StringBuilder description = new StringBuilder(graphQLEnumType.getDescription() != null ? graphQLEnumType.getDescription() : GraphQLMarkdownGenerator.this.options.getDescriptionForEnum(graphQLEnumType));
            description.append("\n\n Possible values are: \n");
            for (GraphQLEnumValueDefinition value : graphQLEnumType.getValues()) {
                description.append("* ").append(value.getName()).append("\n");
            }
            return description.toString();
        }

        private Response<List<Path>> writeToFile(Path path, String implementationText, Supplier<String> descriptionProvider) {
            try {
                if (GraphQLMarkdownGenerator.this.options.isOverwritingExistingFiles() && Files.exists(path, new LinkOption[0])) {
                    log.warn("Output file '{}' already exists and was not overwritten", (Object)path);
                    return Response.success(Collections.emptyList());
                }
                PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]));
                printWriter.println(descriptionProvider.get());
                if (implementationText != null) {
                    printWriter.println();
                    printWriter.println("# Implementation");
                    printWriter.println(implementationText);
                }
                printWriter.close();
                return Response.success(Collections.singletonList(path));
            }
            catch (IOException exception) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not write to file due to %s", exception.getMessage()));
            }
        }

        @JsonIgnore
        public boolean isGeneratingDescriptionQuery(String name) {
            return this.ignoreQueryNamePattern == null || !this.ignoreQueryNamePattern.matcher(name).matches();
        }

        @JsonIgnore
        public boolean isGeneratingDescriptionForType(String name) {
            return this.ignoreTypeNamePattern == null || !this.ignoreTypeNamePattern.matcher(name).matches();
        }
    }
}

