/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BrAPIMetadata {
    private final boolean primaryModel;
    private final boolean request;
    private final boolean parameters;
    @JsonProperty(value="interface")
    private final boolean interfaceClass;
    private final List<String> controlledVocabularyProperties;

    BrAPIMetadata(boolean primaryModel, boolean request, boolean parameters, boolean interfaceClass, List<String> controlledVocabularyProperties) {
        this.primaryModel = primaryModel;
        this.request = request;
        this.parameters = parameters;
        this.interfaceClass = interfaceClass;
        this.controlledVocabularyProperties = controlledVocabularyProperties;
    }

    public static BrAPIMetadataBuilder builder() {
        return new BrAPIMetadataBuilder();
    }

    public BrAPIMetadataBuilder toBuilder() {
        return new BrAPIMetadataBuilder().primaryModel(this.primaryModel).request(this.request).parameters(this.parameters).interfaceClass(this.interfaceClass).controlledVocabularyProperties(this.controlledVocabularyProperties);
    }

    public boolean isPrimaryModel() {
        return this.primaryModel;
    }

    public boolean isRequest() {
        return this.request;
    }

    public boolean isParameters() {
        return this.parameters;
    }

    public boolean isInterfaceClass() {
        return this.interfaceClass;
    }

    public List<String> getControlledVocabularyProperties() {
        return this.controlledVocabularyProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrAPIMetadata)) {
            return false;
        }
        BrAPIMetadata other = (BrAPIMetadata)o;
        if (this.isPrimaryModel() != other.isPrimaryModel()) {
            return false;
        }
        if (this.isRequest() != other.isRequest()) {
            return false;
        }
        if (this.isParameters() != other.isParameters()) {
            return false;
        }
        if (this.isInterfaceClass() != other.isInterfaceClass()) {
            return false;
        }
        List<String> this$controlledVocabularyProperties = this.getControlledVocabularyProperties();
        List<String> other$controlledVocabularyProperties = other.getControlledVocabularyProperties();
        return !(this$controlledVocabularyProperties == null ? other$controlledVocabularyProperties != null : !((Object)this$controlledVocabularyProperties).equals(other$controlledVocabularyProperties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimaryModel() ? 79 : 97);
        result = result * 59 + (this.isRequest() ? 79 : 97);
        result = result * 59 + (this.isParameters() ? 79 : 97);
        result = result * 59 + (this.isInterfaceClass() ? 79 : 97);
        List<String> $controlledVocabularyProperties = this.getControlledVocabularyProperties();
        result = result * 59 + ($controlledVocabularyProperties == null ? 43 : ((Object)$controlledVocabularyProperties).hashCode());
        return result;
    }

    public String toString() {
        return "BrAPIMetadata(primaryModel=" + this.isPrimaryModel() + ", request=" + this.isRequest() + ", parameters=" + this.isParameters() + ", interfaceClass=" + this.isInterfaceClass() + ", controlledVocabularyProperties=" + String.valueOf(this.getControlledVocabularyProperties()) + ")";
    }

    public static class BrAPIMetadataBuilder {
        private boolean primaryModel;
        private boolean request;
        private boolean parameters;
        private boolean interfaceClass;
        private List<String> controlledVocabularyProperties;

        BrAPIMetadataBuilder() {
        }

        public BrAPIMetadataBuilder primaryModel(boolean primaryModel) {
            this.primaryModel = primaryModel;
            return this;
        }

        public BrAPIMetadataBuilder request(boolean request) {
            this.request = request;
            return this;
        }

        public BrAPIMetadataBuilder parameters(boolean parameters) {
            this.parameters = parameters;
            return this;
        }

        @JsonProperty(value="interface")
        public BrAPIMetadataBuilder interfaceClass(boolean interfaceClass) {
            this.interfaceClass = interfaceClass;
            return this;
        }

        public BrAPIMetadataBuilder controlledVocabularyProperties(List<String> controlledVocabularyProperties) {
            this.controlledVocabularyProperties = controlledVocabularyProperties;
            return this;
        }

        public BrAPIMetadata build() {
            return new BrAPIMetadata(this.primaryModel, this.request, this.parameters, this.interfaceClass, this.controlledVocabularyProperties);
        }

        public String toString() {
            return "BrAPIMetadata.BrAPIMetadataBuilder(primaryModel=" + this.primaryModel + ", request=" + this.request + ", parameters=" + this.parameters + ", interfaceClass=" + this.interfaceClass + ", controlledVocabularyProperties=" + String.valueOf(this.controlledVocabularyProperties) + ")";
        }
    }
}

