/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.ontmodel;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontapi.OntModelFactory;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.ontmodel.metadata.OntModelGeneratorMetadata;
import org.brapi.schematools.core.ontmodel.options.OntModelGeneratorOptions;
import org.brapi.schematools.core.response.Response;

public class OntModelGenerator {
    private final BrAPISchemaReader schemaReader;
    private final OntModelGeneratorOptions options;

    public OntModelGenerator() {
        this(new BrAPISchemaReader(), OntModelGeneratorOptions.load());
    }

    public OntModelGenerator(OntModelGeneratorOptions options) {
        this(new BrAPISchemaReader(), options);
    }

    public Response<OntModel> generate(Path schemaDirectory) {
        return this.generate(schemaDirectory, new OntModelGeneratorMetadata());
    }

    public Response<OntModel> generate(Path schemaDirectory, OntModelGeneratorMetadata metadata) {
        return this.options.validate().asResponse().merge(this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator(this.options, metadata, (List<BrAPIClass>)brAPISchemas).generate()));
    }

    public OntModelGenerator(BrAPISchemaReader schemaReader, OntModelGeneratorOptions options) {
        this.schemaReader = schemaReader;
        this.options = options;
    }

    private static class Generator {
        private final OntModelGeneratorOptions options;
        private final OntModelGeneratorMetadata metadata;
        private final Map<String, BrAPIClass> brAPISchemas;
        private final OntModel model;
        private final String namespace;
        private final String language;
        private final HashMap<String, BrAPIClass> types;
        private final HashMap<String, OntClass> ontClasses;

        public Generator(OntModelGeneratorOptions options, OntModelGeneratorMetadata metadata, List<BrAPIClass> brAPISchemas) {
            this.options = options;
            this.metadata = metadata;
            this.namespace = metadata.getNamespace();
            this.language = metadata.getLanguage();
            this.model = OntModelFactory.createModel();
            this.model.setID(this.namespace);
            HashMap<String, BrAPIClass> map = new HashMap<String, BrAPIClass>();
            for (BrAPIClass brAPISchema : brAPISchemas) {
                if (map.put(brAPISchema.getName(), brAPISchema) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            this.brAPISchemas = map;
            this.types = new HashMap();
            this.ontClasses = new HashMap();
        }

        public Response<OntModel> generate() {
            return this.brAPISchemas.values().stream().filter(this::isGenerating).map(this::createClass).collect(Response.toList()).map(this::updateClasses).map(() -> Response.success(this.model));
        }

        private boolean isGenerating(BrAPIClass brAPIClass) {
            return brAPIClass.getMetadata() == null || !brAPIClass.getMetadata().isRequest() && !brAPIClass.getMetadata().isParameters();
        }

        private Response<Boolean> createClass(BrAPIType brAPIType) {
            if (brAPIType instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIType;
                return this.createObjectType(brAPIObjectType);
            }
            if (brAPIType instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIType;
                return this.createOneOfType(brAPIOneOfType);
            }
            if (brAPIType instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)brAPIType;
                return this.createEnumType(brAPIEnumType);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown supported BrAPI Type '%s'", brAPIType.getName()));
        }

        private Response<Boolean> createObjectType(BrAPIObjectType brAPIObjectType) {
            OntClass ontClass = this.createOntClass(brAPIObjectType);
            return brAPIObjectType.getProperties().stream().map(property -> this.createClassForType(property.getType())).collect(Response.toList()).map(() -> Response.success(true));
        }

        private Response<Boolean> createOneOfType(BrAPIOneOfType brAPIOneOfType) {
            this.types.put(brAPIOneOfType.getName(), brAPIOneOfType);
            return brAPIOneOfType.getPossibleTypes().stream().map(this::createClass).collect(Response.toList()).map(() -> Response.success(false));
        }

        private Response<Boolean> createEnumType(BrAPIEnumType brAPIEnumType) {
            OntClass ontClass = this.createOntClass(brAPIEnumType);
            return brAPIEnumType.getValues().stream().map(enumValue -> this.createOntIndividual(ontClass, (BrAPIEnumValue)enumValue)).collect(Response.toList()).mapResult(x$0 -> this.model.createObjectOneOf(x$0)).map(() -> Response.success(true));
        }

        private OntClass createOntClass(BrAPIClass brAPIClass) {
            this.types.put(brAPIClass.getName(), brAPIClass);
            OntClass.Named ontClass = this.model.createOntClass(this.createURIForBrAPIType(brAPIClass));
            ontClass.addLabel(brAPIClass.getName(), this.language);
            if (brAPIClass.getDescription() != null) {
                ontClass.addComment(brAPIClass.getDescription(), this.language);
            }
            this.ontClasses.put(brAPIClass.getName(), (OntClass)ontClass);
            return ontClass;
        }

        private Response<Boolean> createClassForType(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)type;
                return this.createObjectType(brAPIObjectType);
            }
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                BrAPIType itemsType = brAPIArrayType.getItems();
                while (itemsType instanceof BrAPIArrayType) {
                    BrAPIArrayType brAPIArrayItemsType = (BrAPIArrayType)itemsType;
                    itemsType = brAPIArrayItemsType.getItems();
                }
                return this.createClassForType(itemsType);
            }
            if (type instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)type;
                return this.createEnumType(brAPIEnumType);
            }
            return Response.success(false);
        }

        private Response<List<OntClass>> updateClasses() {
            return this.ontClasses.values().stream().map(this::updateClass).collect(Response.toList());
        }

        private Response<OntClass> updateClass(OntClass ontClass) {
            BrAPIClass brAPIClass = this.types.get(ontClass.getLabel());
            if (brAPIClass instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                return brAPIObjectType.getProperties().stream().map(property -> this.createProperty(ontClass, (BrAPIObjectProperty)property)).collect(Response.toList()).map(() -> Response.success(ontClass));
            }
            if (brAPIClass instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIClass;
                return Response.success(ontClass);
            }
            if (brAPIClass instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)brAPIClass;
                return Response.success(ontClass);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown BrAPI Class '%s'", brAPIClass.getName()));
        }

        private Response<OntRelationalProperty> createProperty(OntClass ontClass, BrAPIObjectProperty property) {
            return this.createProperty(ontClass, property, property.getType());
        }

        private Response<OntRelationalProperty> createProperty(OntClass ontClass, BrAPIObjectProperty property, BrAPIType brAPIType) {
            if (brAPIType instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIType;
                return this.findReferencedClass(brAPIObjectType.getName()).mapResultToResponse(childClass -> this.createObjectProperty(ontClass, (OntClass)childClass, property));
            }
            if (brAPIType instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)brAPIType;
                BrAPIType itemsType = brAPIArrayType.getItems();
                AtomicInteger dimension = new AtomicInteger(1);
                while (itemsType instanceof BrAPIArrayType) {
                    BrAPIArrayType brAPIArrayItemsType = (BrAPIArrayType)itemsType;
                    itemsType = brAPIArrayItemsType.getItems();
                    dimension.incrementAndGet();
                }
                return this.createProperty(ontClass, property, itemsType).mapResultToResponse(ontRelationalProperty -> this.updateProperty((OntRelationalProperty)ontRelationalProperty, dimension.get()));
            }
            if (brAPIType instanceof BrAPIReferenceType) {
                BrAPIReferenceType brAPIReferenceType = (BrAPIReferenceType)brAPIType;
                return this.findReferencedBrAPIType(brAPIReferenceType.getName()).mapResultToResponse(referencedBrAPIType -> this.createProperty(ontClass, property, (BrAPIType)referencedBrAPIType));
            }
            if (brAPIType instanceof BrAPIOneOfType) {
                BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIType;
                return brAPIOneOfType.getPossibleTypes().stream().map(type -> this.findReferencedClass(type.getName())).collect(Response.toList()).mapResultToResponse(childClasses -> this.createObjectProperty(ontClass, (List<OntClass>)childClasses, property));
            }
            if (brAPIType instanceof BrAPIEnumType) {
                BrAPIEnumType brAPIEnumType = (BrAPIEnumType)brAPIType;
                return this.findReferencedClass(brAPIEnumType.getName()).mapResultToResponse(childClass -> this.createObjectProperty(ontClass, (OntClass)childClass, property));
            }
            if (brAPIType instanceof BrAPIPrimitiveType) {
                return this.createDataProperty(ontClass, property, brAPIType);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown BrAPI Type '%s'", brAPIType.getName()));
        }

        private Response<OntRelationalProperty> updateProperty(OntRelationalProperty ontRelationalProperty, int dimension) {
            return Response.success(ontRelationalProperty);
        }

        private Response<OntRelationalProperty> createObjectProperty(OntClass domain, OntClass range, BrAPIObjectProperty property) {
            OntObjectProperty.Named objectProperty = this.model.createObjectProperty(this.createURIForBrAPIObjectProperty(domain, property));
            objectProperty.addDomain(domain);
            objectProperty.addRange(range);
            objectProperty.addLabel(property.getName(), this.language);
            if (property.getDescription() != null) {
                objectProperty.addComment(property.getDescription(), this.language);
            }
            return Response.success(objectProperty);
        }

        private Response<OntRelationalProperty> createObjectProperty(OntClass domain, List<OntClass> ranges, BrAPIObjectProperty property) {
            OntObjectProperty.Named objectProperty = this.model.createObjectProperty(this.createURIForBrAPIObjectProperty(domain, property));
            objectProperty.addDomain(domain);
            ranges.forEach(arg_0 -> ((OntObjectProperty)objectProperty).addRange(arg_0));
            objectProperty.addLabel(property.getName(), this.language);
            if (property.getDescription() != null) {
                objectProperty.addComment(property.getDescription(), this.language);
            }
            return Response.success(objectProperty);
        }

        private Response<OntRelationalProperty> createDataProperty(OntClass domain, BrAPIObjectProperty property, BrAPIType type) {
            OntDataRange.Named datatype;
            OntDataProperty dataProperty = this.model.createDataProperty(this.createURIForBrAPIObjectProperty(domain, property));
            dataProperty.addDomain(domain);
            dataProperty.addLabel(property.getName(), this.language);
            if (property.getDescription() != null) {
                dataProperty.addComment(property.getDescription(), this.language);
            }
            switch (type.getName()) {
                case "string": {
                    OntDataRange.Named named = this.model.getDatatype(XSDDatatype.XSDstring.getURI());
                    break;
                }
                case "integer": {
                    OntDataRange.Named named = this.model.getDatatype(XSDDatatype.XSDinteger.getURI());
                    break;
                }
                case "number": {
                    OntDataRange.Named named = this.model.getDatatype(XSDDatatype.XSDdouble.getURI());
                    break;
                }
                case "boolean": {
                    OntDataRange.Named named = this.model.getDatatype(XSDDatatype.XSDboolean.getURI());
                    break;
                }
                default: {
                    OntDataRange.Named named = datatype = null;
                }
            }
            if (datatype == null) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find XSDDatatype for '%s' in property '%s'", property.getType().getName(), property.getName()));
            }
            dataProperty.addRange((OntDataRange)datatype);
            return Response.success(dataProperty);
        }

        private Response<BrAPIType> findReferencedBrAPIType(String name) {
            BrAPIType referencedBrAPIType = this.types.get(name);
            if (referencedBrAPIType != null) {
                return Response.success(referencedBrAPIType);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find referenced BrAPI type '%s'", name));
        }

        private Response<OntClass> findReferencedClass(String name) {
            OntClass referencedClass = this.ontClasses.get(name);
            if (referencedClass != null) {
                return Response.success(referencedClass);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not find referenced class '%s'", name));
        }

        private Response<OntIndividual> createOntIndividual(OntClass ontClass, BrAPIEnumValue enumValue) {
            return Response.success(ontClass.createIndividual(this.createURIForBrAPIEnumValue(enumValue)));
        }

        private String createURIForBrAPIObjectProperty(OntClass ontClass, BrAPIObjectProperty property) {
            return String.format("%s/%s", ontClass.getURI(), property.getName());
        }

        private String createURIForBrAPIType(BrAPIType brAPIType) {
            return String.format("%s/%s", this.namespace, brAPIType.getName());
        }

        private String createURIForBrAPIEnumValue(BrAPIEnumValue enumValue) {
            return String.format("%s/%s", this.namespace, enumValue.getName());
        }

        public OntModelGeneratorOptions getOptions() {
            return this.options;
        }

        public OntModelGeneratorMetadata getMetadata() {
            return this.metadata;
        }

        public Map<String, BrAPIClass> getBrAPISchemas() {
            return this.brAPISchemas;
        }

        public OntModel getModel() {
            return this.model;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLanguage() {
            return this.language;
        }

        public HashMap<String, BrAPIClass> getTypes() {
            return this.types;
        }

        public HashMap<String, OntClass> getOntClasses() {
            return this.ontClasses;
        }
    }
}

