/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.BrAPIObjectTypeWithProperty;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class ControlledVocabularyOptions
implements Options {
    private Boolean generate;
    private String summaryFormat;
    private String descriptionFormat;
    private Map<String, Map<String, Boolean>> generateFor = new HashMap<String, Map<String, Boolean>>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.generate, "'generate' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.generateFor, "'generateFor' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.descriptionFormat, "'descriptionFormat' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.summaryFormat, "'summaryFormat' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(ControlledVocabularyOptions overrideOptions) {
        if (overrideOptions.generate != null) {
            this.setGenerate(overrideOptions.generate);
        }
        if (overrideOptions.descriptionFormat != null) {
            this.setDescriptionFormat(overrideOptions.descriptionFormat);
        }
        if (overrideOptions.summaryFormat != null) {
            this.setSummaryFormat(overrideOptions.summaryFormat);
        }
        if (overrideOptions.generateFor != null) {
            overrideOptions.generateFor.forEach((key, value) -> {
                if (this.generateFor.containsKey(key)) {
                    this.generateFor.get(key).putAll((Map<String, Boolean>)value);
                } else {
                    this.generateFor.put((String)key, new HashMap(value));
                }
            });
        }
    }

    @JsonIgnore
    public final boolean isGenerating() {
        return this.generate != null && this.generate != false || this.generateFor.values().stream().anyMatch(value -> value.containsValue(Boolean.TRUE));
    }

    @JsonIgnore
    public final boolean isGeneratingFor(@NonNull String typeName, @NonNull String propertyName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        Map<String, Boolean> map = this.generateFor.get(typeName);
        if (map != null) {
            return map.getOrDefault(propertyName, this.generate);
        }
        return this.generate;
    }

    @JsonIgnore
    public final boolean isGeneratingFor(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.isGeneratingFor(type.getName(), property.getName());
    }

    @JsonIgnore
    public boolean isGeneratingFor(@NonNull BrAPIObjectTypeWithProperty typeWithProperty) {
        if (typeWithProperty == null) {
            throw new NullPointerException("typeWithProperty is marked non-null but is null");
        }
        return this.isGeneratingFor(typeWithProperty.getType(), typeWithProperty.getProperty());
    }

    @JsonIgnore
    public ControlledVocabularyOptions setGenerateFor(String typeName, String propertyName, boolean generate) {
        Map<String, Boolean> map = this.generateFor.get(typeName);
        if (map != null) {
            map.put(propertyName, generate);
            return this;
        }
        map = new HashMap<String, Boolean>();
        map.put(propertyName, generate);
        this.generateFor.put(typeName, map);
        return this;
    }

    @JsonIgnore
    public ControlledVocabularyOptions setGenerateFor(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property, boolean generate) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.setGenerateFor(type.getName(), property.getName(), generate);
    }

    @JsonIgnore
    public final String getDescriptionFor(@NonNull String typeName, @NonNull String propertyName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return StringUtils.format(this.descriptionFormat, Map.of("type", typeName, "property", StringUtils.toPlural(propertyName)));
    }

    @JsonIgnore
    public final String getDescriptionFor(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.getDescriptionFor(type.getName(), property.getName());
    }

    @JsonIgnore
    public final String getSummaryFor(@NonNull String typeName, @NonNull String propertyName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return StringUtils.format(this.summaryFormat, Map.of("type", typeName, "property", StringUtils.toPlural(propertyName)));
    }

    @JsonIgnore
    public final String getSummaryFor(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.getSummaryFor(type.getName(), property.getName());
    }

    private Boolean getGenerate() {
        return this.generate;
    }

    private String getSummaryFormat() {
        return this.summaryFormat;
    }

    private String getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public void setGenerate(Boolean generate) {
        this.generate = generate;
    }

    public void setSummaryFormat(String summaryFormat) {
        this.summaryFormat = summaryFormat;
    }

    public void setDescriptionFormat(String descriptionFormat) {
        this.descriptionFormat = descriptionFormat;
    }

    private void setGenerateFor(Map<String, Map<String, Boolean>> generateFor) {
        this.generateFor = generateFor;
    }
}

