/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.openapi.generator.BrAPIObjectTypeWithProperty;
import org.brapi.schematools.core.openapi.generator.LinkType;
import org.brapi.schematools.core.openapi.generator.options.ControlledVocabularyOptions;
import org.brapi.schematools.core.openapi.generator.options.DeleteOptions;
import org.brapi.schematools.core.openapi.generator.options.ListGetOptions;
import org.brapi.schematools.core.openapi.generator.options.PostOptions;
import org.brapi.schematools.core.openapi.generator.options.PutOptions;
import org.brapi.schematools.core.openapi.generator.options.SearchOptions;
import org.brapi.schematools.core.openapi.generator.options.SingleGetOptions;
import org.brapi.schematools.core.options.AbstractGeneratorOptions;
import org.brapi.schematools.core.options.PropertiesOptions;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class OpenAPIGeneratorOptions
extends AbstractGeneratorOptions {
    private SingleGetOptions singleGet;
    private ListGetOptions listGet;
    private PostOptions post;
    private PutOptions put;
    private DeleteOptions delete;
    private SearchOptions search;
    private PropertiesOptions properties;
    private ControlledVocabularyOptions controlledVocabulary;
    private String supplementalSpecification;
    private Map<String, String> supplementalSpecificationFor = new HashMap<String, String>();
    private Boolean separateByModule;
    private Boolean generateNewRequest;
    private Map<String, Boolean> generateNewRequestFor = new HashMap<String, Boolean>();
    private String newRequestNameFormat;
    private String singleResponseNameFormat;
    private String listResponseNameFormat;
    private String searchRequestNameFormat;
    private Map<String, String> pathItemNameFor = new HashMap<String, String>();
    private Map<String, Map<String, String>> pathItemNameForProperty = new HashMap<String, Map<String, String>>();
    private Map<String, String> tagFor = new HashMap<String, String>();

    public static OpenAPIGeneratorOptions load() {
        try {
            return ConfigurationUtils.load("openapi-options.yaml", OpenAPIGeneratorOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenAPIGeneratorOptions load(Path optionsFile) throws IOException {
        return OpenAPIGeneratorOptions.load().override(ConfigurationUtils.load(optionsFile, OpenAPIGeneratorOptions.class));
    }

    public static OpenAPIGeneratorOptions load(InputStream inputStream) throws IOException {
        return OpenAPIGeneratorOptions.load().override(ConfigurationUtils.load(inputStream, OpenAPIGeneratorOptions.class));
    }

    public OpenAPIGeneratorOptions override(OpenAPIGeneratorOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.singleGet != null) {
            this.singleGet.override(overrideOptions.getSingleGet());
        }
        if (overrideOptions.listGet != null) {
            this.listGet.override(overrideOptions.getListGet());
        }
        if (overrideOptions.post != null) {
            this.post.override(overrideOptions.getPost());
        }
        if (overrideOptions.put != null) {
            this.put.override(overrideOptions.getPut());
        }
        if (overrideOptions.search != null) {
            this.search.override(overrideOptions.getSearch());
        }
        if (overrideOptions.delete != null) {
            this.delete.override(overrideOptions.getDelete());
        }
        if (overrideOptions.properties != null) {
            this.properties.override(overrideOptions.getProperties());
        }
        if (overrideOptions.controlledVocabulary != null) {
            this.controlledVocabulary.override(overrideOptions.getControlledVocabulary());
        }
        if (overrideOptions.separateByModule != null) {
            this.separateByModule = overrideOptions.separateByModule;
        }
        if (overrideOptions.generateNewRequest != null) {
            this.generateNewRequest = overrideOptions.generateNewRequest;
        }
        if (overrideOptions.supplementalSpecification != null) {
            this.supplementalSpecification = overrideOptions.supplementalSpecification;
        }
        if (overrideOptions.supplementalSpecificationFor != null) {
            this.supplementalSpecificationFor.putAll(overrideOptions.supplementalSpecificationFor);
        }
        if (overrideOptions.generateNewRequestFor != null) {
            this.generateNewRequestFor.putAll(overrideOptions.generateNewRequestFor);
        }
        if (overrideOptions.newRequestNameFormat != null) {
            this.newRequestNameFormat = overrideOptions.newRequestNameFormat;
        }
        if (overrideOptions.singleResponseNameFormat != null) {
            this.singleResponseNameFormat = overrideOptions.singleResponseNameFormat;
        }
        if (overrideOptions.listResponseNameFormat != null) {
            this.listResponseNameFormat = overrideOptions.listResponseNameFormat;
        }
        if (overrideOptions.searchRequestNameFormat != null) {
            this.searchRequestNameFormat = overrideOptions.searchRequestNameFormat;
        }
        if (overrideOptions.pathItemNameFor != null) {
            this.pathItemNameFor.putAll(overrideOptions.pathItemNameFor);
        }
        if (overrideOptions.pathItemNameForProperty != null) {
            overrideOptions.pathItemNameForProperty.forEach((key, value) -> {
                if (this.pathItemNameForProperty.containsKey(key)) {
                    this.pathItemNameForProperty.get(key).putAll((Map<String, String>)value);
                } else {
                    this.pathItemNameForProperty.put((String)key, new HashMap(value));
                }
            });
        }
        if (overrideOptions.tagFor != null) {
            this.tagFor.putAll(overrideOptions.tagFor);
        }
        if (overrideOptions.controlledVocabulary != null) {
            this.controlledVocabulary = overrideOptions.controlledVocabulary;
        }
        return this;
    }

    @Override
    public Validation validate() {
        return super.validate().assertNotNull(this.singleGet, "Single Get Endpoint Options are null", new Object[0]).assertNotNull(this.listGet, "List Get Endpoint Options are null", new Object[0]).assertNotNull(this.post, "Post Endpoint Options are null", new Object[0]).assertNotNull(this.put, "Put Endpoint Options are null", new Object[0]).assertNotNull(this.delete, "Delete Endpoint Options are null", new Object[0]).assertNotNull(this.search, "Search Endpoint Options are null", new Object[0]).assertNotNull(this.properties, "Properties Options are null", new Object[0]).assertNotNull(this.controlledVocabulary, "Controlled Vocabulary Options are null", new Object[0]).assertNotNull(this.separateByModule, "'separateByModule' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.generateNewRequest, "'generateNewRequest' option on %s is null", this.getClass().getSimpleName()).merge(this.singleGet).merge(this.listGet).merge(this.post).merge(this.put).merge(this.delete).merge(this.search).merge(this.properties).merge(this.controlledVocabulary).assertNotNull(this.supplementalSpecification, "'supplementalSpecification' option is null", new Object[0]).assertNotNull(this.supplementalSpecificationFor, "'supplementalSpecificationFor' option is null", new Object[0]).assertNotNull(this.generateNewRequestFor, "'generateNewRequestFor' option is null", new Object[0]).assertNotNull(this.newRequestNameFormat, "'newRequestNameFormat' option is null", new Object[0]).assertNotNull(this.singleResponseNameFormat, "'singleResponseNameFormat' option is null", new Object[0]).assertNotNull(this.listResponseNameFormat, "'listResponseNameFormat' option is null", new Object[0]).assertNotNull(this.searchRequestNameFormat, "'searchRequestNameFormat' option is null", new Object[0]).assertNotNull(this.pathItemNameFor, "'pathItemNameFor' option is null", new Object[0]).assertNotNull(this.tagFor, "'tagFor' option is null", new Object[0]);
    }

    @JsonIgnore
    public boolean isSeparatingByModule() {
        return this.separateByModule;
    }

    @JsonIgnore
    public boolean isGeneratingEndpoint() {
        return this.listGet.isGenerating() || this.post.isGenerating() || this.put.isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingEndpointFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.listGet.isGeneratingFor(name) || this.post.isGeneratingFor(name) || this.put.isGeneratingEndpointFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingEndpointFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isGeneratingEndpointFor(type.getName());
    }

    @JsonIgnore
    public boolean isGeneratingEndpointWithId() {
        return this.singleGet.isGenerating() || this.put.isGenerating() || this.delete.isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingEndpointNameWithIdFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.singleGet.isGeneratingFor(name) || this.put.isGeneratingEndpointNameWithIdFor(name) || this.delete.isGeneratingFor(name);
    }

    @JsonIgnore
    public final boolean isGeneratingEndpointNameWithIdFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isGeneratingEndpointNameWithIdFor(type.getName());
    }

    @JsonIgnore
    public String getSupplementalSpecificationFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.supplementalSpecificationFor.getOrDefault(name, this.supplementalSpecification);
    }

    @JsonIgnore
    public boolean isGeneratingNewRequestFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.generateNewRequestFor.getOrDefault(name, this.generateNewRequest);
    }

    @JsonIgnore
    public final boolean isGeneratingNewRequestFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.isGeneratingNewRequestFor(type.getName());
    }

    @JsonIgnore
    public String getNewRequestNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.newRequestNameFormat, name);
    }

    @JsonIgnore
    public final String getNewRequestNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getNewRequestNameFor(type.getName());
    }

    @JsonIgnore
    public String getSingleResponseNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.singleResponseNameFormat, name);
    }

    @JsonIgnore
    public final String getSingleResponseNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getSingleResponseNameFor(type.getName());
    }

    @JsonIgnore
    public final String getListResponseNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.listResponseNameFormat, name);
    }

    @JsonIgnore
    public final String getListResponseNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getListResponseNameFor(type.getName());
    }

    @JsonIgnore
    public final String getListResponseNameFor(@NonNull BrAPIObjectTypeWithProperty typeWithProperty) {
        if (typeWithProperty == null) {
            throw new NullPointerException("typeWithProperty is marked non-null but is null");
        }
        return String.format(this.listResponseNameFormat, String.format("%s%s", typeWithProperty.getType().getName(), StringUtils.toSentenceCase(typeWithProperty.getProperty().getName())));
    }

    @JsonIgnore
    public final String getSearchRequestNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.searchRequestNameFormat, name);
    }

    @JsonIgnore
    public final String getSearchRequestNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getSearchRequestNameFor(type.getName());
    }

    @JsonIgnore
    public final String getSingularForProperty(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return StringUtils.toSingular(propertyName);
    }

    public String getPathItemNameFor(String name) {
        return this.pathItemNameFor.getOrDefault(name, String.format("/%s", StringUtils.toLowerCase(this.getPluralFor(name))));
    }

    public String getPathItemNameFor(BrAPIType type) {
        return this.getPathItemNameFor(type.getName());
    }

    public String getPathItemWithIdNameFor(BrAPIType type) {
        return String.format("%s/{%s}", this.getPathItemNameFor(type), this.properties.getIdPropertyNameFor(type));
    }

    @JsonIgnore
    public final String getPathItemNameForProperty(@NonNull String typeName, @NonNull String propertyName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        Map<String, String> map = this.pathItemNameForProperty.get(typeName);
        String defaultPathItemNameForProperty = String.format("%s/%s", this.getPathItemNameFor(typeName), StringUtils.toPlural(propertyName));
        if (map != null) {
            return map.getOrDefault(propertyName, defaultPathItemNameForProperty);
        }
        return defaultPathItemNameForProperty;
    }

    @JsonIgnore
    public final String getPathItemNameForProperty(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.getPathItemNameForProperty(type.getName(), property.getName());
    }

    @JsonIgnore
    public String getPathItemNameForProperty(@NonNull BrAPIObjectTypeWithProperty typeWithProperty) {
        if (typeWithProperty == null) {
            throw new NullPointerException("typeWithProperty is marked non-null but is null");
        }
        return this.getPathItemNameForProperty(typeWithProperty.getType(), typeWithProperty.getProperty());
    }

    @JsonIgnore
    public OpenAPIGeneratorOptions setPathItemNameForProperty(String typeName, String propertyName, String pathItemName) {
        Map<String, String> map = this.pathItemNameForProperty.get(typeName);
        if (map != null) {
            map.put(propertyName, pathItemName);
            return this;
        }
        map = new HashMap<String, String>();
        map.put(propertyName, pathItemName);
        this.pathItemNameForProperty.put(typeName, map);
        return this;
    }

    @JsonIgnore
    public OpenAPIGeneratorOptions setPathItemNameForProperty(@NonNull BrAPIType type, @NonNull BrAPIObjectProperty property, String pathItemName) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.setPathItemNameForProperty(type.getName(), property.getName(), pathItemName);
    }

    @JsonIgnore
    public final String getTagFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.tagFor.getOrDefault(name, this.getPluralFor(name));
    }

    @JsonIgnore
    public final String getTagFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getTagFor(type.getName());
    }

    @JsonIgnore
    public AbstractGeneratorOptions setTagFor(String name, String tagName) {
        this.tagFor.put(name, tagName);
        return this;
    }

    public boolean isGeneratingSubPathFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        return LinkType.SUB_PATH.equals((Object)this.properties.getLinkTypeFor(type, property));
    }

    public String getSubPathItemNameFor(String pathItemName, BrAPIObjectProperty property) {
        return String.format("%s/%s", pathItemName, StringUtils.toLowerCase(property.getName()));
    }

    public boolean isGeneratingControlledVocabularyEndpoints() {
        return this.controlledVocabulary != null && this.controlledVocabulary.isGenerating();
    }

    public SingleGetOptions getSingleGet() {
        return this.singleGet;
    }

    public ListGetOptions getListGet() {
        return this.listGet;
    }

    public PostOptions getPost() {
        return this.post;
    }

    public PutOptions getPut() {
        return this.put;
    }

    public DeleteOptions getDelete() {
        return this.delete;
    }

    public SearchOptions getSearch() {
        return this.search;
    }

    public PropertiesOptions getProperties() {
        return this.properties;
    }

    public ControlledVocabularyOptions getControlledVocabulary() {
        return this.controlledVocabulary;
    }

    public Map<String, Map<String, String>> getPathItemNameForProperty() {
        return this.pathItemNameForProperty;
    }

    public OpenAPIGeneratorOptions setSupplementalSpecification(String supplementalSpecification) {
        this.supplementalSpecification = supplementalSpecification;
        return this;
    }

    public OpenAPIGeneratorOptions setSeparateByModule(Boolean separateByModule) {
        this.separateByModule = separateByModule;
        return this;
    }

    public OpenAPIGeneratorOptions setGenerateNewRequest(Boolean generateNewRequest) {
        this.generateNewRequest = generateNewRequest;
        return this;
    }

    public OpenAPIGeneratorOptions setNewRequestNameFormat(String newRequestNameFormat) {
        this.newRequestNameFormat = newRequestNameFormat;
        return this;
    }

    public OpenAPIGeneratorOptions setSingleResponseNameFormat(String singleResponseNameFormat) {
        this.singleResponseNameFormat = singleResponseNameFormat;
        return this;
    }

    public OpenAPIGeneratorOptions setListResponseNameFormat(String listResponseNameFormat) {
        this.listResponseNameFormat = listResponseNameFormat;
        return this;
    }

    public OpenAPIGeneratorOptions setSearchRequestNameFormat(String searchRequestNameFormat) {
        this.searchRequestNameFormat = searchRequestNameFormat;
        return this;
    }

    private OpenAPIGeneratorOptions() {
    }

    private OpenAPIGeneratorOptions(SingleGetOptions singleGet, ListGetOptions listGet, PostOptions post, PutOptions put, DeleteOptions delete, SearchOptions search, PropertiesOptions properties, ControlledVocabularyOptions controlledVocabulary, String supplementalSpecification, Map<String, String> supplementalSpecificationFor, Boolean separateByModule, Boolean generateNewRequest, Map<String, Boolean> generateNewRequestFor, String newRequestNameFormat, String singleResponseNameFormat, String listResponseNameFormat, String searchRequestNameFormat, Map<String, String> pathItemNameFor, Map<String, Map<String, String>> pathItemNameForProperty, Map<String, String> tagFor) {
        this.singleGet = singleGet;
        this.listGet = listGet;
        this.post = post;
        this.put = put;
        this.delete = delete;
        this.search = search;
        this.properties = properties;
        this.controlledVocabulary = controlledVocabulary;
        this.supplementalSpecification = supplementalSpecification;
        this.supplementalSpecificationFor = supplementalSpecificationFor;
        this.separateByModule = separateByModule;
        this.generateNewRequest = generateNewRequest;
        this.generateNewRequestFor = generateNewRequestFor;
        this.newRequestNameFormat = newRequestNameFormat;
        this.singleResponseNameFormat = singleResponseNameFormat;
        this.listResponseNameFormat = listResponseNameFormat;
        this.searchRequestNameFormat = searchRequestNameFormat;
        this.pathItemNameFor = pathItemNameFor;
        this.pathItemNameForProperty = pathItemNameForProperty;
        this.tagFor = tagFor;
    }

    private OpenAPIGeneratorOptions setSingleGet(SingleGetOptions singleGet) {
        this.singleGet = singleGet;
        return this;
    }

    private OpenAPIGeneratorOptions setListGet(ListGetOptions listGet) {
        this.listGet = listGet;
        return this;
    }

    private OpenAPIGeneratorOptions setPost(PostOptions post) {
        this.post = post;
        return this;
    }

    private OpenAPIGeneratorOptions setPut(PutOptions put) {
        this.put = put;
        return this;
    }

    private OpenAPIGeneratorOptions setDelete(DeleteOptions delete) {
        this.delete = delete;
        return this;
    }

    private OpenAPIGeneratorOptions setSearch(SearchOptions search) {
        this.search = search;
        return this;
    }

    private OpenAPIGeneratorOptions setProperties(PropertiesOptions properties) {
        this.properties = properties;
        return this;
    }

    private OpenAPIGeneratorOptions setControlledVocabulary(ControlledVocabularyOptions controlledVocabulary) {
        this.controlledVocabulary = controlledVocabulary;
        return this;
    }

    public String getSupplementalSpecification() {
        return this.supplementalSpecification;
    }

    private OpenAPIGeneratorOptions setSupplementalSpecificationFor(Map<String, String> supplementalSpecificationFor) {
        this.supplementalSpecificationFor = supplementalSpecificationFor;
        return this;
    }

    private Boolean getSeparateByModule() {
        return this.separateByModule;
    }

    private Boolean getGenerateNewRequest() {
        return this.generateNewRequest;
    }

    private OpenAPIGeneratorOptions setGenerateNewRequestFor(Map<String, Boolean> generateNewRequestFor) {
        this.generateNewRequestFor = generateNewRequestFor;
        return this;
    }

    private String getNewRequestNameFormat() {
        return this.newRequestNameFormat;
    }

    private String getSingleResponseNameFormat() {
        return this.singleResponseNameFormat;
    }

    private String getListResponseNameFormat() {
        return this.listResponseNameFormat;
    }

    private String getSearchRequestNameFormat() {
        return this.searchRequestNameFormat;
    }

    private OpenAPIGeneratorOptions setPathItemNameFor(Map<String, String> pathItemNameFor) {
        this.pathItemNameFor = pathItemNameFor;
        return this;
    }

    private OpenAPIGeneratorOptions setPathItemNameForProperty(Map<String, Map<String, String>> pathItemNameForProperty) {
        this.pathItemNameForProperty = pathItemNameForProperty;
        return this;
    }

    private OpenAPIGeneratorOptions setTagFor(Map<String, String> tagFor) {
        this.tagFor = tagFor;
        return this;
    }
}

